/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.acti;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.shared.LteHostResolver;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.NetworkParameterFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;

public class ActiIOHandler
extends IOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.acti.ActiIOHandler";
    private int controlPortBase = 6001;
    private Socket controlSocket = null;
    private int statusDO = 0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        boolean isAuthSent = false;
        boolean first = true;
        boolean authResponseReached = false;
        long time = Long.MIN_VALUE;
        InputStream is = null;
        OutputStream os = null;
        byte[] keepAlive = new byte[12];
        keepAlive[0] = 65;
        keepAlive[1] = 67;
        keepAlive[2] = 84;
        keepAlive[3] = 105;
        keepAlive[4] = 48;
        byte[] dioStatus = new byte[12];
        dioStatus[0] = 65;
        dioStatus[1] = 67;
        dioStatus[2] = 84;
        dioStatus[3] = 105;
        dioStatus[4] = 51;
        super.setRunFinished(CLASS_NAME, false);
        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
        this.controlPortBase = this.device.getNumberOfVideoSources() <= 1 ? 6001 : 6010;
        try {
            this.controlSocket = new Socket(this.host, this.controlPortBase);
            os = this.controlSocket.getOutputStream();
            is = this.controlSocket.getInputStream();
            this.controlSocket.setSoTimeout(3);
            this.controlSocket.setKeepAlive(true);
        }
        catch (Exception e) {
            this.logger.error("Error while creating control connection to:" + this.host + ":6001", (Throwable)e);
            this.shutdown();
        }
        try {
            while (!this.isShutdown(CLASS_NAME)) {
                block24: {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception ex) {
                        this.logger.error("Problem while sleeping: " + ex, (Throwable)ex);
                    }
                    if (!isAuthSent) {
                        isAuthSent = true;
                        try {
                            byte[] authorization = new byte[128];
                            System.arraycopy(this.usr.getBytes(), 0, authorization, 0, this.usr.getBytes().length);
                            System.arraycopy(this.pwd.getBytes(), 0, authorization, 64, this.pwd.getBytes().length);
                            authorization[32] = 1;
                            os.write(authorization);
                            os.flush();
                            os.write(dioStatus);
                            os.flush();
                        }
                        catch (Exception e) {
                            this.logger.error("Error while writing authorization/dio_status to control connection on:" + this.controlSocket.toString(), (Throwable)e);
                            break;
                        }
                    }
                    try {
                        if (System.currentTimeMillis() <= time + 10000L) break block24;
                        time = System.currentTimeMillis();
                        os.write(keepAlive);
                        os.flush();
                    }
                    catch (Exception e) {
                        this.logger.error("Error while writing Keep-Alive to control connection on:" + this.controlSocket.toString(), (Throwable)e);
                        break;
                    }
                }
                try {
                    int value;
                    int len;
                    byte[] buffer = new byte[4096];
                    try {
                        len = is.read(buffer);
                    }
                    catch (SocketTimeoutException ste) {
                        continue;
                    }
                    if (len <= 0) continue;
                    if (!authResponseReached) {
                        if (buffer[0] != 0) {
                            this.logger.error("Control Login FAILED on " + this.controlSocket.toString());
                            break;
                        }
                        authResponseReached = true;
                    }
                    if (buffer.length < 13) continue;
                    if (buffer[4] == 51) {
                        if (!first) continue;
                        first = false;
                        this.logger.info("Initial numeric value DI/DO: " + Integer.toBinaryString(buffer[12]) + " received from " + this.controlSocket.toString());
                        for (int i = 0; i < iServices.length / 2; ++i) {
                            value = buffer[12];
                            value = (value & (byte)Math.pow(2.0, i)) >>> i ^ 1;
                            iServices[i * 2].checkInput(value);
                            iServices[i * 2 + 1].checkInput(value);
                        }
                        this.statusDO = buffer[12] >>> 4 & 3;
                        continue;
                    }
                    if (buffer[4] != 52) continue;
                    this.logger.info("Given numeric value for DI: " + Integer.toBinaryString(buffer[12]));
                    for (int i = 0; i < iServices.length / 2; ++i) {
                        value = (buffer[12] & (byte)Math.pow(2.0, i)) >>> i ^ 1;
                        iServices[i * 2].checkInput(value);
                        iServices[i * 2 + 1].checkInput(value);
                    }
                }
                catch (SocketException sex) {
                    if (this.isShutdown(CLASS_NAME)) continue;
                    this.logger.warn((Object)sex, (Throwable)sex);
                    break;
                }
                catch (IOException ioex) {
                    if (this.isShutdown(CLASS_NAME)) continue;
                    this.logger.warn((Object)ioex);
                    break;
                }
                catch (Throwable t) {
                    this.logger.fatal("Unexpected exception", t);
                    break;
                }
            }
        }
        catch (Throwable ex) {
            this.logger.fatal((Object)ex, ex);
        }
        this.logger.info("Thread of " + this + " finished");
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.controlSocket != null) {
            try {
                this.controlSocket.close();
                this.controlSocket = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.shutdown();
        return 0;
    }

    @Override
    public synchronized int writeDigitalOutput(int outputNumber, int value, long holdTime) {
        IOHandler.HoldTimer holdTimer;
        int errorCode = 0;
        DigitalOutputSrv service = super.getDigitalOutputSrv(outputNumber);
        if (service == null) {
            this.logger.error(this + " has no digital output service configured for [" + outputNumber + "]");
            return -21601;
        }
        if (value < 0) {
            this.logger.error("Value [" + value + "] is not valid for " + this);
            return -21601;
        }
        int tempValue = value << outputNumber - 1;
        int mask = (int)Math.pow(2.0, outputNumber - 1);
        this.statusDO &= ~mask;
        tempValue |= this.statusDO;
        StringBuffer url = new StringBuffer("/cgi-bin/mpeg4?USER=");
        url.append(this.usr);
        url.append("&PWD=");
        url.append(this.pwd);
        url.append("&DIO_OUTPUT=0x");
        url.append(Integer.toHexString(tempValue));
        try {
            String resolveHost = new LteHostResolver(this.device.getCore().getLTESupportConfiguration()).resolve(this.host);
            NetworkParameter nwParam = NetworkParameterFactory.createNetworkParameter((String)resolveHost, (int)80, null);
            if (NetworkHelper.readGetRequest((NetworkParameter)nwParam, (String)url.toString(), (int)Integer.MAX_VALUE) == null) {
                this.logger.error("Sending DO request [" + url + "] failed with error [" + errorCode + "]");
                return errorCode;
            }
        }
        catch (Throwable t) {
            this.logger.error("Sending DO request [" + url + "] failed with exception [" + t.getMessage() + "]", t);
            return -20000;
        }
        this.statusDO = tempValue;
        this.logger.info("NEW status DO: " + this.statusDO + " for device on " + this.host);
        if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(outputNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
            this.logger.warn("Creating " + holdTimer + " failed with error [" + errorCode + "]");
            holdTimer.shutdown();
        }
        return 0;
    }
}

