/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.acti;

import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.shared.net.DSCPCommandHandler;
import de.seetec.v5.re.cm.device.video.acti.ActiCameraSrv;
import de.seetec.v5.re.cm.device.video.acti.ActiDevice;
import de.seetec.v5.re.cm.device.video.acti.CameraPosition;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Vector;

public class ActiCameraControl
extends CameraControl {
    private ActiDevice actiDevice;
    private DSCPCommandHandler dscpCommandHandler;
    private int errorCode;

    private boolean isDscpUsed() {
        if (this.actiDevice == null) {
            this.actiDevice = (ActiDevice)((ActiCameraSrv)this.videoSrv).getDevice();
        }
        return this.actiDevice.isDscpUsed();
    }

    private int startDscpCommandHandler() {
        if (this.dscpCommandHandler == null) {
            int ptzChannel;
            try {
                ptzChannel = this.videoSrv.getVideoSourceCnf().getPtzAddress();
            }
            catch (ConfigurationException ex) {
                this.logger.error("Exception while reading camera configuration for " + this + " : " + ex.getMessage());
                return -20001;
            }
            this.dscpCommandHandler = new DSCPCommandHandler(ptzChannel);
        }
        return 0;
    }

    private int sendCameraCommand(String url) {
        byte videoSourceID = 1;
        StringBuilder base = new StringBuilder("/cgi-bin/encoder?");
        if (this.networkParameter.getUserPWD() != null && this.networkParameter.getUserPWD().length == 2) {
            base.append("USER=");
            base.append(this.networkParameter.getUserPWD()[0]);
            base.append("&PWD=");
            base.append(this.networkParameter.getUserPWD()[1]);
        }
        if (this.videoSrv != null && this.videoSrv.getVideoSourceCnf() != null) {
            try {
                videoSourceID = (byte)this.videoSrv.getVideoSourceCnf().getPtzAddress();
            }
            catch (ConfigurationException ce) {
                this.logger.warn("Error when reading 'VideoSourceID' with Message: " + ce.getMessage());
            }
            if (videoSourceID != 1) {
                base.append("&CHANNEL=");
                base.append(videoSourceID);
            }
            base.append("&");
        } else {
            this.logger.warn("'VideoSourceID' not specified. Set to 01.");
            videoSourceID = 1;
        }
        this.videoSrv.notifyForCameraControl();
        if (this.isDscpUsed()) {
            base.append("SERIAL_HEX=").append(url);
        } else {
            base.append(url);
            base.append("&cacheKiller=");
            base.append(System.currentTimeMillis());
        }
        try {
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)base.toString(), (int)Integer.MAX_VALUE, (boolean)true);
        }
        catch (SeeTecException e) {
            this.logger.error("Exception while control on " + this.videoSrv);
            return e.getErrorCode();
        }
        return 0;
    }

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        int zoom;
        int tilt;
        int pan;
        String url = null;
        if (panSpeed != null) {
            this.previousPanSpeed = pan = panSpeed.intValue();
        } else {
            pan = this.previousPanSpeed;
        }
        if (tiltSpeed != null) {
            this.previousTiltSpeed = tilt = tiltSpeed.intValue();
        } else {
            tilt = this.previousTiltSpeed;
        }
        if (zoomSpeed != null) {
            this.previousZoomSpeed = zoom = zoomSpeed.intValue();
        } else {
            zoom = this.previousZoomSpeed;
        }
        if (this.isDscpUsed()) {
            this.errorCode = this.startDscpCommandHandler();
            if (this.errorCode != 0) {
                return this.errorCode;
            }
            if (zoomSpeed != null) {
                url = Basic.byteArrayToHexString((byte[])this.dscpCommandHandler.getZoomSpeedCommand(zoom));
                this.errorCode = this.sendCameraCommand(url);
                if (this.errorCode != 0) {
                    return this.errorCode;
                }
                url = Basic.byteArrayToHexString((byte[])this.dscpCommandHandler.getZoomDirectionCommand(zoom));
                this.errorCode = this.sendCameraCommand(url);
                if (this.errorCode != 0) {
                    return this.errorCode;
                }
            }
            if (panSpeed != null && (this.errorCode = this.sendCameraCommand(url = Basic.byteArrayToHexString((byte[])this.dscpCommandHandler.getPanCommand(pan)))) != 0) {
                return this.errorCode;
            }
            if (tiltSpeed != null && (this.errorCode = this.sendCameraCommand(url = Basic.byteArrayToHexString((byte[])this.dscpCommandHandler.getTiltCommand(tilt)))) != 0) {
                return this.errorCode;
            }
        } else {
            if (zoomSpeed != null) {
                if (zoom != 0) {
                    url = zoom > 0 ? "ZOOM=TELE" : "ZOOM=WIDE";
                    zoom = Math.abs(zoom) / 15000;
                    zoom = zoom < 2 ? 2 : zoom;
                    zoom = zoom > 7 ? 7 : zoom;
                    url = url + "," + zoom;
                } else {
                    url = "ZOOM=STOP";
                }
                this.errorCode = this.sendCameraCommand(url);
                if (this.errorCode != 0) {
                    return this.errorCode;
                }
            }
            if (panSpeed != null || tiltSpeed != null) {
                url = "MOVE=";
                if (tilt != 0) {
                    String string = url = tilt > 0 ? url + "UP" : url + "DOWN";
                }
                if (pan != 0) {
                    url = pan > 0 ? url + "RIGHT" : url + "LEFT";
                    pan = Math.abs(pan) / 20000;
                    pan = pan < 1 ? 1 : pan;
                    pan = pan > 5 ? 5 : pan;
                    url = url + "," + pan;
                }
                if (tilt != 0) {
                    tilt = (tilt = Math.abs(tilt) / 20000) < 1 ? 1 : tilt;
                    tilt = tilt > 5 ? 5 : tilt;
                    url = url + "," + tilt;
                }
                if (pan == 0 && tilt == 0) {
                    return this.sendCameraCommand(url + "STOP,1,1");
                }
            }
            if (panSpeed != null || tiltSpeed != null) {
                return this.sendCameraCommand(url);
            }
        }
        return 0;
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        try {
            CameraPosition camPos = this.calculateZoomAreaPoints(xPosition, yPosition, resolution);
            return this.sendCameraCommand("PIXELS_TO_POSITION=" + camPos.getAbsolut_X() + "," + camPos.getAbsolut_Y() + "," + resolution[0] + "x" + resolution[1]);
        }
        catch (Exception ex) {
            this.logger.error("Exception while reading PTZ configuration for: " + this, (Throwable)ex);
            return 0;
        }
    }

    private CameraPosition calculateZoomAreaPoints(int xPosition, int yPosition, int[] resolutionForZoomArea) {
        CameraPosition camPos = new CameraPosition(0, 0);
        if (resolutionForZoomArea != null) {
            int x = xPosition <= 0 ? 1 : xPosition;
            int y = yPosition <= 0 ? 1 : yPosition;
            x = resolutionForZoomArea[0] / 100 * x;
            y = resolutionForZoomArea[1] / 100 * y;
            camPos.setAbsolut_X(x - resolutionForZoomArea[0] / 2);
            camPos.setAbsolut_Y(-(y - resolutionForZoomArea[1] / 2));
        }
        return camPos;
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    @Override
    public int setContinuousIris(Integer value) {
        if (this.isDscpUsed()) {
            this.errorCode = this.startDscpCommandHandler();
            if (this.errorCode != 0) {
                return this.errorCode;
            }
            String url = Basic.byteArrayToHexString((byte[])this.dscpCommandHandler.getIrisCommand(value));
            this.errorCode = this.sendCameraCommand(url);
            if (this.errorCode != 0) {
                return this.errorCode;
            }
        }
        return 0;
    }

    @Override
    public int setAutoIris(Boolean active) {
        String url;
        if (active == null) {
            this.logger.warn("Argument active is null!");
            return -20002;
        }
        if (this.isDscpUsed()) {
            this.errorCode = this.startDscpCommandHandler();
            if (this.errorCode != 0) {
                return this.errorCode;
            }
            url = Basic.byteArrayToHexString((byte[])this.dscpCommandHandler.getAutoIrisCommand(active));
        } else {
            url = active != false ? "VIDEO_IRIS_MODE=AUTO" : "VIDEO_IRIS_MODE=MANUAL";
        }
        return this.sendCameraCommand(url);
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    @Override
    public int setContinuousFocus(Integer value) {
        String url;
        int focus = 0;
        if (this.isDscpUsed()) {
            this.errorCode = this.startDscpCommandHandler();
            if (this.errorCode != 0) {
                return this.errorCode;
            }
            url = Basic.byteArrayToHexString((byte[])this.dscpCommandHandler.getFocusCommand(value));
        } else {
            url = value != null && (focus = value.intValue()) != 0 ? (focus > 0 ? "FOCUS=NEAR" : "FOCUS=FAR") : "FOCUS=STOP";
            this.sendCameraCommand("FOCUS=MANUAL");
        }
        return this.sendCameraCommand(url);
    }

    @Override
    public int setAutoFocus(Boolean active) {
        String url;
        if (active == null) {
            this.logger.warn("Argument active is null!");
            return -20002;
        }
        if (this.isDscpUsed()) {
            this.errorCode = this.startDscpCommandHandler();
            if (this.errorCode != 0) {
                return this.errorCode;
            }
            url = Basic.byteArrayToHexString((byte[])this.dscpCommandHandler.getAutoFocusCommand(active));
        } else {
            url = active != false ? "FOCUS=AUTO" : "FOCUS=MANUAL";
        }
        return this.sendCameraCommand(url);
    }

    @Override
    public int setZeroLux(Boolean active) {
        if (active == null) {
            this.logger.warn("Argument active is null!");
            return -20002;
        }
        String url = active != false ? "VIDEO_DAYNIGHT_MODE=NIGHT" : "VIDEO_DAYNIGHT_MODE=DAY";
        return this.sendCameraCommand(url);
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        if (active == null) {
            this.logger.warn("Argument active is null!");
            return -20002;
        }
        if (active.booleanValue()) {
            return this.sendCameraCommand("VIDEO_DAYNIGHT_MODE=AUTO");
        }
        return 0;
    }

    @Override
    public int setHomePosition() {
        return this.sendCameraCommand("MOVE=HOME");
    }

    @Override
    public int addPresetPosition(Vector<byte[]> vResult, Long presetID, String presetName) {
        int presetPosition = -1;
        if (this.isDscpUsed()) {
            this.errorCode = this.startDscpCommandHandler();
            if (this.errorCode != 0) {
                return this.errorCode;
            }
            try {
                int i;
                byte[] vector = new byte[223];
                for (i = 0; i < this.presetList.size(); ++i) {
                    PresetCnf presetCnf = this.presetList.elementAt(i);
                    vector[Integer.parseInt((String)presetCnf.getPresetPosition())] = 1;
                }
                for (i = 1; i < vector.length; ++i) {
                    if (vector[i] != 0) continue;
                    presetPosition = i;
                    break;
                }
                if (presetPosition < 0) {
                    this.logger.error("Cannot add preset [ " + presetName + " ], 'cause no more free preset positions are available for " + this);
                    return -21600;
                }
                PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, "" + presetPosition, presetName);
                this.presetList.addElement(presetCnf);
                vResult.addElement(presetCnf.getPresetCnf());
                String url = Basic.byteArrayToHexString((byte[])this.dscpCommandHandler.getAddPresetCommand(presetPosition));
                this.errorCode = this.sendCameraCommand(url);
                if (this.errorCode != 0) {
                    return this.errorCode;
                }
                return 0;
            }
            catch (Throwable ex) {
                this.logger.error((Object)ex, ex);
                this.logger.error("Adding preset [ " + presetName + " ] failed");
                return -21600;
            }
        }
        String DELIMITER = "'";
        int presetLimit = 32;
        if (presetName == null) {
            this.logger.warn("Argument presetName is null!");
            return -20002;
        }
        try {
            int i;
            int bitVector = 0;
            for (i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                bitVector |= 1 << Integer.parseInt(presetCnf.getPresetPosition());
            }
            for (i = 1; i <= presetLimit; ++i) {
                if ((bitVector & 1 << i) != 0) continue;
                presetPosition = i;
                break;
            }
            if (presetPosition < 0) {
                this.logger.error("Cannot add preset [" + presetName + "], 'cause no more free preset positions are available for " + this);
                return -21600;
            }
            if (presetPosition >= 1 && presetPosition <= presetLimit) {
                String ptPosition = "0,0";
                String zPosition = "0";
                try {
                    byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/encoder?USER=Admin&PWD=123456&POSITION_GET&ZOOM_POSITION", (int)Integer.MAX_VALUE);
                    if (result == null) {
                        this.logger.error("Error while control on " + this.videoSrv);
                        return -21600;
                    }
                    String[] parts = new String(result).split("POSITION_GET='");
                    if (parts.length == 2 && parts[1].contains("'")) {
                        ptPosition = parts[1].substring(0, parts[1].indexOf("'"));
                    }
                    if ((parts = new String(result).split("ZOOM_POSITION='")).length == 2 && parts[1].contains("'")) {
                        zPosition = parts[1].substring(0, parts[1].indexOf("'"));
                    }
                }
                catch (SeeTecException e) {
                    this.logger.error("Exception while control on " + this.videoSrv);
                    return e.getErrorCode();
                }
                this.errorCode = this.sendCameraCommand("PTZ_PRESET_SET=" + presetPosition + ",1," + ptPosition + "," + zPosition + ",5,5,7,10," + presetPosition);
                if (this.errorCode != 0) {
                    this.logger.warn("Error setting preset on camera. errorCode: " + this.errorCode);
                    return -21600;
                }
            } else {
                this.logger.warn("presetID has invalid value. Must be 0x01 <= n <= 0x20. Given: " + presetPosition);
                return -21600;
            }
            PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, "" + presetPosition, presetName);
            this.presetList.addElement(presetCnf);
            vResult.addElement(presetCnf.getPresetCnf());
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error("Adding preset [" + presetName + "] failed with Exception: " + ex.getMessage());
            return -21600;
        }
    }

    @Override
    public int setPresetPosition(String presetName) {
        if (presetName == null) {
            this.logger.warn("Argument presetName is null!");
            return -20002;
        }
        try {
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                if (!presetName.equals(presetCnf.getPresetName())) continue;
                if (this.isDscpUsed()) {
                    this.errorCode = this.startDscpCommandHandler();
                    if (this.errorCode != 0) {
                        return this.errorCode;
                    }
                    return this.sendCameraCommand(Basic.byteArrayToHexString((byte[])this.dscpCommandHandler.getGetPresetCommand(Integer.parseInt(presetCnf.getPresetPosition()))));
                }
                return this.sendCameraCommand("PTZ_PRESET_GO=" + Integer.parseInt(presetCnf.getPresetPosition()));
            }
        }
        catch (Exception ex) {
            this.logger.error("Setting preset [" + presetName + "] failed with Exception: " + ex.getMessage());
            return -21600;
        }
        return 0;
    }

    @Override
    public int removePresetPosition(String presetName) {
        if (presetName == null) {
            this.logger.warn("Argument presetName is null!");
            return -20002;
        }
        try {
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = (PresetCnf)this.presetList.elementAt(i);
                if (!presetName.equals(presetCnf.getPresetName())) continue;
                this.logger.info("Removing preset: " + Integer.parseInt(presetCnf.getPresetPosition()));
                this.presetList.removeElementAt(i);
                if (this.isDscpUsed()) {
                    return 0;
                }
                return this.sendCameraCommand("PTZ_PRESET_SET=" + presetCnf.getPresetPosition() + ",0");
            }
        }
        catch (Exception ex) {
            this.logger.error("Removing preset [" + presetName + "] failed with Exception: " + ex.getMessage());
            return -21600;
        }
        return 0;
    }
}

