/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.abus;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.abus.AbusCameraSrv;
import de.seetec.v5.re.cm.device.video.abus.AbusDevice;
import de.seetec.v5.re.cm.device.video.abus.AbusHelper;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.net.HTTPResponse;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.List;
import java.util.Map;

public class AbusVideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.iqle.DahuaVideoSourceClient";
    private AbusDevice abusDevice;
    private String streamName;
    private int channelID;

    @Override
    public int init() {
        try {
            List<Integer> possibleBandwidths;
            List<Integer> possibleFramerates;
            this.printDebug = false;
            this.errorCode = super.init();
            if (this.errorCode != 0) {
                return this.errorCode;
            }
            this.abusDevice = (AbusDevice)((AbusCameraSrv)this.getVideoSrv()).getDevice();
            NetworkParameter param = this.networkParameter;
            param.setSoTimeout(10000);
            this.errorCode = this.abusDevice.ensureLogin(param);
            if (this.errorCode != 0) {
                this.logger.error("Error while setting global camera parameters: " + this.errorCode + " for " + this);
                return this.errorCode;
            }
            this.errorCode = this.abusDevice.handleGlobalParameters(param, this.rotationAngle, this.useDateTime, this.useTitle, this.title);
            if (this.errorCode != 0) {
                this.logger.error("Error while setting global camera parameters: " + this.errorCode + " for " + this);
                return this.errorCode;
            }
            this.streamName = this.listener.getVideoSourceParameter().getStreamName();
            if (this.streamName.equals("Stream 1")) {
                this.channelID = 1;
                possibleFramerates = this.abusDevice.getParameterListFromCapabilities("Channel1.Fps");
                possibleBandwidths = this.abusDevice.getParameterListFromCapabilities("Channel1.Bitrate");
            } else {
                this.channelID = 2;
                possibleFramerates = this.abusDevice.getParameterListFromCapabilities("Channel2.Fps");
                possibleBandwidths = this.abusDevice.getParameterListFromCapabilities("Channel2.Bitrate");
            }
            String cookie = this.abusDevice.getCookie();
            String readUrl = "/cgi-bin/param.cgi?Mode=List&Group=Video&Channel=" + this.channelID;
            HTTPResponse response = AbusHelper.readGetRequest(this.networkParameter, readUrl, cookie);
            Map<String, String> currentParameter = AbusHelper.getContentFromResponse(response);
            Integer setFPS = Tools.getNearestAllowedValue(possibleFramerates, (int)(this.fps / 1000L));
            Integer setBandwidth = Tools.getNearestAllowedValue(possibleBandwidths, this.bandwidth);
            StringBuilder url = new StringBuilder("/cgi-bin/param.cgi?Mode=Update&Group=Video");
            url.append("&Channel=");
            url.append(this.channelID);
            boolean update = false;
            if (!setBandwidth.toString().equals(currentParameter.get("Video.Bitrate"))) {
                url.append("&Bitrate=");
                url.append(setBandwidth);
                update = true;
            }
            if (this.videoCodec == Codec.H264 && !currentParameter.get("Video.Codec").equals("H.264")) {
                url.append("&Codec=0");
                update = true;
            }
            if (this.videoCodec == Codec.MJPEG && !currentParameter.get("Video.Codec").equals("MJPEG")) {
                url.append("&Codec=1");
                update = true;
            }
            String[] currectRes = currentParameter.get("Video.Resolution").split("[xX]");
            if (!Integer.toString(this.width).equals(currectRes[0]) || !Integer.toString(this.height).equals(currectRes[1])) {
                url.append("&Resolution=");
                url.append(this.width);
                url.append("x");
                url.append(this.height);
                update = true;
            }
            if (!setFPS.toString().equals(currentParameter.get("Video.FrameRate"))) {
                url.append("&FPS=");
                url.append(setFPS);
                update = true;
            }
            if (update) {
                response = AbusHelper.readGetRequest(this.networkParameter, url.toString(), cookie);
                this.errorCode = AbusHelper.getResultCodeFromResponse(response);
                if (this.errorCode != 1) {
                    this.logger.warn("Return code was " + this.errorCode + " for request " + url);
                }
            }
            this.rtspUrl = "rtsp://" + this.getHost() + "/stream" + this.channelID;
            Thread.sleep(2500L);
            this.rtspSettings = new RTSPStreamSettings();
            if (this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 1) != 0) {
                this.logger.error("Error while initializing RTSP settings for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.errorCode = this.rtspHandler.start();
            if (this.errorCode != 0) {
                this.logger.error("Error while starting RTSP Handler for " + this.getVideoSrv() + ". RTSP URL is: " + this.rtspUrl);
                return this.errorCode;
            }
            return 0;
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while initialization for " + this + ". Message: " + ex.getMessage());
            return ex.getErrorCode();
        }
        catch (Throwable t) {
            this.logger.error("Unexpected exception while initialization for " + this, t);
            return -20000;
        }
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.listener.sendStatusService(error);
        this.shutdown();
        if (this.abusDevice != null) {
            this.abusDevice.resetCookie();
        }
    }

    @Override
    public synchronized void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public void notifyForNetworkProblems() {
        this.logger.error("Network problem from HTTPStreamHandler signalied. Shutting down" + this.getVideoSrv());
        this.shutdown();
    }

    @Override
    public void sendStatusService(int statusCode) {
        this.listener.sendStatusService(statusCode);
    }
}

