/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.abus;

import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.abus.AbusHelper;
import de.seetec.v5.re.cm.device.video.abus.AbusIOHandler;
import de.seetec.v5.shared.net.HTTPResponse;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AbusDevice
extends VideoServer {
    public static final int SO_TIMEOUT = 10000;
    private boolean globalParametersSet = false;
    private String cookie;
    private Thread keepAlive = null;
    private Map<String, String> capabilities = null;

    @Override
    protected IOHandler createIOHandler() {
        return new AbusIOHandler();
    }

    @Override
    protected boolean isSupportingIO() {
        return true;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isLoggedIn(NetworkParameter networkParameter) throws SeeTecException {
        String url = "/cgi-bin/param.cgi?Mode=List&Group=CK_user";
        HTTPResponse response = AbusHelper.readGetRequest(networkParameter, url, this.cookie);
        int errorCode = AbusHelper.getResultCodeFromResponse(response);
        return errorCode != 403;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ensureLogin(NetworkParameter networkParameter) throws SeeTecException {
        AbusDevice abusDevice = this;
        synchronized (abusDevice) {
            if (!this.isLoggedIn(networkParameter)) {
                String url = "/cgi-bin/param.cgi?Mode=Login&ID=" + networkParameter.getUserPWD()[0] + "&PWD=" + networkParameter.getUserPWD()[1];
                networkParameter.setAdditionalData(null);
                HTTPResponse response = AbusHelper.readGetRequest(networkParameter, url, null);
                int errorCode = AbusHelper.getResultCodeFromResponse(response);
                if (errorCode == -1) {
                    response = AbusHelper.readGetRequest(networkParameter, "/cgi-bin/param.cgi?Mode=Logout", this.cookie);
                    errorCode = AbusHelper.getResultCodeFromResponse(response);
                    if (errorCode != 1) {
                        this.logger.warn("Error during Logoff: errorCode=" + errorCode);
                    }
                    this.cookie = null;
                    response = AbusHelper.readGetRequest(networkParameter, url, null);
                    errorCode = AbusHelper.getResultCodeFromResponse(response);
                }
                if (errorCode != 1) {
                    this.logger.warn("Login to camera failed for " + this + " with errorCode=" + errorCode);
                    return -21657;
                }
                this.cookie = AbusHelper.getCookieFromResponse(response);
                if (this.keepAlive == null || !this.keepAlive.isAlive()) {
                    this.keepAlive = new Thread((Runnable)new KeepAlive(networkParameter, this.cookie), "Abus KeepAliveThread");
                    this.keepAlive.start();
                }
            }
            return 0;
        }
    }

    public final int handleGlobalParameters(NetworkParameter networkParameter, int rotationAngle, boolean useDateTime, boolean useTitle, String title) throws SeeTecException {
        int error = 0;
        if (this.globalParametersSet) {
            return 0;
        }
        StringBuilder url = new StringBuilder();
        url.append("/cgi-bin/param.cgi?Mode=List&Group=Image");
        HTTPResponse response = AbusHelper.readGetRequest(networkParameter, url.toString(), this.cookie);
        int errorCode = AbusHelper.getResultCodeFromResponse(response);
        if (errorCode != 1) {
            this.logger.warn("Return code was " + errorCode + " for request " + url);
        }
        this.capabilities = AbusHelper.getContentFromResponse(response);
        url = rotationAngle == 0 ? new StringBuilder("/cgi-bin/param.cgi?Mode=Update&Group=Image&Invert=0") : new StringBuilder("/cgi-bin/param.cgi?Mode=Update&Group=Image&Invert=3");
        response = AbusHelper.readGetRequest(networkParameter, url.toString(), this.cookie);
        errorCode = AbusHelper.getResultCodeFromResponse(response);
        if (errorCode != 1) {
            this.logger.warn("Return code was " + errorCode + " for request " + url);
        }
        url = new StringBuilder("/cgi-bin/param.cgi?Mode=Update&Group=OSD");
        url.append(useDateTime ? "&Date=1&Time=1" : "&Date=0&Time=0");
        url.append(useTitle ? "&String=1&String.text=" + title : "&String=0");
        url.append(useTitle || useDateTime ? "&StreamingType=1" : "&StreamingType=0");
        response = AbusHelper.readGetRequest(networkParameter, url.toString(), this.cookie);
        errorCode = AbusHelper.getResultCodeFromResponse(response);
        if (errorCode != 1) {
            this.logger.warn("Return code was " + errorCode + " for request " + url);
        }
        this.globalParametersSet = true;
        return error;
    }

    public final String getCookie() {
        return this.cookie;
    }

    public final void resetCookie() {
        this.cookie = null;
    }

    @Override
    public int shutdown() {
        if (this.isShutdown("de.seetec.v5.shared.SSLConstantsIntf")) {
            return 0;
        }
        try {
            this.Logout();
        }
        finally {
            this.keepAlive = null;
        }
        this.globalParametersSet = false;
        return super.shutdown();
    }

    private void Logout() {
        try {
            if (this.getDeviceCnf() != null) {
                NetworkParameter networkParameter = this.getDeviceCnf().getNetworkParameter();
                networkParameter.setSoTimeout(5000);
                if (this.isLoggedIn(networkParameter)) {
                    String url = "/cgi-bin/param.cgi?Mode=Logout";
                    HTTPResponse response = AbusHelper.readGetRequest(networkParameter, url, this.cookie);
                    int errorCode = AbusHelper.getResultCodeFromResponse(response);
                    if (errorCode != 1) {
                        this.logger.warn("Error during Logoff: errorCode=" + errorCode);
                    }
                    this.cookie = null;
                }
            }
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Error during Logoff: " + ex.getMessage());
        }
        catch (SeeTecException ex) {
            this.logger.warn("Error during Logoff: " + ex.getMessage());
        }
    }

    public List<Integer> getParameterListFromCapabilities(String parameterName) {
        ArrayList<Integer> resultList = new ArrayList<Integer>();
        if (this.capabilities != null && this.capabilities.containsKey(parameterName)) {
            for (String value : this.capabilities.get(parameterName).split(",")) {
                try {
                    resultList.add(Integer.parseInt(value));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return resultList;
    }

    private class KeepAlive
    implements Runnable {
        private final NetworkParameter networkParameter;
        private final String cookie;

        KeepAlive(NetworkParameter networkParameter, String cookie) {
            this.networkParameter = networkParameter;
            this.cookie = cookie;
        }

        @Override
        public void run() {
            long time = System.currentTimeMillis();
            AbusDevice.this.logger.info("Start keep alive for " + this);
            try {
                boolean bCancel = false;
                while (!AbusDevice.this.isShutdown() && !bCancel) {
                    if (System.currentTimeMillis() > time + 9000L) {
                        try {
                            String url = "/cgi-bin/param.cgi?Mode=List&Group=CK_user";
                            HTTPResponse response = AbusHelper.readGetRequest(this.networkParameter, url, this.cookie);
                            int errorCode = AbusHelper.getResultCodeFromResponse(response);
                            if (errorCode != 1) {
                                AbusDevice.this.logger.warn("========> Return code was " + errorCode + " for request " + url);
                            }
                        }
                        catch (SeeTecException e) {
                            AbusDevice.this.logger.warn("Error while sending keep alive requtest for " + this + ": " + e.getMessage());
                            bCancel = true;
                        }
                        time = System.currentTimeMillis();
                        continue;
                    }
                    Thread.sleep(10000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            AbusDevice.this.Logout();
        }
    }
}

