/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.videosource;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.JitterCalculator;
import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.LRULinkedHashMap;
import de.seetec.v5.re.cm.shared.StatisticalData;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.LinkedHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class VideoSourceClient
extends Basic {
    public static final String CLASS_NAME = "de.seetec.v5.re.cm.device.shared.VideoSourceClient";
    public final Object Semaphore = new Object();
    public Codec videoCodec = Codec.UNKNOWN;
    protected Logger logger = null;
    protected Core core = null;
    protected VideoProfileHandler listener = null;
    protected VideoSrv videoSrv = null;
    protected String api = null;
    protected String host = null;
    protected int port = -1;
    protected boolean authorization = false;
    protected NetworkParameter networkParameter = null;
    protected long lastVideoLossEventSent = Long.MIN_VALUE;
    protected long lastTamperingEventSent = Long.MIN_VALUE;
    protected long lastCannotCreateDeviceEventSent = Long.MIN_VALUE;
    protected int videoSourceNr = Integer.MIN_VALUE;
    protected int rotationAngle = 0;
    protected boolean useDateTime = false;
    protected boolean useTitle = false;
    protected String title = null;
    protected int quality = Integer.MIN_VALUE;
    protected int compression = Integer.MIN_VALUE;
    protected String resolutionTag = null;
    protected int[] resolution = null;
    protected int width = Integer.MIN_VALUE;
    protected int height = Integer.MIN_VALUE;
    protected boolean printDebug = false;
    protected boolean firstDeliver = true;
    private long lastStatsFrameSent = System.currentTimeMillis();
    private long receivedVideoFrames = 0L;
    private long receivedAudioFrames = 0L;
    private long receivedVideoData = 0L;
    private long receivedAudioData = 0L;
    private final long tsStartup = System.currentTimeMillis();
    private long timestampLastContentFrame = -1L;
    private long lastSystemTime = -1L;
    private final JitterCalculator jitterCalculator = new JitterCalculator();
    private boolean hasRTPTimestamp = false;
    private final LinkedHashMap<Integer, Object> paketHistory = new LRULinkedHashMap();
    private boolean firstCall = true;

    public VideoSourceClient() {
        this.logger = LogManager.getLogger((String)((Object)((Object)this)).getClass().getName());
    }

    protected int init() {
        this.printDebug = false;
        int errorCode = 0;
        try {
            this.videoSourceNr = this.listener.getVideoSourceParameter().getServerEntryNo();
            this.videoCodec = this.listener.getVideoSourceParameter().getMediaCodec();
            this.rotationAngle = this.listener.getVideoSourceParameter().getImageRotation() / 1000;
            this.useTitle = this.listener.getVideoSourceParameter().useTitle();
            this.title = this.listener.getVideoSourceParameter().getTitle();
            if (this.title != null) {
                this.title = URLEncoder.encode(this.title.trim(), "UTF-8");
            }
            this.useDateTime = this.listener.getVideoSourceParameter().isTimeDateEnabled();
            this.quality = this.listener.getVideoSourceParameter().getQuality();
            this.compression = 100000 - this.quality;
            this.resolutionTag = this.listener.getVideoSourceParameter().getResolution();
            this.resolution = this.listener.getVideoSourceParameter().getImageSize();
            if (this.resolution != null && this.resolution.length == 2) {
                this.width = this.resolution[0];
                this.height = this.resolution[1];
            } else {
                errorCode = -21601;
            }
        }
        catch (Exception ex) {
            this.logger.error("Reading configuration from " + this.getVideoSrv() + " failed", (Throwable)ex);
            return -21601;
        }
        if (this.videoCodec == Codec.UNKNOWN) {
            return -21601;
        }
        if (this.quality < 0 || this.quality > 100000) {
            this.logger.error("Quality contains invalid value '" + this.quality + "' for " + (Object)((Object)this));
            return -21601;
        }
        if (this.compression < 0 || this.compression > 100000) {
            this.logger.error("Compression contains invalid value '" + this.compression + "' for " + (Object)((Object)this));
            return -21601;
        }
        return errorCode;
    }

    public final int init(Core core, VideoSrv videoSrv, VideoProfileHandler listener) {
        this.core = core;
        if (this.core == null) {
            this.logger.error("Argument [Core] is null");
            return -21601;
        }
        this.videoSrv = videoSrv;
        if (this.videoSrv == null) {
            this.logger.error("Argument [Device] is null");
            return -21601;
        }
        this.listener = listener;
        if (this.listener == null) {
            this.logger.error("Argument [Listener] is null");
            return -21601;
        }
        try {
            this.api = this.getVideoSrv().getDevice().getDeviceCnf().getAPI();
            this.host = this.getVideoSrv().getDevice().getDeviceCnf().getHardwareHost();
            int httpPort = this.getVideoSrv().getDevice().getDeviceCnf().getHTTPport();
            int httpsPort = this.getVideoSrv().getDevice().getDeviceCnf().getSSLport();
            this.port = httpsPort > 0 ? httpsPort : httpPort;
            this.networkParameter = this.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter();
        }
        catch (Exception ex) {
            this.logger.error("Reading configuration from " + this.getVideoSrv().getDevice() + " failed", (Throwable)ex);
            return -21601;
        }
        return this.init();
    }

    public abstract boolean isShutdown();

    protected Core getCore() {
        return this.core;
    }

    public VideoSrv getVideoSrv() {
        return this.videoSrv;
    }

    public long getLifetime() {
        return System.currentTimeMillis() - this.tsStartup;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    protected void deliverFrameCreateServerTimestamp(int mediaType, MediaFrame mediaFrame) {
        this.deliverFrame(mediaType, mediaFrame, Long.MIN_VALUE);
    }

    protected void deliverFrame(int mediaType, MediaFrame mediaFrame, long startTime) {
        if (startTime != Long.MIN_VALUE && !this.hasRTPTimestamp) {
            this.hasRTPTimestamp = true;
        }
        if (this.firstDeliver) {
            if (this.listener != null) {
                this.listener.sendStatusService(0);
            }
            this.firstDeliver = false;
        }
        if (mediaFrame == null || mediaFrame.getLength() <= 20) {
            return;
        }
        if (mediaType == 16) {
            this.core.deviceManagerStatistic.incrementGrabbedAudioFrames();
        } else {
            this.core.deviceManagerStatistic.incrementGrabbedVideoFrames();
        }
        this.core.deviceManagerStatistic.incrementGrabbedData(mediaFrame.getLength());
        if (this.firstCall) {
            this.firstCall = false;
            this.logger.info("Media streaming started for " + this.getVideoSrv());
            this.getVideoSrv().getDevice().sendResolvedConnectionEvent(this.getVideoSrv().getEntityID());
        }
        this.createAndSendStatisticalData(mediaType, mediaFrame);
        if (this.listener != null) {
            if (this.videoSrv != null && this.videoSrv.isStreamDisabled()) {
                return;
            }
            ContentFrame cf = this.createContentFrame(mediaType, mediaFrame.getData(), startTime);
            this.listener.deliverFrame(cf, this.hasRTPTimestamp);
            if (this.logger.isDebugEnabled()) {
                if (mediaType == 16) {
                    this.logger.info("Delivered audio frame type: " + cf + ",length: " + mediaFrame.getLength() + ". Stream running since " + new Date(this.tsStartup).toString() + " for " + (Object)((Object)this));
                } else {
                    this.logger.info("Delivered video frame type: " + cf + ",length: " + mediaFrame.getLength() + " ,resolution: " + this.width + "x" + this.height + ". Stream running since " + new Date(this.tsStartup).toString() + " for " + (Object)((Object)this));
                }
            }
        }
    }

    private void createAndSendStatisticalData(int mediaType, MediaFrame mediaFrame) {
        int offset = 16;
        if (mediaType == 16) {
            ++this.receivedAudioFrames;
            this.receivedAudioData += (long)(mediaFrame.getLength() - offset);
        } else {
            ++this.receivedVideoFrames;
            this.receivedVideoData += (long)(mediaFrame.getLength() - offset);
            try {
                this.jitterCalculator.calculateJitter(System.currentTimeMillis(), this.lastStatsFrameSent, this.receivedVideoFrames);
            }
            catch (SeeTecException seeTecException) {
                this.logger.warn("Exception while calculating jitter because of " + seeTecException.getErrorCode() + " for " + (Object)((Object)this));
            }
        }
        long packetLossRatio = this.calculatePacketLossRatio();
        if (this.lastStatsFrameSent + 1000L < System.currentTimeMillis()) {
            long realDistance = System.currentTimeMillis() - this.lastStatsFrameSent;
            float factor = (float)((double)realDistance / 1000.0);
            long milliFPSVideoPerSecond = (long)((float)(this.receivedVideoFrames * 1000L) / factor);
            long bitVideoPerSecond = (long)((float)(this.receivedVideoData * 8L) / factor);
            long milliFPSAudioPerSecond = (long)((float)(this.receivedAudioFrames * 1000L) / factor);
            long bitAudioPerSecond = (long)((float)(this.receivedAudioData * 8L) / factor);
            if (this.logger.isDebugEnabled()) {
                this.logger.info(String.format("fpsPerSecond video/audio: %d/%d, bitPerSecond video/audio: %d/%d, paketLossRatio: %d, maxJitter: %d for %s", new Object[]{milliFPSVideoPerSecond, milliFPSAudioPerSecond, bitVideoPerSecond, bitAudioPerSecond, packetLossRatio, this.jitterCalculator.getMaxVideoJitter(), this}));
            }
            try {
                if (this.listener != null) {
                    ContentFrame cf = this.createContentFrame(65, StatisticalData.createStatisticalData(milliFPSVideoPerSecond, milliFPSAudioPerSecond, bitVideoPerSecond, bitAudioPerSecond, packetLossRatio, this.jitterCalculator.getMaxVideoJitter()), Long.MIN_VALUE);
                    this.listener.deliverFrame(cf, false);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.lastStatsFrameSent = System.currentTimeMillis();
            this.receivedVideoFrames = 0L;
            this.receivedVideoData = 0L;
            this.receivedAudioFrames = 0L;
            this.receivedAudioData = 0L;
        }
    }

    private long calculatePacketLossRatio() {
        long packetLossRatio;
        block4: {
            packetLossRatio = 0L;
            if (!this.paketHistory.isEmpty()) {
                try {
                    Integer[] history = this.paketHistory.keySet().toArray(new Integer[this.paketHistory.keySet().size()]);
                    int estimatedLostPakets = history[history.length - 1] - history[0] - (history.length - 1);
                    if (history.length != 0 && estimatedLostPakets >= 0) {
                        packetLossRatio = estimatedLostPakets * 100 * 1000 / (history.length + estimatedLostPakets);
                    }
                }
                catch (ConcurrentModificationException cme) {
                    if (!this.logger.isDebugEnabled()) break block4;
                    this.logger.warn(cme.getMessage() + " occured. Ignore, cause not crucial for " + (Object)((Object)this));
                }
            }
        }
        return packetLossRatio;
    }

    protected final void checkForPacketLoss(byte[] data) {
        if (data != null && data.length >= 4) {
            int receivedSequenceNumber = Basic.byteArrayToInt4((byte[])new byte[]{0, 0, data[2], data[3]});
            if (receivedSequenceNumber == 0) {
                this.paketHistory.clear();
            }
            this.paketHistory.put(receivedSequenceNumber, null);
        }
    }

    protected ContentFrame createContentFrame(int mediatype, byte[] frame, long startTime) {
        ContentFrame contentFrame = null;
        try {
            if (!this.isServerTimeChangedAndCreateServerTimestamp()) {
                contentFrame = startTime != Long.MIN_VALUE ? new ContentFrame(mediatype, 0, startTime, startTime, frame) : new ContentFrame(mediatype, 0, this.timestampLastContentFrame, this.timestampLastContentFrame, frame);
            }
            return contentFrame;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServerTimeChangedAndCreateServerTimestamp() {
        Object object = this.Semaphore;
        synchronized (object) {
            long gap;
            long currentSystemTime = System.currentTimeMillis();
            if (this.timestampLastContentFrame < 0L) {
                this.timestampLastContentFrame = currentSystemTime - 1L;
                this.lastSystemTime = currentSystemTime;
            }
            this.timestampLastContentFrame = (gap = currentSystemTime - this.timestampLastContentFrame) > 0L ? currentSystemTime : ++this.timestampLastContentFrame;
            long systemTimeGap = currentSystemTime - this.lastSystemTime;
            if (systemTimeGap < 0L) {
                this.logger.error("System time has changed for [" + Basic.longToFormattedString((long)(-gap)) + " ms]");
                return true;
            }
            this.lastSystemTime = currentSystemTime;
        }
        return false;
    }

    public VideoProfileHandler getListener() {
        return this.listener;
    }

    public int getVideoSourceNr() {
        return this.videoSourceNr;
    }

    public int getRotationAngle() {
        return this.rotationAngle;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public long getLastVideoLossEventSent() {
        return this.lastVideoLossEventSent;
    }

    public void setLastVideoLossEventSent(long lastVideoLossEventSent) {
        this.lastVideoLossEventSent = lastVideoLossEventSent;
    }

    public long getLastTamperingEventSent() {
        return this.lastTamperingEventSent;
    }

    public void setLastTamperingEventSent(long lastTamperingEventSent) {
        this.lastTamperingEventSent = lastTamperingEventSent;
    }

    public void publishRTSPUrl(String rtspUrl) {
        try {
            if (this.core != null) {
                Integer[] classifications = this.listener.getVideoSourceParameter().getClassifications();
                if (this.listener.isStandardVideoProfile()) {
                    this.core.storeRTSPInformation(this.getVideoSrv().getServiceID() + ":-1", rtspUrl);
                }
                if (classifications != null && classifications.length > 0) {
                    for (Integer classification : classifications) {
                        String tmp = this.getVideoSrv().getServiceID() + ":" + classification;
                        this.core.storeRTSPInformation(tmp, rtspUrl);
                    }
                } else {
                    this.logger.warn("No video classification available, so storing it with classification [0]!");
                    this.core.storeRTSPInformation(this.getVideoSrv().getServiceID() + ":-1", rtspUrl);
                }
            }
        }
        catch (ConfigurationException ce) {
            this.logger.error("Error reading classification for Barco shortcut. Go on anyway.");
        }
    }
}

