/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.videosource;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.videosource.RTPHeader;
import de.seetec.v5.re.cm.device.shared.videosource.TimestampCalculator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UseSimpleRelativeRTPTimestampForPlayback
implements TimestampCalculator {
    public static final int FIXED_CLOCK_RATIO_FOR_VIDEO = 90;
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private long videoPlaybackStartingTime = 0L;
    private long timeStartRtp = 0L;
    private double scale = 1.0;

    @Override
    public long calculateAbsoluteTimestamp(long absoluteTimestampFromSystem, RTPHeader rtpHeader, int mediaType) {
        long absoluteTimestampFromCamera = 0L;
        long rtpTimestampFromHeader = rtpHeader.getTimestamp();
        if (this.timeStartRtp == 0L) {
            this.timeStartRtp = rtpTimestampFromHeader;
        }
        absoluteTimestampFromCamera = (long)((double)this.videoPlaybackStartingTime + (double)((rtpTimestampFromHeader - this.timeStartRtp) / 90L) * this.scale);
        if (this.logger.isDebugEnabled()) {
            this.logger.info("RTP-Header timestamp: " + rtpTimestampFromHeader + ". videoPlaybackStartingTime: " + Core.getUniformFormattedDateTime((long)this.videoPlaybackStartingTime) + " => calculated timestamp: " + Core.getUniformFormattedDateTime((long)absoluteTimestampFromCamera));
        }
        return absoluteTimestampFromCamera;
    }

    public void setPlaybackStartingTime(long videoPlaybackStartingTime) {
        this.videoPlaybackStartingTime = videoPlaybackStartingTime;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    @Override
    public void reset() {
        this.timeStartRtp = 0L;
    }
}

