/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.videosource;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPConstantsIntf;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerIntf;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerSuper;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPResponse;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.Mikey;
import de.seetec.v5.re.cm.device.shared.videosource.H264Data;
import de.seetec.v5.re.cm.device.shared.videosource.H265Data;
import de.seetec.v5.re.cm.device.shared.videosource.Mpeg4Data;
import de.seetec.v5.re.cm.device.shared.videosource.NALUnitPayloadStructureH264;
import de.seetec.v5.re.cm.device.shared.videosource.NALUnitPayloadStructureH265;
import de.seetec.v5.re.cm.device.shared.videosource.PacketType;
import de.seetec.v5.re.cm.device.shared.videosource.PacketTypeParser;
import de.seetec.v5.re.cm.device.shared.videosource.PlaybackVideoSourceClient;
import de.seetec.v5.re.cm.device.shared.videosource.RTPHeader;
import de.seetec.v5.re.cm.device.shared.videosource.RtpPacket;
import de.seetec.v5.re.cm.device.shared.videosource.RtspAudioSourceClient;
import de.seetec.v5.re.cm.device.shared.videosource.SrtpTools;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelper;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelperH264;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelperH265;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelperMpeg4;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClient;
import de.seetec.v5.re.cm.device.shared.videosource.TimestampCalculator;
import de.seetec.v5.re.cm.device.shared.videosource.TimestampCalculatorCallback;
import de.seetec.v5.re.cm.device.shared.videosource.UseRelativeRTPTimestamp;
import de.seetec.v5.re.cm.device.shared.videosource.UseSimpleRelativeRTPTimestampForPlayback;
import de.seetec.v5.re.cm.device.video.axis.videosource.AxisAudioSourceClient;
import de.seetec.v5.re.cm.device.video.digigram.DigigramAudioSourceClient;
import de.seetec.v5.re.cm.shared.communication.DatabaseWriter;
import de.seetec.v5.re.cm.shared.communication.DatabaseWriterRepository;
import de.seetec.v5.re.cm.shared.communication.DatabaseWriterType;
import de.seetec.v5.re.cm.shared.communication.MDBWriterFactoryImpl;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.re.shared.EdgeStorageParameter;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.re.shared.SynchronizationTime;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.JpegUtility;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class StreamingVideoSourceClientRTSP
extends StreamingVideoSourceClient
implements RTSPConstantsIntf,
TimestampCalculatorCallback,
RTSPHandlerIntf {
    private static final int RTP_HEVC_PAYLOAD_HEADER_SIZE = 2;
    private static final int RTP_HEVC_FU_HEADER_SIZE = 1;
    private static final int RTP_HEVC_DONL_FIELD_SIZE = 2;
    private static final int RTP_HEVC_DOND_FIELD_SIZE = 1;
    private static final int HEVC_SPECIFIED_NAL_UNIT_TYPES = 48;
    protected String[] multicastConfiguration = null;
    protected String[] multicastConfigurationDevice = null;
    protected AudioSourceClient audioSourceClient = null;
    protected boolean isMulticastEnabled = false;
    protected boolean isHTTPTunneling = false;
    protected boolean enableSSRCCheck = false;
    protected RTSPResponse describeResponse = null;
    protected RTSPHandlerSuper rtspHandler = null;
    protected int bytesToCopy = 0;
    protected byte[] parameterSet = null;
    protected byte[] videoParameterSet = null;
    protected byte[] parameterSetPart = null;
    protected byte[] pictureSet = null;
    protected byte[] configHeader = null;
    protected String rtspUrl = null;
    protected RTSPStreamSettings rtspSettings = null;
    protected boolean firstIFramePart = true;
    protected byte[] firstPartIFrame;
    protected boolean firstPFramePart = true;
    protected byte[] firstPartPFrame;
    protected boolean useFrameCropping;
    protected boolean respectEveryParameterSet = false;
    protected boolean deliverPPSBeforePFrameIfAvailable = false;
    protected boolean enableDeliverPPSBeforePFrameIfAvailable = false;
    protected int[] currentResolution = null;
    protected boolean isLocalStorageHandler = false;
    protected long videoPlaybackStartingTime = -1L;
    protected long endTimeStamp = 0L;
    protected EdgeStorageParameter edgeStorageParameter;
    protected boolean useResolutionFromConfiguration = false;
    protected int MAX_BUFFER_SIZE = 10;
    protected int MAX_RTP_SEQUENCE_NUMBER = 65535;
    protected int MAX_SEQUENCE_GAP = 40000;
    protected int currentSequenceNumber = Integer.MIN_VALUE;
    protected int lastProcessedSequenceNumber = Integer.MIN_VALUE;
    protected int previousSequenceNumber = Integer.MIN_VALUE;
    protected String extension = "";
    protected boolean doLogOutput = false;
    protected boolean doSameSequenceNumberFix = false;
    protected boolean doBufferForSequenceNumberJumps = false;
    protected TimestampCalculator timestampCalculator;
    protected final SortedMap<Integer, RtpPacket> udpSequenceReorderBuffer = new TreeMap<Integer, RtpPacket>(){
        private static final long serialVersionUID = 8793666359910468840L;

        @Override
        public RtpPacket put(Integer key, RtpPacket value) {
            if (this.size() == StreamingVideoSourceClientRTSP.this.MAX_BUFFER_SIZE) {
                this.pollFirstEntry();
            }
            return super.put(key, value);
        }
    };
    boolean isFrameCompleted = false;
    private String ssrcFromRTSP = null;
    private long packetsWithWrongSSRC = 0L;
    private byte[] completeFrameAsByteArray;
    private DatabaseWriter localStorageWriter = null;
    private final Object LOCAL_STORAGE_WRITER_SEMAPHORE = new Object();
    private long videoPlaybackEndTime = -1L;
    private volatile boolean stopPlaybackStream = false;
    private long timeStampLastFrame = Long.MAX_VALUE;
    private long timeStampFirstFrame = -1L;
    private volatile boolean localStorageReady = false;
    private final LinkedList<ContentFrame> videoQueue = new LinkedList();
    private long timeStampForEarlyFrames;
    private long time = Long.MIN_VALUE;
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS");
    private List<RtpPacket> processSequenceBufferList = new ArrayList<RtpPacket>();
    private SrtpTools srtpTools;
    private SrtpTools srtpToolsAudio;
    private int srtpUnauthenticatedPacketCounter = 0;
    private boolean srtpAuthenticationErrorStatusSet;

    @Override
    protected int init() {
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        this.timestampCalculator = this.isLocalStorageHandler ? new UseSimpleRelativeRTPTimestampForPlayback() : new UseRelativeRTPTimestamp(this);
        try {
            this.completeFrame = new ByteArrayOutputStream();
            this.receiverReport[0] = -127;
            this.receiverReport[1] = -55;
            this.receiverReport[2] = 0;
            this.receiverReport[3] = 7;
            byte[] receiverSSRC = new byte[4];
            new Random().nextBytes(receiverSSRC);
            System.arraycopy(receiverSSRC, 0, this.receiverReport, 4, 4);
            if (this.transmissionID == TransmissionType.RTP_OVER_UDP_MULTICAST || this.transmissionID == TransmissionType.PROPRIETARY_MULTICAST) {
                this.isMulticastEnabled = true;
            } else if (this.transmissionID == TransmissionType.RTP_OVER_RTSP_OVER_HTTP_UNICAST) {
                this.isHTTPTunneling = true;
            }
            if (this.listener.getVideoSourceParameter().isAudioEnabled()) {
                this.isAudioEnabled = true;
                this.audioCodec = this.getVideoSrv().getAudioConfiguration().getCodec();
                this.audioBitrate = this.getVideoSrv().getAudioConfiguration().getBitrate();
                this.audioSourceClient = new AudioSourceClient(this.audioSourceClient);
            }
            this.multicastConfiguration = this.listener.getVideoSourceParameter().getMulticastConfiguration();
            this.multicastConfigurationDevice = this.listener.getVideoSourceParameter().getDeviceMulticastConfiguration();
            this.edgeStorageParameter = this.listener.getVideoSourceParameter().getEdgeStorageParameter();
            this.extension = this.core.getCoreExtension();
            if (this.extension.contains("LOGOUTPUT")) {
                this.doLogOutput = true;
            }
            if (this.extension.contains("DOSAMESEQUENCE")) {
                this.doSameSequenceNumberFix = true;
            }
            if (this.extension.contains("DOBUFFER")) {
                this.doBufferForSequenceNumberJumps = true;
            }
            if (this.extension.contains("BUFFERSIZE")) {
                this.MAX_BUFFER_SIZE = this.parseBufferSizeExtension(this.extension);
            }
        }
        catch (Exception ex) {
            this.logger.error("Reading configuration from " + super.getVideoSrv() + " failed", (Throwable)ex);
            return -21601;
        }
        this.srtpTools = new SrtpTools();
        if (this.isAudioEnabled) {
            this.srtpToolsAudio = new SrtpTools();
        }
        ArrayList<String> configurationOutput = new ArrayList<String>();
        configurationOutput.add("VideoSourceClient (Stream) for " + this);
        configurationOutput.add("Service (Source) for " + this.getVideoSrv());
        configurationOutput.add("VideoSourceNumber: " + this.videoSourceNr);
        if (!(this instanceof PlaybackVideoSourceClient)) {
            configurationOutput.add("Resolution: " + this.width + "x" + this.height + " (" + this.resolutionTag + ")");
            configurationOutput.add("VideoCodec: " + this.videoCodec.name());
            configurationOutput.add("I-Frame distance (s): " + this.iFrameDistMS / 1000);
            configurationOutput.add("Quality (%): " + this.quality / 1000);
            configurationOutput.add("Constant bitrate enabled: " + this.isConstantBitrateUsed);
            configurationOutput.add("Bandwidth (kb): " + this.bandwidth / 1024);
            configurationOutput.add("FPS: " + this.fps / 1000L);
            configurationOutput.add("Audio enabled: " + this.isAudioEnabled);
            if (this.isAudioEnabled) {
                configurationOutput.add("AudioCodec: " + this.audioCodec.name());
                configurationOutput.add("AudioBitrate (kb): " + this.audioBitrate / 1024);
            }
            configurationOutput.add("Transmission type: " + this.transmissionID.name());
            configurationOutput.add("Multicast (Device/DM) enabled: " + this.isMulticastEnabled + (this.isMulticastEnabled && this.multicastConfigurationDevice != null ? " (" + this.multicastConfigurationDevice[0] + ":" + this.multicastConfigurationDevice[1] + ")" : ""));
            configurationOutput.add("Multicast (DM/Client) enabled: " + (this.multicastConfiguration != null ? "true (" + this.multicastConfiguration[0] + ":" + this.multicastConfiguration[1] + ")" : "false"));
        } else {
            configurationOutput.add("PlaybackVideoSourceClient");
            configurationOutput.add("EdgeStorage enabled: " + this.edgeStorageParameter.isEnabled());
            configurationOutput.add("EdgeStorage mode: " + this.edgeStorageParameter.getEdgeStorageMode());
            configurationOutput.add("EdgeStorage sync track: " + this.edgeStorageParameter.getTrack());
            configurationOutput.add("EdgeStorage number of sync times: " + this.edgeStorageParameter.getSynchronizationTimes().length);
            for (SynchronizationTime synchronizationTime : this.edgeStorageParameter.getSynchronizationTimes()) {
                configurationOutput.add("EdgeStorage sync time: " + synchronizationTime);
            }
            configurationOutput.add("EdgeStorage check on device start: " + this.edgeStorageParameter.isCheckOnDeviceStart());
            configurationOutput.add("EdgeStorage activate trigger: " + this.edgeStorageParameter.isActivateTrigger());
            configurationOutput.add("EdgeStorage use optional time range: " + this.edgeStorageParameter.isUseOptionalTimeRange());
            configurationOutput.add("EdgeStorage optional time range: " + this.edgeStorageParameter.getOptionalTimeRange());
        }
        this.logger.info(Basic.generateIndentedMultiLineLog((String[])configurationOutput.toArray(new String[configurationOutput.size()])));
        return this.errorCode;
    }

    protected void deliverH264Data(byte[] data, boolean checkResolution, long timeStamp) throws SeeTecException {
        int mediaType = StreamingHelperH264.checkForH264MediaType(this.getVideoSrv().getDevice(), data);
        if (this.enableDeliverPPSBeforePFrameIfAvailable && mediaType == 8) {
            this.deliverPPSBeforePFrameIfAvailable = true;
        }
        H264Data h264Data = new H264Data(mediaType, data, checkResolution, this.parameterSetPart, this.pictureSet, this.describeResponse, this.configHeader, this.useResolutionFromConfiguration, this.width, this.height, this.useFrameCropping, this.firstIFramePart, this.firstPartIFrame, this.firstPFramePart, this.firstPartPFrame, this.respectEveryParameterSet, this.deliverPPSBeforePFrameIfAvailable);
        MediaFrame mediaFrame = StreamingHelperH264.processH264Data(h264Data, this);
        this.parameterSetPart = h264Data.getParameterSetPart();
        this.pictureSet = h264Data.getPictureSet();
        this.configHeader = h264Data.getConfigHeader();
        this.describeResponse = h264Data.getDescribeResponse();
        this.width = h264Data.getWidth();
        this.height = h264Data.getHeight();
        this.firstIFramePart = h264Data.isFirstIFramePart();
        this.firstPartIFrame = h264Data.getFirstPartIFrame();
        this.firstPFramePart = h264Data.isFirstPFramePart();
        this.firstPartPFrame = h264Data.getFirstPartPFrame();
        if (mediaFrame != null) {
            this.deliverFrame(h264Data.getMediaType(), mediaFrame, timeStamp);
        }
        if (this.enableDeliverPPSBeforePFrameIfAvailable && mediaType == 35) {
            this.deliverPPSBeforePFrameIfAvailable = false;
        }
    }

    private void deliverH265Data(byte[] data, boolean checkResolution, long timeStamp) throws SeeTecException {
        int mediaType = StreamingHelperH265.checkForH265MediaType(this.getVideoSrv().getDevice(), data);
        H265Data h265Data = new H265Data(mediaType, data, checkResolution, this.videoParameterSet, this.parameterSetPart, this.pictureSet, this.describeResponse, this.configHeader, this.useResolutionFromConfiguration, this.width, this.height, this.useFrameCropping, this.firstIFramePart, this.firstPartIFrame, this.firstPFramePart, this.firstPartPFrame, true, this.deliverPPSBeforePFrameIfAvailable);
        MediaFrame mediaFrame = StreamingHelperH265.processH265Data(h265Data, this);
        this.videoParameterSet = h265Data.getVideoParameterSet();
        this.parameterSetPart = h265Data.getParameterSetPart();
        this.pictureSet = h265Data.getPictureSet();
        this.configHeader = h265Data.getConfigHeader();
        this.describeResponse = h265Data.getDescribeResponse();
        this.width = h265Data.getWidth();
        this.height = h265Data.getHeight();
        this.firstIFramePart = h265Data.isFirstIFramePart();
        this.firstPartIFrame = h265Data.getFirstPartIFrame();
        this.firstPFramePart = h265Data.isFirstPFramePart();
        this.firstPartPFrame = h265Data.getFirstPartPFrame();
        if (mediaFrame != null) {
            this.deliverFrame(h265Data.getMediaType(), mediaFrame, timeStamp);
        }
    }

    protected void deliverMpeg4Data(byte[] data, long timestamp) throws SeeTecException {
        int mediaType = StreamingHelperMpeg4.checkForMPEG4Part2MediaType(data);
        Mpeg4Data mpeg4Data = new Mpeg4Data(mediaType, data, this.currentResolution, this.width, this.height, this.configHeader, this.describeResponse);
        MediaFrame mediaFrame = StreamingHelperMpeg4.processMpeg4Data(mpeg4Data);
        this.currentResolution = mpeg4Data.getCurrentResolution();
        this.width = mpeg4Data.getWidth();
        this.height = mpeg4Data.getHeight();
        this.configHeader = mpeg4Data.getConfigHeader();
        if (mediaFrame != null) {
            this.deliverFrame(mpeg4Data.getMediaType(), mediaFrame, timestamp);
        }
    }

    @Override
    protected void deliverFrame(int mediaType, MediaFrame mediaFrame, long startTimeStamp) {
        if (this.rtspSettings != null && (this.rtspSettings.getCallback() instanceof AxisAudioSourceClient || this.rtspSettings.getCallback() instanceof DigigramAudioSourceClient) && this.time + 1000L < System.currentTimeMillis()) {
            this.time = System.currentTimeMillis();
            try {
                super.deliverFrame(33, StreamingHelper.createSeeTecVideoFrameHeader(Codec.H264, 1, 1, new byte[]{0, 0, 0, 0, 0}), this.time);
            }
            catch (SeeTecException ex) {
                this.logger.error((Object)ex, (Throwable)ex);
            }
        }
        if (this.listener != null) {
            if (this.firstDeliver && !this.isLocalStorageHandler) {
                this.errorCode = this.listener.checkEdgeStorageOnDeviceStart();
                if (this.errorCode != 0) {
                    this.logger.warn("Check edge storage on device start failed with error code " + this.errorCode + " for " + this);
                }
            }
            if (this.isLocalStorageHandler) {
                this.deliverLocalStorageFrame(mediaType, mediaFrame, startTimeStamp);
            } else {
                super.deliverFrame(mediaType, mediaFrame, startTimeStamp);
            }
        }
    }

    public int getIFrameDistanceInMS() {
        return this.iFrameDistMS;
    }

    public void resetLastWrittenFrameTimestamp() {
        this.timeStampLastFrame = Long.MAX_VALUE;
    }

    @Override
    public int shutdown() {
        if (this.audioSourceClient != null) {
            this.audioSourceClient.shutdown();
            this.audioSourceClient = null;
        }
        if (this.rtspHandler != null) {
            this.rtspHandler.shutdown();
            this.rtspHandler = null;
        }
        if (this.localStorageWriter != null) {
            this.localStorageWriter.shutdown();
            this.localStorageWriter = null;
        }
        return 0;
    }

    @Override
    public final void setSsrcfromRtsp(String ssrc) {
        if (ssrc != null) {
            this.ssrcFromRTSP = ssrc.trim();
            this.enableSSRCCheck = true;
        } else {
            this.enableSSRCCheck = false;
        }
    }

    protected final boolean isSSRCCorrect(byte[] data) {
        block10: {
            if (!this.enableSSRCCheck) {
                return true;
            }
            if (this.rtspSettings.getTransmissionID() != TransmissionType.RTP_OVER_UDP_UNICAST && this.rtspSettings.getTransmissionID() != TransmissionType.RTP_OVER_UDP_MULTICAST) {
                return true;
            }
            try {
                if (data == null || data.length < 12) break block10;
                String ssrcFromStream = Basic.byteArrayToHexString((byte[])new byte[]{data[8], data[9], data[10], data[11]}).trim();
                if (this.ssrcFromRTSP == null) break block10;
                if (!this.ssrcFromRTSP.equalsIgnoreCase(ssrcFromStream)) {
                    while (this.ssrcFromRTSP.startsWith("0")) {
                        this.ssrcFromRTSP = this.ssrcFromRTSP.substring(1);
                    }
                    while (ssrcFromStream.startsWith("0")) {
                        ssrcFromStream = ssrcFromStream.substring(1);
                    }
                    if (!this.ssrcFromRTSP.equalsIgnoreCase(ssrcFromStream)) {
                        if (this.printDebug) {
                            this.logger.info("Not matching: Stream " + ssrcFromStream + " vs. RTSP " + this.ssrcFromRTSP);
                        }
                        break block10;
                    }
                    return true;
                }
                return true;
            }
            catch (Exception e) {
                this.logger.error("Error while comparing SSRCs: " + e.getMessage());
            }
        }
        ++this.packetsWithWrongSSRC;
        if (this.packetsWithWrongSSRC % 6000L == 0L) {
            this.logger.error(this.packetsWithWrongSSRC + " packets arrived with wrong SSRC for " + super.getVideoSrv());
        }
        return false;
    }

    protected final void processRtpData(byte[] data) {
        if (this.rtspSettings != null) {
            this.useFrameCropping = this.rtspSettings.isFrameCropping();
        }
        if (this.isShutdown()) {
            return;
        }
        if (data == null) {
            this.logger.error("Incoming data is null for " + this.getVideoSrv());
            return;
        }
        try {
            PacketType packetType = PacketTypeParser.parsePacketType(data);
            switch (packetType) {
                case RTCP_RECEIVER_REPORT: {
                    break;
                }
                case RTCP_SENDER_REPORT: {
                    this.generateRTCPReceiverReport(data);
                    if (this.rtspHandler == null) break;
                    this.rtspHandler.sendReceiverReportVideo(this.receiverReport);
                    break;
                }
                case RTCP_SOURCE_DESCRIPTION: {
                    break;
                }
                case RTP: {
                    int numberOfContributingSources;
                    if (this.rtspSettings != null && (this.rtspSettings.getTransmissionID() == TransmissionType.SRTP_OVER_UDP_UNICAST || this.rtspSettings.getTransmissionID() == TransmissionType.SRTP_OVER_UDP_MULTICAST)) {
                        RtpPacket rtpPacket = new RtpPacket(data);
                        if (rtpPacket.getRtpHeader().isHasExtension() && data.length <= 20) {
                            return;
                        }
                        this.srtpTools.updateIndex(rtpPacket);
                        if (!this.srtpTools.isAuthenticated(rtpPacket)) {
                            if (this.srtpUnauthenticatedPacketCounter++ % 10000 == 0) {
                                this.logger.error("SRTP authentication failed for " + this);
                                this.listener.sendStatusService(-20100);
                                this.srtpAuthenticationErrorStatusSet = true;
                            }
                            return;
                        }
                        if (this.srtpAuthenticationErrorStatusSet) {
                            this.srtpUnauthenticatedPacketCounter = 0;
                            this.listener.sendStatusService(0);
                            this.srtpAuthenticationErrorStatusSet = false;
                        }
                        data = this.srtpTools.decrypt(rtpPacket);
                    }
                    if (!this.isSSRCCorrect(data)) break;
                    this.checkForPacketLoss(data);
                    System.arraycopy(data, 8, this.receiverReport, 8, 4);
                    System.arraycopy(data, 2, this.receiverReport, 18, 2);
                    if (this.rtspHandler != null) {
                        this.rtspHandler.storeReceiverReportVideo(this.receiverReport);
                    }
                    int rtpHeaderLength = 12;
                    if ((data[0] & 0x10) == 16 && data.length >= 16) {
                        int rtpHeaderExtensionLength = 0;
                        rtpHeaderExtensionLength |= data[14] & 0xFF;
                        rtpHeaderExtensionLength <<= 8;
                        rtpHeaderExtensionLength |= data[15] & 0xFF;
                        rtpHeaderExtensionLength *= 4;
                        rtpHeaderLength += (rtpHeaderExtensionLength += 4);
                    }
                    if (data.length < (rtpHeaderLength += (numberOfContributingSources = data[0] & 0xF) * 4)) {
                        this.logger.error("Incoming data/length is " + data.length + ". RTP Header length is " + rtpHeaderLength + ". Size is not valid to parse data. " + this.getVideoSrv());
                        return;
                    }
                    boolean paddingBit = (data[0] & 0x20) == 32;
                    byte paddingLength = 0;
                    if (paddingBit) {
                        paddingLength = data[data.length - 1];
                    }
                    if (this.isJpeg(data[1]) || this.describeResponse != null && this.describeResponse.getCodec() != null && this.describeResponse.getCodec() == Codec.MJPEG) {
                        this.processRtpDataMJPEG(data, rtpHeaderLength, paddingLength);
                        break;
                    }
                    if (data.length < rtpHeaderLength) {
                        this.logger.error("Incoming data does not contain useful information for " + this.getVideoSrv());
                        this.logger.error("Data = " + Basic.byteArrayToHexString((byte[])data));
                        return;
                    }
                    if (this.videoCodec == Codec.MPEG4 || this.describeResponse != null && this.describeResponse.getCodec() != null && this.describeResponse.getCodec() == Codec.MPEG4) {
                        this.processRtpDataMPEG4(data, rtpHeaderLength, paddingLength);
                        break;
                    }
                    if (this.videoCodec == Codec.H264 || this.describeResponse != null && this.describeResponse.getCodec() != null && this.describeResponse.getCodec() == Codec.H264 || this.videoCodec == Codec.H265 || this.describeResponse != null && this.describeResponse.getCodec() != null && this.describeResponse.getCodec() == Codec.H265) {
                        this.checkForReorderingOfRtpPackets(data);
                        for (RtpPacket processPacket : this.processSequenceBufferList) {
                            if (processPacket == null) continue;
                            if (this.videoCodec == Codec.H264 || this.describeResponse != null && this.describeResponse.getCodec() != null && this.describeResponse.getCodec() == Codec.H264) {
                                this.processRtpDataH264(processPacket, paddingLength);
                                continue;
                            }
                            if (this.videoCodec != Codec.H265 && (this.describeResponse == null || this.describeResponse.getCodec() == null || this.describeResponse.getCodec() != Codec.H265)) continue;
                            this.processRtpDataH265(processPacket, paddingLength);
                        }
                    }
                    break;
                }
            }
        }
        catch (IOException exception) {
            this.logger.error("Error [" + exception.getMessage() + "] writing startSequence/NAL for a frame for " + this);
        }
        catch (Throwable throwable) {
            this.logger.error("Ignoring packet due to unexpected error for " + this, throwable);
            this.completeFrame.reset();
        }
    }

    protected boolean isJpeg(byte data) {
        return (data = (byte)(data & 0x7F)) == 26;
    }

    private void processRtpDataMPEG4(byte[] data, int rtpHeaderLength, int paddingLength) throws SeeTecException {
        try {
            this.completeFrame.write(data, rtpHeaderLength, data.length - rtpHeaderLength - paddingLength);
            this.completeFrame.flush();
        }
        catch (IOException exception) {
            this.logger.error("Error [" + exception.getMessage() + "] cummulating mpeg4 data for a frame for " + this);
        }
        if (!StreamingHelper.isFollowUp(data)) {
            this.completeFrameAsByteArray = this.completeFrame.toByteArray();
            this.completeFrame.reset();
            this.deliverMpeg4Data(this.completeFrameAsByteArray, this.calculateTimestampFromRTP(data, this.videoCodec.getType()));
        }
    }

    private void processRtpDataMJPEG(byte[] data, int rtpHeaderLength, int paddingLength) throws SeeTecException {
        int jpegHeaderLength = 8;
        int restartMarkerHeaderLength = 0;
        int quantTableHeaderLength = 0;
        try {
            byte type = data[rtpHeaderLength + 4];
            int tempWidth = 0xFF & data[rtpHeaderLength + 6];
            int tempHeight = 0xFF & data[rtpHeaderLength + 7];
            tempWidth = tempWidth == 0 ? this.width / 8 : tempWidth;
            tempHeight = tempHeight == 0 ? this.height / 8 : tempHeight;
            this.width = tempWidth * 8;
            this.height = tempHeight * 8;
            byte[] dri = new byte[]{0, 0};
            if (type >= 64 && type <= 127) {
                restartMarkerHeaderLength = 4;
                byte[] restartMarker = new byte[restartMarkerHeaderLength];
                for (int i = 0; i < restartMarker.length; ++i) {
                    restartMarker[i] = data[rtpHeaderLength + jpegHeaderLength + i];
                }
                System.arraycopy(restartMarker, 0, dri, 0, 2);
            }
            if (this.completeFrame.size() == 0) {
                if ((data[rtpHeaderLength + 5] & 0xFF) >= 128) {
                    byte[] lengthOfQuantTableInBand = new byte[]{data[rtpHeaderLength + jpegHeaderLength + restartMarkerHeaderLength + 2], data[rtpHeaderLength + jpegHeaderLength + restartMarkerHeaderLength + 3]};
                    quantTableHeaderLength = 4 + Basic.byteArrayToInt4((byte[])lengthOfQuantTableInBand);
                }
                if (quantTableHeaderLength < 0) {
                    return;
                }
                byte[] quantTableHeader = new byte[quantTableHeaderLength];
                if (data.length < rtpHeaderLength + jpegHeaderLength + restartMarkerHeaderLength + quantTableHeaderLength) {
                    this.logger.error("Not enough jpeg data available for " + this.getVideoSrv());
                    return;
                }
                System.arraycopy(data, rtpHeaderLength + jpegHeaderLength + restartMarkerHeaderLength, quantTableHeader, 0, quantTableHeaderLength);
                byte[] header = JpegUtility.MakeHeaders((int)type, (int)tempWidth, (int)tempHeight, (byte[])dri, (int)data[rtpHeaderLength + 5], (byte[])quantTableHeader);
                this.completeFrame.write(header);
            }
            int totalHeaderLength = rtpHeaderLength + jpegHeaderLength + restartMarkerHeaderLength + quantTableHeaderLength;
            this.bytesToCopy = data.length - totalHeaderLength - paddingLength;
            if (this.bytesToCopy > 0) {
                this.completeFrame.write(data, totalHeaderLength, this.bytesToCopy);
                this.completeFrame.flush();
            } else if (StreamingHelper.isFollowUp(data)) {
                this.logger.error("No jpeg data to copy for " + this);
                return;
            }
        }
        catch (IOException exception) {
            this.logger.error("Error [" + exception.getMessage() + "] cummulating jpeg data for a frame for " + this);
        }
        if (!StreamingHelper.isFollowUp(data)) {
            MediaFrame mediaFrame = StreamingHelper.createSeeTecVideoFrameHeader(Codec.MJPEG, this.completeFrame.toByteArray(), false);
            this.deliverFrame(0, mediaFrame, this.calculateTimestampFromRTP(data, Codec.MJPEG.getType()));
            this.completeFrame.reset();
        }
    }

    protected long calculateTimestampFromRTP(byte[] data, int mediaType) {
        long timestamp = Long.MIN_VALUE;
        try {
            RTPHeader rtpHeader = new RTPHeader(data);
            timestamp = this.timestampCalculator.calculateAbsoluteTimestamp(System.currentTimeMillis(), rtpHeader, mediaType);
        }
        catch (SeeTecException seetecException) {
            this.logger.info(seetecException.getMessage() + " no valid rtpHeader for " + this);
        }
        return timestamp;
    }

    private void generateRTCPReceiverReport(byte[] data) {
        System.arraycopy(data, 4, this.receiverReport, 8, 4);
        System.arraycopy(data, 10, this.receiverReport, 24, 4);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Basic.generateIndentedMultiLineLog((String[])new String[]{"-- Sending Receiver Report RTCP Packet for " + this, "-- Header                                     : " + StreamingVideoSourceClientRTSP.byteArrayToHexString((byte[])this.receiverReport, (int)0, (int)4), "-- SSRC of Packet Sender                      : " + StreamingVideoSourceClientRTSP.byteArrayToHexString((byte[])this.receiverReport, (int)4, (int)4), "-- SSRC_1 (first Source)                      : " + StreamingVideoSourceClientRTSP.byteArrayToHexString((byte[])this.receiverReport, (int)8, (int)4), "-- fraction lost[0-7] cumulative packets lost : " + StreamingVideoSourceClientRTSP.byteArrayToHexString((byte[])this.receiverReport, (int)12, (int)4), "-- extended highest sequence number           : " + StreamingVideoSourceClientRTSP.byteArrayToHexString((byte[])this.receiverReport, (int)16, (int)4), "-- interarrival jitter                        : " + StreamingVideoSourceClientRTSP.byteArrayToHexString((byte[])this.receiverReport, (int)20, (int)4), "-- Last SR (LSR)                              : " + StreamingVideoSourceClientRTSP.byteArrayToHexString((byte[])this.receiverReport, (int)24, (int)4), "-- delay since last SR (DLSR)                 : " + StreamingVideoSourceClientRTSP.byteArrayToHexString((byte[])this.receiverReport, (int)28, (int)4)}));
        }
    }

    private void checkForReorderingOfRtpPackets(byte[] data) throws SeeTecException {
        byte[] sequence = new byte[]{0, 0, data[2], data[3]};
        this.currentSequenceNumber = Basic.byteArrayToInt4((byte[])sequence);
        if (this.doSameSequenceNumberFix && this.previousSequenceNumber == this.currentSequenceNumber) {
            if (this.doLogOutput) {
                this.logger.warn("Same sequence number (previous/current): " + this.previousSequenceNumber + " / " + this.currentSequenceNumber + " for " + this);
            }
            return;
        }
        if (this.doLogOutput && this.previousSequenceNumber + 1 != this.currentSequenceNumber && this.previousSequenceNumber != Integer.MIN_VALUE && this.previousSequenceNumber != this.MAX_RTP_SEQUENCE_NUMBER) {
            this.logger.warn("Jump in sequence number (previous/current): " + this.previousSequenceNumber + " / " + this.currentSequenceNumber + " for " + this);
        }
        RtpPacket rtpPacket = new RtpPacket(data);
        if (this.doBufferForSequenceNumberJumps) {
            if (this.doLogOutput && this.udpSequenceReorderBuffer.size() > 1) {
                LinkedList<String> output = new LinkedList<String>();
                output.add("Current buffer (Size: " + this.udpSequenceReorderBuffer.size() + "): " + this);
                output.add("Current sequence number: " + this.currentSequenceNumber);
                output.add("Previous sequence number: " + this.previousSequenceNumber);
                int i = 1;
                for (Integer key : this.udpSequenceReorderBuffer.keySet()) {
                    output.add("Buffer (" + i + ") - Key: " + key);
                    ++i;
                }
                this.logger.warn(Basic.generateIndentedMultiLineLog((String[])output.toArray(new String[output.size()])));
            }
            this.processSequenceBufferList = this.processSequenceBuffer(this.currentSequenceNumber, rtpPacket);
        } else {
            this.processSequenceBufferList.clear();
            this.processSequenceBufferList.add(rtpPacket);
        }
        if (!this.determineSequenceJump(this.previousSequenceNumber, this.currentSequenceNumber).equals((Object)SequenceJump.END_MISSED)) {
            this.previousSequenceNumber = this.currentSequenceNumber;
        }
    }

    private void processRtpDataH264(RtpPacket processPacket, int paddingLength) throws SeeTecException, IOException {
        byte[] processData = processPacket.getData();
        int processDataLength = processPacket.getLength();
        int processDataHeaderLength = processPacket.getHeaderLength();
        NALUnitPayloadStructureH264 nalUnitPayloadStructure = NALUnitPayloadStructureH264.getNALUnitPayloadStructure(processData[processDataHeaderLength]);
        switch (nalUnitPayloadStructure) {
            case FU_A: {
                if ((processData[processDataHeaderLength + 1] & 0x80) == 128) {
                    byte newNALUnitOctet = (byte)(processData[processDataHeaderLength + 1] & 0x1F);
                    byte FandNRI = (byte)(processData[processDataHeaderLength] & 0xE0);
                    newNALUnitOctet = (byte)(newNALUnitOctet | FandNRI);
                    this.completeFrame.write(StreamingHelper.START_SEQUENCE);
                    this.completeFrame.write(newNALUnitOctet);
                }
                this.completeFrame.write(processData, processDataHeaderLength + 2, processDataLength - (processDataHeaderLength + 2) - paddingLength);
                break;
            }
            case SINGLE_NAL_UNIT: {
                this.completeFrame.write(StreamingHelper.START_SEQUENCE);
                this.completeFrame.write(processData, processDataHeaderLength, processDataLength - processDataHeaderLength - paddingLength);
                if ((processData[processDataHeaderLength] & 6) != 6 && (processData[processDataHeaderLength] & 7) != 7 && (processData[processDataHeaderLength] & 8) != 8 && (processData[processDataHeaderLength] & 0x11) != 17) break;
                this.isFrameCompleted = true;
                break;
            }
            case STAP_A: {
                int lenOfAggUnit;
                this.completeFrameAsByteArray = new byte[processDataLength - processDataHeaderLength - paddingLength];
                System.arraycopy(processData, processDataHeaderLength, this.completeFrameAsByteArray, 0, processDataLength - processDataHeaderLength - paddingLength);
                long timestamp = this.calculateTimestampFromRTP(processPacket.getHeader(), Codec.H264.getType());
                for (int aggregationUnitStart = 1; aggregationUnitStart < this.completeFrameAsByteArray.length; aggregationUnitStart += lenOfAggUnit + 2) {
                    lenOfAggUnit = Basic.byteArrayToInt4((byte[])this.completeFrameAsByteArray, (int)aggregationUnitStart, (int)2);
                    byte[] aggUnit = new byte[lenOfAggUnit + StreamingHelper.START_SEQUENCE.length];
                    System.arraycopy(StreamingHelper.START_SEQUENCE, 0, aggUnit, 0, StreamingHelper.START_SEQUENCE.length);
                    System.arraycopy(this.completeFrameAsByteArray, aggregationUnitStart + 2, aggUnit, StreamingHelper.START_SEQUENCE.length, lenOfAggUnit);
                    this.deliverH264Data(aggUnit, false, timestamp);
                }
                return;
            }
            default: {
                this.logger.info("Received paket of length " + processDataLength + " has unknown/unsupported payload type \"" + (Object)((Object)nalUnitPayloadStructure) + "\"! Discarding it.");
                return;
            }
        }
        if (!StreamingHelper.isFollowUp(processData) || this.isFrameCompleted) {
            long timestamp = this.calculateTimestampFromRTP(processPacket.getHeader(), Codec.H264.getType());
            this.deliverH264Data(this.completeFrame.toByteArray(), false, timestamp);
            this.completeFrame.reset();
            this.isFrameCompleted = false;
        }
    }

    private void processRtpDataH265(RtpPacket processPacket, int paddingLength) throws SeeTecException, IOException {
        long timestamp;
        byte[] new_nal_header = new byte[2];
        byte[] processData = processPacket.getData();
        int processDataLength = processPacket.getLength();
        int processDataHeaderLength = processPacket.getHeaderLength();
        NALUnitPayloadStructureH265 nalUnitPayloadStructure = NALUnitPayloadStructureH265.getNALUnitPayloadStructure(processData[processDataHeaderLength]);
        switch (nalUnitPayloadStructure) {
            case AGGREGATED: {
                int lenOfAggUnit;
                this.completeFrameAsByteArray = new byte[processDataLength - processDataHeaderLength - paddingLength];
                System.arraycopy(processData, processDataHeaderLength, this.completeFrameAsByteArray, 0, processDataLength - processDataHeaderLength - paddingLength);
                timestamp = this.calculateTimestampFromRTP(processPacket.getHeader(), Codec.H265.getType());
                for (int aggregationUnitStart = 1; aggregationUnitStart < this.completeFrameAsByteArray.length; aggregationUnitStart += lenOfAggUnit + 2) {
                    lenOfAggUnit = Basic.byteArrayToInt4((byte[])this.completeFrameAsByteArray, (int)aggregationUnitStart, (int)2);
                    byte[] aggUnit = new byte[lenOfAggUnit + StreamingHelper.START_SEQUENCE_0001.length];
                    System.arraycopy(StreamingHelper.START_SEQUENCE_0001, 0, aggUnit, 0, StreamingHelper.START_SEQUENCE_0001.length);
                    System.arraycopy(this.completeFrameAsByteArray, aggregationUnitStart + 2, aggUnit, StreamingHelper.START_SEQUENCE_0001.length, lenOfAggUnit);
                    this.deliverH265Data(aggUnit, false, timestamp);
                }
                break;
            }
            case PACI: {
                break;
            }
            case FU: {
                boolean first_fragment = (processData[processDataHeaderLength + 2] & 0x80) == 128;
                boolean last_fragment = (processData[processDataHeaderLength + 2] & 0x40) == 64;
                int fu_type = processData[processDataHeaderLength + 2] & 0x3F;
                new_nal_header[0] = (byte)(processData[processDataHeaderLength] & 0x81 | fu_type << 1);
                new_nal_header[1] = processData[processDataHeaderLength + 1];
                if (first_fragment) {
                    this.completeFrame.write(StreamingHelper.START_SEQUENCE_0001);
                    this.completeFrame.write(new_nal_header);
                }
                int offset = processDataHeaderLength + 2 + 1;
                this.completeFrame.write(processData, offset, processDataLength - offset - paddingLength);
                break;
            }
            case VPS: 
            case SPS: 
            case PPS: 
            case SEI: {
                this.completeFrame.write(StreamingHelper.START_SEQUENCE_0001);
                this.completeFrame.write(processData, processDataHeaderLength, processDataLength - processDataHeaderLength - paddingLength);
                this.isFrameCompleted = true;
                break;
            }
            default: {
                this.completeFrame.write(StreamingHelper.START_SEQUENCE_0001);
                this.completeFrame.write(processData, processDataHeaderLength, processDataLength - processDataHeaderLength - paddingLength);
            }
        }
        if (!StreamingHelper.isFollowUp(processData) || this.isFrameCompleted) {
            timestamp = this.calculateTimestampFromRTP(processPacket.getHeader(), Codec.H265.getType());
            this.deliverH265Data(this.completeFrame.toByteArray(), false, timestamp);
            this.completeFrame.reset();
            this.isFrameCompleted = false;
        }
    }

    protected int parseBufferSizeExtension(String extension) {
        int result = this.MAX_BUFFER_SIZE;
        if (extension != null && !extension.isEmpty()) {
            try {
                String[] split;
                for (String part : split = extension.split(" ")) {
                    if (!part.contains("BUFFERSIZE")) continue;
                    String[] split2 = part.split("=");
                    result = Integer.parseInt(split2[1]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    protected List<RtpPacket> processSequenceBuffer(int sequenceNumber, RtpPacket rtpPacket) {
        Integer key;
        ArrayList<RtpPacket> result = new ArrayList<RtpPacket>();
        SequenceJump value = this.determineSequenceJump(this.previousSequenceNumber, sequenceNumber);
        if (value.equals((Object)SequenceJump.NORMAL) && sequenceNumber > this.lastProcessedSequenceNumber) {
            this.udpSequenceReorderBuffer.put(sequenceNumber, rtpPacket);
        }
        Iterator<Integer> iterator = this.udpSequenceReorderBuffer.keySet().iterator();
        while (iterator.hasNext() && (this.udpSequenceReorderBuffer.containsKey((key = iterator.next()) + 1) || value.equals((Object)SequenceJump.END_REACHED))) {
            this.lastProcessedSequenceNumber = key;
            result.add((RtpPacket)this.udpSequenceReorderBuffer.get(key));
            iterator.remove();
        }
        if (value.equals((Object)SequenceJump.END_REACHED)) {
            this.udpSequenceReorderBuffer.put(sequenceNumber, rtpPacket);
            this.lastProcessedSequenceNumber = -1;
        }
        return result;
    }

    protected SequenceJump determineSequenceJump(int previous, int current) {
        int distance = Math.abs(previous - current);
        if (previous != Integer.MIN_VALUE && distance > this.MAX_SEQUENCE_GAP && current < previous) {
            return SequenceJump.END_REACHED;
        }
        if (previous != Integer.MIN_VALUE && distance > this.MAX_SEQUENCE_GAP && current > previous) {
            return SequenceJump.END_MISSED;
        }
        return SequenceJump.NORMAL;
    }

    @Override
    public void serverTimeJumped(long jump) {
    }

    @Override
    public void cameraTimeJumped(long jump) {
    }

    @Override
    public void hugeCumulatedDriftCorrectedByJump(long jump) {
    }

    @Override
    public void sendDescribeResponse(RTSPResponse response) {
        this.describeResponse = response;
    }

    public String toString() {
        try {
            if (this.videoSrv != null) {
                return super.toString() + " Device: " + this.videoSrv.getDevice().getDeviceEntity().getEntityName() + ", Videosource: " + this.videoSrv.getEntityName() + ", Profile: " + this.listener.getVideoProfileName() + ", Host/IP: " + this.networkParameter.getHost();
            }
            return super.toString();
        }
        catch (NullPointerException ex) {
            return "Video source is null";
        }
    }

    public void executeOperationAfterDescribe() throws SeeTecException {
    }

    public void executeOperationAfterSetup() throws SeeTecException {
    }

    public void executeOperationAfterPlay() throws SeeTecException {
    }

    protected void setEdgeStorageParameter(EdgeStorageParameter edgeStorageParameter) {
        this.edgeStorageParameter = edgeStorageParameter;
    }

    public long getTimeStampFirstFrame() {
        return this.timeStampFirstFrame;
    }

    public void setTimeStampFirstFrame(long timeStampFirstFrame) {
        this.timeStampFirstFrame = timeStampFirstFrame;
    }

    public long getTimeStampLastFrame() {
        return this.timeStampLastFrame;
    }

    public boolean isStopPlaybackStream() {
        return this.stopPlaybackStream;
    }

    public void setStopPlaybackStream(boolean stopPlaybackStream) {
        this.stopPlaybackStream = stopPlaybackStream;
    }

    public void setVideoPlaybackEndTime(long videoPlaybackEndTime) {
        this.videoPlaybackEndTime = videoPlaybackEndTime;
    }

    public void setLocalStorageReady(boolean localStorageReady) {
        this.localStorageReady = localStorageReady;
    }

    protected boolean isLocalStorageReady() {
        return this.localStorageReady;
    }

    private void deliverLocalStorageFrame(int mediaType, MediaFrame mediaFrame, long timeStamp) {
        ContentFrame cf = this.createContentFrame(mediaType, mediaFrame.getData(), timeStamp);
        if (cf.getStartTimestamp() > this.videoPlaybackEndTime) {
            this.logger.info("Playback from local storage will be stopped. Frame timestamp: " + this.sdf.format(new Date(cf.getStartTimestamp())) + ", latest frame should be: " + this.sdf.format(new Date(this.videoPlaybackEndTime)));
            this.setStopPlaybackStream(true);
        } else if (cf.getStartTimestamp() < this.videoPlaybackStartingTime - 3000L) {
            this.logger.info("Frame timestamp was not valid. Timestamp of frame: " + this.sdf.format(new Date(cf.getStartTimestamp())) + " video should start at: " + this.sdf.format(new Date(this.videoPlaybackStartingTime)));
            this.setStopPlaybackStream(true);
        } else if (!this.localStorageReady) {
            this.timeStampForEarlyFrames = this.videoPlaybackStartingTime;
            this.videoQueue.add(cf);
        } else {
            while (!this.videoQueue.isEmpty()) {
                ContentFrame contentFrame = this.videoQueue.removeFirst();
                contentFrame.setStartTimestamp(++this.timeStampForEarlyFrames);
                contentFrame.setEndTimestamp(this.timeStampForEarlyFrames);
                if (this.firstDeliver) {
                    this.setTimeStampFirstFrame(this.timeStampForEarlyFrames);
                    this.firstDeliver = false;
                }
                this.deliverLocalStorageFrames(contentFrame);
            }
            if (cf.getStartTimestamp() < this.timeStampForEarlyFrames) {
                cf.setStartTimestamp(++this.timeStampForEarlyFrames);
                cf.setEndTimestamp(this.timeStampForEarlyFrames);
            }
            if (this.firstDeliver) {
                this.setTimeStampFirstFrame(cf.getStartTimestamp());
                this.firstDeliver = false;
            }
            this.deliverLocalStorageFrames(cf);
        }
    }

    private void deliverLocalStorageFrames(ContentFrame contentFrame) {
        this.getLocalStorageWriter().deliverFrameToArchive(contentFrame, true);
        if (contentFrame.isFullVideoFrame()) {
            this.timeStampLastFrame = contentFrame.getStartTimestamp();
        } else if (contentFrame.isPacked()) {
            List contentFrames = contentFrame.getUnpackedContentFrames();
            for (ContentFrame cf : contentFrames) {
                if (!cf.isFullVideoFrame()) continue;
                this.timeStampLastFrame = cf.getStartTimestamp();
            }
        } else {
            this.timeStampLastFrame = contentFrame.getStartTimestamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DatabaseWriter getLocalStorageWriter() {
        Object object = this.LOCAL_STORAGE_WRITER_SEMAPHORE;
        synchronized (object) {
            if (this.localStorageWriter != null && !this.localStorageWriter.isShutdown()) {
                return this.localStorageWriter;
            }
            if (this.core != null && this.core.isShutdown()) {
                this.logger.warn((Object)((Object)this.core) + " is already shutting down!");
                return null;
            }
            if (this.isShutdown("de.seetec.v5.re.cm.device.shared.VideoSourceClient")) {
                this.logger.warn(this + " is already shutting down!");
                return null;
            }
            DatabaseWriter databaseWriter = null;
            try {
                MDBWriterFactoryImpl mdbWriterFactory = new MDBWriterFactoryImpl(false, this.core, this.getVideoSrv(), DatabaseWriterType.LOCAL_STORAGE);
                databaseWriter = new DatabaseWriterRepository(this.core.getConfigurationProvider(), mdbWriterFactory);
                databaseWriter.init();
                this.localStorageWriter = databaseWriter;
            }
            catch (Exception e) {
                if (databaseWriter != null) {
                    databaseWriter.shutdown();
                }
                this.logger.error("Connecting MultimediaDatabase failed with error [" + this.errorCode + "] ");
                throw new RuntimeException("Initializing [LocalStorageDatabaseWriter] failed with error [" + this.errorCode + "] ");
            }
        }
        this.logger.info("... " + this.localStorageWriter + " for " + this + " created ");
        return this.localStorageWriter;
    }

    public RtspAudioSourceClient getAudioSourceClient() {
        return this.audioSourceClient;
    }

    @Override
    public void setMikey(Mikey mikey) throws Exception {
        this.srtpTools.setMikey(mikey);
        if (this.srtpToolsAudio != null) {
            this.srtpToolsAudio.setMikey(mikey);
        }
    }

    public class AudioSourceClient
    implements RtspAudioSourceClient {
        protected byte[] receiverReportAudio = new byte[32];
        private RTSPHandlerIntf listener = null;

        public AudioSourceClient(RTSPHandlerIntf listener) {
            this.listener = listener;
            this.receiverReportAudio[0] = -127;
            this.receiverReportAudio[1] = -55;
            this.receiverReportAudio[2] = 0;
            this.receiverReportAudio[3] = 7;
        }

        @Override
        public int init() {
            return 0;
        }

        @Override
        public void onNetworkError(int error) {
            if (this.listener != null) {
                this.listener.onNetworkError(error);
            } else {
                StreamingVideoSourceClientRTSP.this.logger.error("Exception while reading Audio packets for " + this + ". Shutting down... ");
                StreamingVideoSourceClientRTSP.this.shutdown();
            }
        }

        @Override
        public void processData(byte[] data) {
            try {
                int extensionHeaderLength = 0;
                if ((data[0] & 0x10) == 16) {
                    extensionHeaderLength = Basic.byteArrayToInt4((byte[])new byte[]{data[14], data[15]});
                    extensionHeaderLength *= 4;
                    extensionHeaderLength += 4;
                }
                if (data.length >= 2 && data[0] == -128 && data[1] == -56) {
                    System.arraycopy(data, 4, this.receiverReportAudio, 8, 4);
                    System.arraycopy(data, 10, this.receiverReportAudio, 24, 4);
                    if (StreamingVideoSourceClientRTSP.this.rtspHandler != null) {
                        StreamingVideoSourceClientRTSP.this.rtspHandler.sendReceiverReportAudio(this.receiverReportAudio);
                    }
                } else {
                    System.arraycopy(data, 2, this.receiverReportAudio, 18, 2);
                    if (StreamingVideoSourceClientRTSP.this.rtspHandler != null) {
                        StreamingVideoSourceClientRTSP.this.rtspHandler.storeReceiverReportAudio(this.receiverReportAudio);
                    }
                    if (StreamingVideoSourceClientRTSP.this.rtspSettings.getTransmissionID() == TransmissionType.SRTP_OVER_UDP_UNICAST || StreamingVideoSourceClientRTSP.this.rtspSettings.getTransmissionID() == TransmissionType.SRTP_OVER_UDP_MULTICAST) {
                        RtpPacket rtpPacket = new RtpPacket(data);
                        StreamingVideoSourceClientRTSP.this.srtpToolsAudio.updateIndex(rtpPacket);
                        if (!StreamingVideoSourceClientRTSP.this.srtpToolsAudio.isAuthenticated(rtpPacket)) {
                            if (StreamingVideoSourceClientRTSP.this.srtpUnauthenticatedPacketCounter++ % 10000 == 0) {
                                StreamingVideoSourceClientRTSP.this.logger.error("SRTP authentication failed for " + this);
                                this.listener.sendStatusService(-20100);
                                StreamingVideoSourceClientRTSP.this.srtpAuthenticationErrorStatusSet = true;
                            }
                            return;
                        }
                        if (StreamingVideoSourceClientRTSP.this.srtpAuthenticationErrorStatusSet) {
                            StreamingVideoSourceClientRTSP.this.srtpUnauthenticatedPacketCounter = 0;
                            this.listener.sendStatusService(0);
                            StreamingVideoSourceClientRTSP.this.srtpAuthenticationErrorStatusSet = false;
                        }
                        data = StreamingVideoSourceClientRTSP.this.srtpToolsAudio.decrypt(rtpPacket);
                    }
                    MediaFrame mediaFrame = StreamingHelper.createSeeTecAudioFrameHeader(StreamingVideoSourceClientRTSP.this.audioCodec, StreamingVideoSourceClientRTSP.this.audioBitrate % 8000 == 0 ? (byte)(StreamingVideoSourceClientRTSP.this.audioBitrate / 8000) : (byte)0, Arrays.copyOfRange(data, 12 + extensionHeaderLength, data.length));
                    StreamingVideoSourceClientRTSP.this.deliverFrameCreateServerTimestamp(16, mediaFrame);
                }
            }
            catch (Throwable t) {
                StreamingVideoSourceClientRTSP.this.logger.error("Ignoring packet due to unexpected error: " + t.getMessage());
            }
        }

        @Override
        public void shutdown() {
            this.listener = null;
            this.receiverReportAudio = null;
        }

        @Override
        public void sendStatusService(int errorCode) {
        }

        @Override
        public void sendDescribeResponse(RTSPResponse response) {
        }

        @Override
        public void setSsrcfromRtsp(String ssrc) {
        }

        @Override
        public void setMikey(Mikey mikey) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    protected static enum SequenceJump {
        NORMAL(0),
        END_MISSED(1),
        END_REACHED(2);

        private final int value;

        private SequenceJump(int value) {
            this.value = value;
        }
    }
}

