/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.videosource;

import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelper;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StreamingHelperJpeg
extends StreamingHelper {
    private static final Logger LOGGER = LogManager.getLogger(StreamingHelperJpeg.class);

    public static final boolean isJpeg(byte[] data) throws SeeTecException {
        if (data == null || data.length < 2) {
            throw new SeeTecException(-20002, "Invalid data");
        }
        return data[0] == -1 && data[1] == -40;
    }

    public static final int[] extractJpegResolution(byte[] data, boolean isJpegOverRtp) throws SeeTecException {
        if (data == null || data.length < 6) {
            throw new SeeTecException(-21711, "No valid JPEG image data");
        }
        if (!StreamingHelperJpeg.isJpeg(data)) {
            throw new SeeTecException(-21711, "No valid JPEG image");
        }
        int index = 2;
        while (data[index] == -1 && data[index + 1] != -64) {
            int length = Basic.byteArrayToInt4((byte[])new byte[]{0, 0, data[index + 2], data[index + 3]});
            if (length < 0 || length > data.length - index) {
                throw new SeeTecException(-21711, "No valid JPEG image, length after 0xFF is < 0");
            }
            index += length + 2;
        }
        if (data[index] == -1 && data[index + 1] == -64) {
            int height;
            int width;
            if (isJpegOverRtp) {
                width = Basic.byteArrayToInt4((byte[])Arrays.copyOfRange(data, index + 5, index + 7));
                height = Basic.byteArrayToInt4((byte[])Arrays.copyOfRange(data, index + 7, index + 9));
            } else {
                height = Basic.byteArrayToInt4((byte[])Arrays.copyOfRange(data, index + 5, index + 7));
                width = Basic.byteArrayToInt4((byte[])Arrays.copyOfRange(data, index + 7, index + 9));
            }
            if (width <= 0 || height <= 0) {
                throw new SeeTecException(-21710, "Resolution invalid (" + width + "x" + height + ")");
            }
            return new int[]{width, height};
        }
        throw new SeeTecException(-21711, "No valid JPEG image, no FFC0 found or no FF after last length field");
    }
}

