/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.videosource;

import de.seetec.v5.re.cm.device.shared.BitInputStream;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelperJpeg;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.util.Arrays;

public class StreamingHelper {
    public static final byte[] START_SEQUENCE = new byte[]{0, 0, 1};
    public static final byte[] START_SEQUENCE_001 = new byte[]{0, 0, 1};
    public static final byte[] START_SEQUENCE_0001 = new byte[]{0, 0, 0, 1};
    static final byte[] START_SEQUENCE_VIDEO_OBJECT_LAYER_00 = new byte[]{0, 0, 1, 32};
    static final byte[] START_SEQUENCE_VIDEO_OBJECT_LAYER_01 = new byte[]{0, 0, 1, 33};

    public static void scalingList(int sizeOfScalingList, BitInputStream bin) throws IOException {
        int lastScale = 8;
        int nextScale = 8;
        for (int j = 0; j < sizeOfScalingList; ++j) {
            int scalingList;
            if (nextScale != 0) {
                int deltaScale = StreamingHelper.readSignedExpGolomb(bin);
                nextScale = (lastScale + deltaScale + 256) % 256;
            }
            lastScale = scalingList = nextScale == 0 ? lastScale : nextScale;
        }
    }

    protected static int readSignedExpGolomb(BitInputStream bin) throws IOException {
        int value = StreamingHelper.calculateExpGolomb(bin);
        int sign = ((value & 1) << 1) - 1;
        value = ((value >> 1) + (value & 1)) * sign;
        return value;
    }

    protected static int readBitsAsInteger(BitInputStream bin, int numberOfBits) throws IOException {
        int value = 0;
        for (int i = numberOfBits - 1; i >= 0; --i) {
            int bit = bin.readBit();
            value += bit * (int)Math.pow(2.0, i);
        }
        return value;
    }

    public static int calculateExpGolomb(BitInputStream bin) throws IOException {
        int significantBits = 0;
        int tmpValue = 0;
        while (bin.readBit() == 0) {
            ++significantBits;
        }
        if (significantBits > 0) {
            for (int i = significantBits - 1; i > 0; --i) {
                tmpValue += (int)Math.pow(2 * bin.readBit(), i);
            }
            return (int)(Math.pow(2.0, significantBits) - 1.0 + (double)(tmpValue += bin.readBit()));
        }
        return 0;
    }

    public static MediaFrame createSeeTecVideoFrameHeader(Codec codec, byte[] payload) throws SeeTecException {
        return StreamingHelper.createSeeTecVideoFrameHeader(codec, payload, true);
    }

    public static MediaFrame createSeeTecVideoFrameHeader(Codec codec, byte[] payload, boolean isRTPJPEG) throws SeeTecException {
        int[] resolution;
        if (codec == Codec.MJPEG && (resolution = StreamingHelperJpeg.extractJpegResolution(payload, isRTPJPEG)).length == 2) {
            int width = resolution[0];
            int height = resolution[1];
            return StreamingHelper.createSeeTecVideoFrameHeader(codec, width, height, payload);
        }
        return null;
    }

    public static MediaFrame createSeeTecVideoFrameHeader(Codec codec, int width, int height, byte[] payload) throws SeeTecException {
        return StreamingHelper.createSeeTecVideoFrameHeader(codec, width, height, payload, null);
    }

    public static MediaFrame createSeeTecVideoFrameHeader(Codec codec, int width, int height, byte[] payload, byte[] configHeader) throws SeeTecException {
        if (codec == Codec.UNKNOWN) {
            throw new SeeTecException(-21600, "Not valid codec: " + codec);
        }
        if (width <= 0) {
            throw new SeeTecException(-21710, "Not valid image width: " + width);
        }
        if (height <= 0) {
            throw new SeeTecException(-21710, "Not valid image height: " + height);
        }
        MediaFrame mediaFrame = new MediaFrame();
        mediaFrame.setImageWidth(width);
        mediaFrame.setImageHeight(height);
        mediaFrame.setCodec(codec);
        if (configHeader != null) {
            mediaFrame.setPayload(configHeader);
        }
        mediaFrame.setPayload(payload);
        return mediaFrame;
    }

    public static MediaFrame createSeeTecAudioFrameHeader(Codec codec, int bitrate, byte[] payload) throws SeeTecException {
        return StreamingHelper.createSeeTecAudioFrameHeader(codec, bitrate, 0, payload);
    }

    public static MediaFrame createSeeTecAudioFrameHeader(Codec codec, int bitrate, int sampleRate, byte[] payload) throws SeeTecException {
        if (codec == Codec.UNKNOWN) {
            throw new SeeTecException(-21600, "Not valid codec: " + codec);
        }
        if (bitrate <= 0) {
            throw new SeeTecException(-21600, "Not valid bitrate: " + bitrate);
        }
        MediaFrame mediaFrame = new MediaFrame();
        mediaFrame.setCodec(codec);
        mediaFrame.setBitrate(bitrate);
        mediaFrame.setSampleRate(sampleRate);
        mediaFrame.setPayload(payload);
        return mediaFrame;
    }

    public static boolean isFollowUp(byte[] data) {
        boolean followUp = true;
        if (data != null && data.length > 1) {
            followUp = (data[1] & 0x80) >> 7 == 0;
        }
        return followUp;
    }

    public static int[] extractMXPEGResolution(byte[] contentBody) throws SeeTecException {
        int indexFFDA = Basic.indexOfByteArray((byte[])contentBody, (byte[])new byte[]{-1, -38}, (int)0, (boolean)true);
        int[] ret = new int[]{0, 0};
        if (indexFFDA != -1) {
            String[] headerStrings;
            byte[] header = Arrays.copyOf(contentBody, indexFFDA);
            String headerString = new String(header);
            for (String s : headerStrings = headerString.split("\r\n")) {
                String[] resY;
                String[] resX;
                if (s.startsWith("XTO") && (resX = s.split("=")).length == 2) {
                    try {
                        ret[0] = Integer.parseInt(resX[1]);
                    }
                    catch (NumberFormatException ex) {
                        throw new SeeTecException(-21687, "Error reading resolution width from String " + resX[1]);
                    }
                }
                if (!s.startsWith("YTO") || (resY = s.split("=")).length != 2) continue;
                try {
                    ret[1] = Integer.parseInt(resY[1]);
                }
                catch (NumberFormatException ex) {
                    throw new SeeTecException(-21687, "Error reading resolution height from String " + resY[1]);
                }
            }
        }
        return ret;
    }
}

