/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.videosource;

import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.KeyType;
import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.Mikey;
import de.seetec.v5.re.cm.device.shared.videosource.RtpPacket;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;

public class SrtpTools {
    private static final byte ENCRYPTION_KEY_LABEL = 0;
    private static final byte AUTHENTICATION_KEY_LABEL = 1;
    private static final byte SALTING_KEY_LABEL = 2;
    private final byte[] empty = new byte[16];
    private Cipher cipherAesEncryption;
    private Cipher cipherAesCreateSessionKey;
    private int rollOverCounter;
    private long highestReceivedSequenceNumber = 0L;
    private Mikey mikey;
    private Key key;
    private byte[] sessionSalt;
    private byte[] sessionAuthenticationKey;
    private byte[] masterKey;
    private byte[] masterSalt;

    public void setMikey(Mikey mikey) throws NoSuchAlgorithmException, NoSuchPaddingException {
        this.mikey = mikey;
        byte[] masterKeyAndSalt = mikey.getKeyDataTransportPayload().getKeyDataSubPayloads().get(0).getKey();
        this.masterKey = new byte[16];
        System.arraycopy(masterKeyAndSalt, 0, this.masterKey, 0, 16);
        this.masterSalt = new byte[14];
        System.arraycopy(masterKeyAndSalt, 16, this.masterSalt, 0, 14);
        this.cipherAesEncryption = Cipher.getInstance("AES/CTR/NoPadding");
        this.cipherAesCreateSessionKey = Cipher.getInstance("AES/CTR/NoPadding");
        this.rollOverCounter = Basic.byteArrayToInt4((byte[])this.mikey.getHeader().getCryptoSessions().get(0).getRollOverCounter());
    }

    public byte[] decrypt(RtpPacket rtpPacket) throws Exception {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        result.write(rtpPacket.getHeader());
        int lengthOfEncryptedData = this.getLengthOfEncryptedData(rtpPacket);
        byte[] keyStream = this.createKeyStream(rtpPacket, lengthOfEncryptedData);
        result.write(this.applyKeyStream(rtpPacket.getContent(), lengthOfEncryptedData, keyStream));
        return result.toByteArray();
    }

    protected int getLengthOfEncryptedData(RtpPacket rtpPacket) {
        int lengthOfAuthenticationTag = 0;
        if (this.mikey.getSecurityPolicy().isIsSrtpAuthenticated()) {
            lengthOfAuthenticationTag = this.mikey.getSecurityPolicy().getAuthenticationTagLength();
        }
        int mkiLength = 0;
        if (this.mikey.getKeyDataTransportPayload().getKeyDataSubPayloads().get(0).getKeyType().getType() == KeyType.TEK.getType()) {
            mkiLength = this.mikey.getKeyDataTransportPayload().getKeyDataSubPayloads().get(0).getMkiLength();
        }
        return rtpPacket.getLength() - rtpPacket.getHeaderLength() - lengthOfAuthenticationTag - mkiLength;
    }

    protected byte[] createKeyStream(RtpPacket rtpPacket, int length) throws Exception {
        byte[] iv = this.createInitializationVector(this.getSessionSalt(rtpPacket.getSequenceNumber()), this.rollOverCounter, rtpPacket);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (byteArrayOutputStream.size() < length) {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            this.cipherAesEncryption.init(1, this.getKey(rtpPacket.getSequenceNumber()), ivParameterSpec);
            byteArrayOutputStream.write(this.cipherAesEncryption.doFinal(this.empty));
            iv = this.increaseByteArrayValue(iv);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private Key getKey(long sequenceNumber) throws Exception {
        if (this.key == null) {
            byte[] sessionKey = this.generateSessionKey(this.mikey.getSecurityPolicy().getKeyDerivationRate(), (byte)0, this.masterSalt, this.masterKey, this.rollOverCounter, sequenceNumber, this.mikey.getSecurityPolicy().getSessionEncryptionKeyLength());
            this.key = new SecretKeySpec(sessionKey, "AES");
        }
        return this.key;
    }

    private byte[] getSessionSalt(long sequenceNumber) throws Exception {
        if (this.sessionSalt == null) {
            this.sessionSalt = this.generateSessionKey(this.mikey.getSecurityPolicy().getKeyDerivationRate(), (byte)2, this.masterSalt, this.masterKey, this.rollOverCounter, sequenceNumber, this.mikey.getSecurityPolicy().getSessionSaltKeyLength() != null ? this.mikey.getSecurityPolicy().getSessionSaltKeyLength() : 14);
        }
        return this.sessionSalt;
    }

    protected byte[] createInitializationVector(byte[] sessionSalt, int roc, RtpPacket rtpPacket) throws Exception {
        int i;
        byte[] ssrc = rtpPacket.getRtpHeader().getSsrc();
        byte[] index = this.getIndex(roc, rtpPacket.getSequenceNumber());
        byte[] iv = new byte[16];
        System.arraycopy(sessionSalt, 0, iv, 0, 14);
        for (i = 4; i < 8; ++i) {
            iv[i] = (byte)(iv[i] ^ ssrc[i - 4]);
        }
        for (i = 8; i < 14; ++i) {
            iv[i] = (byte)(iv[i] ^ index[i - 8]);
        }
        return iv;
    }

    protected byte[] getIndex(int rollOverCounter, long rtpSequenceNumber) {
        long index = (long)(rollOverCounter << 16) + rtpSequenceNumber;
        return Basic.int8ToByteArray((long)index, (int)6);
    }

    protected byte[] generateSessionKey(int keyDerivationRate, byte label, byte[] masterSalt, byte[] key, int roc, long seq, int keyLength) throws Exception {
        long r = 0L;
        long index = (long)((double)roc * Math.pow(2.0, 16.0) + (double)seq);
        if (keyDerivationRate > 0) {
            r = index / (long)keyDerivationRate;
        }
        byte[] keyId = new byte[16];
        keyId[7] = label;
        byte[] rAsByteArray = Basic.int8ToByteArray((long)r, (int)6);
        System.arraycopy(rAsByteArray, 0, keyId, 8, 6);
        byte[] x = new byte[16];
        byte[] iv = new byte[16];
        byte[] usableMasterSalt = new byte[16];
        if (masterSalt != null) {
            System.arraycopy(masterSalt, 0, usableMasterSalt, 0, 14);
        }
        for (int i = 0; i < usableMasterSalt.length; ++i) {
            x[i] = (byte)(usableMasterSalt[i] ^ keyId[i]);
        }
        ByteArrayOutputStream partOfSessionKey = new ByteArrayOutputStream();
        partOfSessionKey.write(this.encrypt(key, iv, x));
        while (partOfSessionKey.size() < keyLength) {
            x = this.increaseByteArrayValue(x);
            partOfSessionKey.write(this.encrypt(key, iv, x));
        }
        byte[] sessionKey = new byte[keyLength];
        System.arraycopy(partOfSessionKey.toByteArray(), 0, sessionKey, 0, keyLength);
        return sessionKey;
    }

    protected byte[] encrypt(byte[] masterKey, byte[] iv, byte[] plaintext) throws Exception {
        int keyLength = this.mikey.getSecurityPolicy().getSessionEncryptionKeyLength();
        byte[] keyData = new byte[keyLength];
        System.arraycopy(masterKey, 0, keyData, 0, keyLength);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(plaintext);
        SecretKeySpec secretKey = new SecretKeySpec(keyData, "AES");
        this.cipherAesCreateSessionKey.init(1, (Key)secretKey, ivParameterSpec);
        return this.cipherAesCreateSessionKey.doFinal(iv);
    }

    protected byte[] increaseByteArrayValue(byte[] inputVector) {
        byte[] result = inputVector;
        byte lastByte = inputVector[inputVector.length - 1];
        byte secondLastByte = inputVector[inputVector.length - 2];
        if (lastByte != -1) {
            lastByte = (byte)(lastByte + 1);
        } else {
            lastByte = 0;
            secondLastByte = secondLastByte != -1 ? (byte)(secondLastByte + 1) : (byte)0;
        }
        result[result.length - 1] = lastByte;
        result[result.length - 2] = secondLastByte;
        return result;
    }

    public boolean isAuthenticated(RtpPacket rtpPacket) throws Exception {
        int keyDerivationRate = this.mikey.getSecurityPolicy().getKeyDerivationRate() == null ? 0 : this.mikey.getSecurityPolicy().getKeyDerivationRate();
        int authenticationTagLength = this.mikey.getSecurityPolicy().getAuthenticationTagLength();
        byte[] bytesToAuthenticate = new byte[rtpPacket.getLength() - authenticationTagLength];
        byte[] authenticationTag = new byte[authenticationTagLength];
        byte[] rolloverCounterAsByteArray = Basic.int4ToByteArray((int)this.rollOverCounter, (int)4);
        System.arraycopy(rtpPacket.getData(), 0, bytesToAuthenticate, 0, bytesToAuthenticate.length);
        System.arraycopy(rolloverCounterAsByteArray, 0, bytesToAuthenticate, bytesToAuthenticate.length - 4, 4);
        System.arraycopy(rtpPacket.getData(), rtpPacket.getLength() - authenticationTagLength, authenticationTag, 0, authenticationTagLength);
        HmacUtils hmacUtils = new HmacUtils(HmacAlgorithms.HMAC_SHA_1, this.getSessionAuthenticationKey(keyDerivationRate, rtpPacket.getSequenceNumber()));
        byte[] convertme = hmacUtils.hmac(bytesToAuthenticate);
        return this.isIncluded(authenticationTag, convertme);
    }

    private byte[] getSessionAuthenticationKey(int keyDerivationRate, long sequenceNumber) throws Exception {
        if (this.sessionAuthenticationKey == null) {
            this.sessionAuthenticationKey = this.generateSessionKey(keyDerivationRate, (byte)1, this.masterSalt, this.masterKey, this.rollOverCounter, sequenceNumber, this.mikey.getSecurityPolicy().getSessionAuthenticationKeyLength());
        }
        return this.sessionAuthenticationKey;
    }

    protected boolean isIncluded(byte[] subset, byte[] superset) {
        for (int i = 0; i < subset.length; ++i) {
            if (subset[i] == superset[i]) continue;
            return false;
        }
        return true;
    }

    private byte[] applyKeyStream(byte[] encryptedData, int lengthOfEncryptedData, byte[] keyStream) throws Exception {
        if (encryptedData == null) {
            throw new Exception("Encrypted data is null");
        }
        if (keyStream == null) {
            throw new Exception("KeyStream is null");
        }
        if (lengthOfEncryptedData > keyStream.length) {
            throw new Exception("SRTP KeyStream is shorter then encrypted data. Length of data: " + encryptedData.length + ", length of KeyStream: " + keyStream.length);
        }
        byte[] result = new byte[lengthOfEncryptedData];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)(encryptedData[i] ^ keyStream[i]);
        }
        return result;
    }

    public void updateIndex(RtpPacket rtpPacket) throws SeeTecException {
        long sequenceNumber = rtpPacket.getSequenceNumber();
        if (sequenceNumber == 0L && this.highestReceivedSequenceNumber != 0L || sequenceNumber > 0L && sequenceNumber < this.highestReceivedSequenceNumber - 32768L) {
            ++this.rollOverCounter;
        }
        this.highestReceivedSequenceNumber = sequenceNumber;
    }
}

