/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.videosource;

import de.seetec.v5.re.cm.device.shared.videosource.RTPHeader;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Arrays;

public class RtpPacket
implements Comparable<RtpPacket> {
    private byte[] data;
    private int length;
    private int headerLength;
    private long extendedSequenceNumber;

    public RtpPacket(byte[] data) throws SeeTecException {
        if (data == null) {
            throw new SeeTecException(-21601, "Input data is null");
        }
        if (data.length >= 14 && data[0] == -128 && data[1] == -56) {
            throw new SeeTecException(-21601, "Input data is an RTCP sender report packet");
        }
        this.data = data;
        this.length = data.length;
        if ((data[0] & 0x10) == 16 && data.length >= 16) {
            int rtpHeaderExtensionLength = 0;
            rtpHeaderExtensionLength |= data[14] & 0xFF;
            rtpHeaderExtensionLength <<= 8;
            rtpHeaderExtensionLength |= data[15] & 0xFF;
            rtpHeaderExtensionLength *= 4;
            this.headerLength = 12 + (rtpHeaderExtensionLength += 4);
        } else {
            this.headerLength = 12;
        }
        if (data.length < this.headerLength) {
            throw new SeeTecException(-21601, "Input data length [" + data.length + "] is to small");
        }
    }

    public static boolean isRtpPacket(byte[] data) {
        return data != null && (data.length < 14 || data[0] != -128 || data[1] != -56);
    }

    public byte[] getData() {
        return this.data;
    }

    public RTPHeader getRtpHeader() throws SeeTecException {
        return new RTPHeader(this.getHeader());
    }

    public byte[] getHeader() {
        return Arrays.copyOfRange(this.data, 0, this.headerLength);
    }

    public boolean hasMarkerFlag() {
        boolean hasMarker = false;
        if (this.data != null && this.data.length > 1) {
            hasMarker = (this.data[1] & 0x80) >> 7 == 1;
        }
        return hasMarker;
    }

    public byte[] getContent() {
        return Arrays.copyOfRange(this.data, this.headerLength, this.length);
    }

    public int getHeaderLength() {
        return this.headerLength;
    }

    public int getLength() {
        return this.length;
    }

    public long getSequenceNumber() throws SeeTecException {
        return this.getRtpHeader().getSequenceNumber();
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Arrays.hashCode(this.data);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RtpPacket other = (RtpPacket)obj;
        return Arrays.equals(this.data, other.data);
    }

    @Override
    public int compareTo(RtpPacket rtpPacket) {
        if (this.getExtendedSequenceNumber() > rtpPacket.getExtendedSequenceNumber()) {
            return 1;
        }
        if (this.getExtendedSequenceNumber() < rtpPacket.getExtendedSequenceNumber()) {
            return -1;
        }
        return 0;
    }

    public void setExtendedSequenceNumber(long extendedSequenceNumber) throws SeeTecException {
        this.extendedSequenceNumber = extendedSequenceNumber;
    }

    public long getExtendedSequenceNumber() {
        return this.extendedSequenceNumber;
    }
}

