/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.videosource;

import de.seetec.v5.re.cm.device.shared.videosource.PacketType;

public final class PacketTypeParser {
    private static final byte SENDERREPORT = -56;
    private static final byte RECEIVERREPORT = -55;
    private static final byte SOURCEDESCRIPTION = -54;

    private PacketTypeParser() {
        throw new UnsupportedOperationException();
    }

    public static PacketType parsePacketType(byte[] packetData) {
        PacketType packetType = PacketType.RTP;
        if (PacketTypeParser.isRTCPSenderReport(packetData)) {
            packetType = PacketType.RTCP_SENDER_REPORT;
        } else if (PacketTypeParser.isRTCPReceiverReport(packetData)) {
            packetType = PacketType.RTCP_RECEIVER_REPORT;
        } else if (PacketTypeParser.isRTCPSourceDescription(packetData)) {
            packetType = PacketType.RTCP_SOURCE_DESCRIPTION;
        }
        return packetType;
    }

    private static boolean isRTCPSenderReport(byte[] data) {
        return PacketTypeParser.checkForCorrectType(data, (byte)-56);
    }

    private static boolean isRTCPReceiverReport(byte[] data) {
        return PacketTypeParser.checkForCorrectType(data, (byte)-55);
    }

    private static boolean isRTCPSourceDescription(byte[] data) {
        return PacketTypeParser.checkForNeededRTCPLength(data) && data[1] == -54 && PacketTypeParser.checkForCorrectRTCPVersion((byte)(data[0] & 0xFFFFFFC0));
    }

    private static boolean checkForCorrectType(byte[] data, byte typeToCheck) {
        return PacketTypeParser.checkForNeededRTCPLength(data) && PacketTypeParser.checkForCorrectRTCPVersion(data) && data[1] == typeToCheck;
    }

    private static boolean checkForCorrectRTCPVersion(byte[] data) {
        return PacketTypeParser.checkForCorrectRTCPVersion(data[0]);
    }

    private static boolean checkForCorrectRTCPVersion(byte data) {
        return data == -128;
    }

    private static boolean checkForNeededRTCPLength(byte[] data) {
        return data.length >= 14;
    }
}

