/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.videosource;

import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPResponse;
import de.seetec.v5.re.cm.device.shared.videosource.H264Data;
import de.seetec.v5.re.cm.device.shared.videosource.MediaFrameWrapper;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelper;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelperH264;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.List;

public class MediaFrameBuilder {
    private final Device device;
    private final Basic basic;
    private byte[] parameterSetPart = null;
    private byte[] pictureSet = null;
    private RTSPResponse describeResponse = null;
    private byte[] configHeader = null;
    private int width = Integer.MIN_VALUE;
    private int height = Integer.MIN_VALUE;
    private boolean useFrameCropping;
    private boolean firstIFramePart = true;
    private byte[] firstPartIFrame;
    private boolean firstPFramePart = true;
    private byte[] firstPartPFrame;

    public MediaFrameBuilder(Device device, Basic basic) {
        this.device = device;
        this.basic = basic;
    }

    public MediaFrameWrapper buildH264MediaFrame(byte[] data, boolean checkResolution) throws SeeTecException {
        int mediaType = StreamingHelperH264.checkForH264MediaType(this.device, data);
        H264Data h264Data = new H264Data(mediaType, data, checkResolution, this.parameterSetPart, this.pictureSet, this.describeResponse, this.configHeader, false, this.width, this.height, this.useFrameCropping, this.firstIFramePart, this.firstPartIFrame, this.firstPFramePart, this.firstPartPFrame, false, false);
        MediaFrame mediaFrame = StreamingHelperH264.processH264Data(h264Data, this.basic);
        this.parameterSetPart = h264Data.getParameterSetPart();
        this.pictureSet = h264Data.getPictureSet();
        this.configHeader = h264Data.getConfigHeader();
        this.describeResponse = h264Data.getDescribeResponse();
        this.width = h264Data.getWidth();
        this.height = h264Data.getHeight();
        this.firstIFramePart = h264Data.isFirstIFramePart();
        this.firstPartIFrame = h264Data.getFirstPartIFrame();
        this.firstPFramePart = h264Data.isFirstPFramePart();
        this.firstPartPFrame = h264Data.getFirstPartPFrame();
        return mediaFrame != null ? new MediaFrameWrapper(mediaFrame, mediaType) : null;
    }

    public MediaFrameWrapper buildH264MediaFrameWithSpsAndPps(byte[] data) {
        List<byte[]> h264parts = StreamingHelperH264.parseH264Data(data);
        MediaFrameWrapper mediaFrame = h264parts.stream().map(part -> {
            try {
                return this.buildH264MediaFrame((byte[])part, false);
            }
            catch (SeeTecException ex) {
                return null;
            }
        }).filter(wrapper -> wrapper != null).findFirst().get();
        return mediaFrame;
    }

    public MediaFrameWrapper buildPcmMediaFrame(byte[] data, int bitrate, int sampleRate) throws SeeTecException {
        MediaFrame mediaFrame = StreamingHelper.createSeeTecAudioFrameHeader(Codec.PCM, bitrate, sampleRate, data);
        return new MediaFrameWrapper(mediaFrame, 16);
    }
}

