/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.videoprofile;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.videoprofile.MulticastGateway;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.shared.communication.ProfileHandler;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.re.shared.VideoSourceParameter;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class VideoProfileHandler
extends Basic
implements ProfileHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.shared.VideoProfileHandler";
    protected Logger logger = null;
    protected Core core = null;
    protected LiveCameraSrv cameraSrv = null;
    protected MulticastGateway multicastGateway = null;
    protected VideoSourceClient videoSourceClient = null;
    private final List<ContentFrame> bufferedVideoFrames = Collections.synchronizedList(new LinkedList());
    private boolean hardwareMotionDetection = false;
    private int dynamicVideoProfileID = -1;
    private final Semaphore discardSemaphore = new Semaphore(1);

    public VideoProfileHandler() {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    protected int init(Core core, LiveCameraSrv cameraSrv, int dynamicVideoProfileID) {
        this.core = core;
        if (this.core == null) {
            return -21601;
        }
        this.cameraSrv = cameraSrv;
        if (this.cameraSrv == null) {
            return -21601;
        }
        this.dynamicVideoProfileID = dynamicVideoProfileID;
        if (this.dynamicVideoProfileID < 0) {
            return -21601;
        }
        return 0;
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return this.shutdownVideoSourceClient();
    }

    public int shutdownVideoSourceClient() {
        int errorCode = 0;
        if (this.videoSourceClient != null) {
            errorCode = this.videoSourceClient.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Shutting down " + (Object)((Object)this.videoSourceClient) + " failed with error [" + errorCode + "] :-(");
            }
            this.videoSourceClient = null;
        }
        return errorCode;
    }

    public abstract void checkFramerate();

    public int checkNetwork() {
        if (this.videoSourceClient == null) {
            this.discard();
            return 0;
        }
        if (this.videoSourceClient.getLifetime() > 2678400000L) {
            this.logger.info("Lifetime of " + (Object)((Object)this.videoSourceClient) + " has expired!");
            this.discard();
            return 0;
        }
        if (this.videoSourceClient.isShutdown()) {
            this.logger.info("Invalid " + (Object)((Object)this.videoSourceClient) + " for " + this + " detected! Discarding ...");
            this.discard();
        }
        return 0;
    }

    @Override
    public long getFramerate() {
        return this.getHighestFramerate();
    }

    @Override
    public void discard() {
        try {
            if (!this.discardSemaphore.tryAcquire()) {
                this.logger.info("Cannot aquire [discardSemaphore] for " + this);
                return;
            }
            this.synchronizedDiscard();
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        this.discardSemaphore.release();
    }

    private void synchronizedDiscard() {
        if (this.core != null && this.core.isShutdown()) {
            return;
        }
        this.bufferedVideoFrames.clear();
        if (this.videoSourceClient != null) {
            this.videoSourceClient.shutdown();
            this.videoSourceClient = null;
        }
        if (this.isShutdown() || this.core.isShutdown()) {
            return;
        }
        if (this.cameraSrv.isStreamOnDemandActivatedAndStreamDisabled()) {
            return;
        }
        long framerate = this.getHighestFramerate();
        if (framerate > 0L) {
            if (this.cameraSrv.checkReachability(this) == 0) {
                int errorCode = this.tryCreateVideoSourceClient();
                if (errorCode != 0) {
                    this.sendStatusService(errorCode);
                }
            } else {
                this.logger.error("Checking  [Reachability] for " + this + " failed :-(");
            }
        }
    }

    private int tryCreateVideoSourceClient() {
        int errorCode = 0;
        try {
            this.videoSourceClient = this.cameraSrv.createVideoSourceClient(this.core, this);
            if (this.videoSourceClient == null) {
                this.logger.error("Creating [VideoSourceClient] failed for " + this);
                errorCode = -20001;
            }
            if (this.isShutdown()) {
                this.logger.warn("Finished starting up " + (Object)((Object)this.videoSourceClient) + ". Meantime driver got a shutdown. Assure VideoSourceClient is now shutdown.");
                this.shutdownVideoSourceClient();
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Error while creating Video Source Client: " + ex.getMessage() + ", Errorcode: " + ex.getErrorCode());
            errorCode = ex.getErrorCode();
        }
        return errorCode;
    }

    public abstract int checkEdgeStorageOnDeviceStart();

    @Override
    public void sendStatusService(int statusCode) {
        this.cameraSrv.sendStatusService(statusCode);
    }

    public void notifyForNetworkProblems() {
        this.cameraSrv.notifyForNetworkProblems();
        this.cameraSrv.sendStatusService(-21603);
    }

    public abstract long getHighestFramerate();

    protected final void addToVideoBuffer(Codec codec, ContentFrame cf) {
        try {
            if (cf != null) {
                int mediatype = cf.getMediatype();
                switch (mediatype) {
                    case 33: {
                        this.bufferedVideoFrames.clear();
                        this.bufferedVideoFrames.add(cf);
                        break;
                    }
                    case 35: {
                        this.bufferedVideoFrames.add(cf);
                        break;
                    }
                    case 0: {
                        if (codec == Codec.MJPEG) {
                            this.bufferedVideoFrames.clear();
                            this.bufferedVideoFrames.add(cf);
                            break;
                        }
                        this.bufferedVideoFrames.add(cf);
                        ArrayList<ContentFrame> oldVideoFrames = new ArrayList<ContentFrame>();
                        for (ContentFrame cfToCheck : this.bufferedVideoFrames) {
                            if (cfToCheck.getStartTimestamp() >= cf.getStartTimestamp() - 2000L) continue;
                            oldVideoFrames.add(cfToCheck);
                        }
                        this.bufferedVideoFrames.removeAll(oldVideoFrames);
                        break;
                    }
                }
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            throw new RuntimeException(ex.getMessage());
        }
    }

    public final LinkedList<ContentFrame> getVideoBuffer() {
        LinkedList<ContentFrame> result = new LinkedList<ContentFrame>();
        result.addAll(this.bufferedVideoFrames);
        return result;
    }

    public final boolean isMPEG() {
        try {
            Codec streamingMode = this.getVideoSourceParameter().getMediaCodec();
            return streamingMode == Codec.MPEG4 || streamingMode == Codec.H264 || streamingMode == Codec.H265;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            throw new RuntimeException(ex.getMessage());
        }
    }

    public abstract boolean isStandardVideoProfile();

    public abstract VideoSourceParameter getVideoSourceParameter();

    public abstract String getVideoProfileName();

    @Override
    public VideoProfileHandler getVideoProfileHandler() {
        return this;
    }

    public VideoSourceClient getVideoSourceClient() {
        return this.videoSourceClient;
    }

    public void setHardwareMotionDetection(boolean activate) {
        this.hardwareMotionDetection = activate;
    }

    public boolean hasHardwareMotionDetection() {
        return this.hardwareMotionDetection;
    }

    public int getDynamicVideoProfileID() {
        return this.dynamicVideoProfileID;
    }

    public final MulticastGateway getMulticastGateway() {
        return this.multicastGateway;
    }

    public LiveCameraSrv getLiveCameraSrv() {
        return this.cameraSrv;
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.device.shared.VideoProfileHandler@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", DynamicVideoProfileID=[" + this.dynamicVideoProfileID + "], " + this.cameraSrv + ", " + this.getVideoSourceParameter() + ", " + (Object)((Object)this.videoSourceClient) + "]";
    }
}

