/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.videoprofile;

import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.util.ConfigurationException;
import java.io.Serializable;
import java.util.Comparator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VideoProfileComparator
implements Comparator<VideoProfileHandler>,
Serializable {
    private static final long serialVersionUID = 8659873936638310157L;
    protected transient Logger logger = null;
    private ORDER_MODE orderMode = ORDER_MODE.CODEC_RESOLUTION;

    public VideoProfileComparator(ORDER_MODE orderMode) {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        this.orderMode = orderMode;
    }

    @Override
    public int compare(VideoProfileHandler vph1, VideoProfileHandler vph2) {
        int result = 0;
        Codec vph1Codec = Codec.H264;
        long vph1Res = 0L;
        Codec vph2Codec = Codec.H264;
        long vph2Res = 0L;
        try {
            vph1Codec = vph1.getVideoSourceParameter().getMediaCodec();
            vph1Res = vph1.getVideoSourceParameter().getImageSize()[0] * vph1.getVideoSourceParameter().getImageSize()[1];
        }
        catch (ConfigurationException ex) {
            this.logger.error("Exception while getting camera configuration for " + vph1.getVideoProfileName(), (Throwable)ex);
        }
        try {
            vph2Codec = vph2.getVideoSourceParameter().getMediaCodec();
            vph2Res = vph2.getVideoSourceParameter().getImageSize()[0] * vph2.getVideoSourceParameter().getImageSize()[1];
        }
        catch (ConfigurationException ex) {
            this.logger.error("Exception while getting camera configuration for " + vph2.getVideoProfileName(), (Throwable)ex);
        }
        if (this.orderMode == ORDER_MODE.CODEC_RESOLUTION) {
            if ((vph1Codec == Codec.H264 || vph1Codec == Codec.MPEG4) && vph2Codec == Codec.MJPEG) {
                result = -1;
            } else if (vph1Codec == Codec.MJPEG && (vph2Codec == Codec.MPEG4 || vph2Codec == Codec.H264)) {
                result = 1;
            } else if ((vph1Codec == Codec.H264 || vph1Codec == Codec.MPEG4) && (vph2Codec == Codec.H264 || vph2Codec == Codec.MPEG4) || vph1Codec == Codec.MJPEG && vph2Codec == Codec.MJPEG) {
                result = vph1Res > vph2Res ? -1 : (vph1Res < vph2Res ? 1 : 0);
            }
        } else if (this.orderMode == ORDER_MODE.RESOLUTION_ONLY) {
            result = vph1Res > vph2Res ? -1 : (vph1Res < vph2Res ? 1 : 0);
        } else if ((vph1Codec == Codec.H264 || vph1Codec == Codec.MPEG4) && vph2Codec == Codec.MJPEG) {
            result = -1;
        } else if (vph1Codec == Codec.MJPEG && (vph2Codec == Codec.MPEG4 || vph2Codec == Codec.H264)) {
            result = 1;
        } else if ((vph1Codec == Codec.H264 || vph1Codec == Codec.MPEG4) && (vph2Codec == Codec.H264 || vph2Codec == Codec.MPEG4) || vph1Codec == Codec.MJPEG && vph2Codec == Codec.MJPEG) {
            result = 0;
        }
        return result;
    }

    public static enum ORDER_MODE {
        CODEC_RESOLUTION,
        RESOLUTION_ONLY,
        CODEC_ONLY;

    }
}

