/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.videoprofile;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.videoprofile.MulticastGateway;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.PlaybackVideoSourceClient;
import de.seetec.v5.re.cm.device.shared.videosource.PlaybackVideoSourceClientFactory;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.acutvista.AcutvistaCameraSrv;
import de.seetec.v5.re.cm.device.video.acutvista.jpeg.AcutvistaJPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.americandynamics.AmericanDynamicsVideoSourceClient;
import de.seetec.v5.re.cm.device.video.americandynamics.AmericanDynamicsVideoSourceClient400;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionCameraSrv;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionVideoSourceClientCGI;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionVideoSourceClientISAPI;
import de.seetec.v5.re.cm.device.video.ids.IdsVideoSourceClient;
import de.seetec.v5.re.cm.device.video.iqinvision.jpeg.IQinVisionJPEGSingleImageVideoSourceClient;
import de.seetec.v5.re.cm.device.video.lumenera.LumeneraCameraSrv;
import de.seetec.v5.re.cm.device.video.lumenera.jpeg.LumeneraJPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.mobotix.MobotixCameraSrv;
import de.seetec.v5.re.cm.device.video.mobotix.MobotixVideoSourceClient;
import de.seetec.v5.re.cm.device.video.pelco.jpeg.PelcoJPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.samsung.SamsungCameraSrv;
import de.seetec.v5.re.cm.device.video.samsung.SamsungVideoSourceClient;
import de.seetec.v5.re.cm.device.video.samsung.jpeg.SamsungJPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.santec.SantecCameraSrv;
import de.seetec.v5.re.cm.device.video.santec.SantecVideoSourceClient;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoCameraSrv;
import de.seetec.v5.re.cm.device.video.sanyo.jpeg.SanyoJPEGVideoSourceClient_HD1;
import de.seetec.v5.re.cm.device.video.sanyo.jpeg.SanyoJPEGVideoSourceClient_HD2;
import de.seetec.v5.re.cm.device.video.siemens.SiemensCameraSrv;
import de.seetec.v5.re.cm.device.video.siemens.SiemensVideoSourceClient;
import de.seetec.v5.re.cm.device.video.siemens.jpeg.SiemensJPEGVideoSourceClient_1345;
import de.seetec.v5.re.cm.device.video.siqura.jpeg.SiquraJPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.sony.SonyCameraSrv;
import de.seetec.v5.re.cm.device.video.sony.jpeg.SonyJPEGVideoSourceClient;
import de.seetec.v5.re.cm.shared.communication.LiveReader;
import de.seetec.v5.re.cm.shared.communication.NetworkClientReaderSubscriber;
import de.seetec.v5.re.cm.shared.sql.DataObjectEdgeStorageMarker;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.re.shared.EdgeStorageMode;
import de.seetec.v5.re.shared.EdgeStorageParameter;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.re.shared.SynchronizationTime;
import de.seetec.v5.re.shared.VideoSourceParameter;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.Day;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class BasicVideoProfileHandler
extends VideoProfileHandler
implements Runnable,
NetworkClientReaderSubscriber {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.shared.BasicVideoProfileHandler";
    private long actualFramerate = 0L;
    private boolean checkingFramerateActive = false;
    private VideoSourceParameter standardVideoSourceParameter = null;
    private VideoSourceParameter alarmVideoSourceParameter = null;
    private final Object SPC_SEMAPHORE = new Object();
    private PlaybackVideoSourceClient gapFillingPlaybackVideoSourceClient;
    private final List<PlaybackVideoSourceClient> fullImportPlaybackVideoSourceClients = new ArrayList<PlaybackVideoSourceClient>();
    private EdgeStorageParameter edgeStorageParameter;
    private Thread thread;

    public int init(Core core, LiveCameraSrv cameraSrv, VideoSourceParameter standardVideoSourceParameter, VideoSourceParameter alarmVideoSourceParameter, int dynamicVideoProfileID) {
        block17: {
            int errorCode = super.init(core, cameraSrv, dynamicVideoProfileID);
            if (errorCode != 0) {
                this.logger.error("Initializing " + this + " failed with error [" + errorCode + "]");
                return errorCode;
            }
            this.standardVideoSourceParameter = standardVideoSourceParameter;
            if (this.standardVideoSourceParameter == null) {
                return -21601;
            }
            this.alarmVideoSourceParameter = alarmVideoSourceParameter;
            if (this.alarmVideoSourceParameter == null) {
                return -21601;
            }
            try {
                String[] multicastConfiguration = this.getVideoSourceParameter().getMulticastConfiguration();
                if (multicastConfiguration == null) break block17;
                String address = multicastConfiguration[0];
                int port = Integer.parseInt(multicastConfiguration[1]);
                int ttl = 1;
                try {
                    ttl = Integer.parseInt(multicastConfiguration[2]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.multicastGateway = new MulticastGateway(core, this.cameraSrv.getEntityID(), address, port, ttl);
                    this.logger.info("MulticastGateway created: " + this.multicastGateway + " / " + this.cameraSrv);
                }
                catch (IllegalArgumentException e) {
                    throw new Exception("Establishing Multicast gateway at [" + multicastConfiguration[0] + ":" + multicastConfiguration[1] + "] failed: " + e.getMessage());
                }
            }
            catch (Throwable ex) {
                this.logger.error((Object)ex, ex);
                return -21600;
            }
        }
        try {
            long videoSourceId = this.cameraSrv.getEntityID();
            long currentTime = System.currentTimeMillis();
            DataObjectEdgeStorageMarker dataObjectEdgeStorageMarker = this.core.getSqlDatabaseHandler().getMarker(videoSourceId);
            if (dataObjectEdgeStorageMarker == null || dataObjectEdgeStorageMarker.getTimestamp() == null) {
                this.core.getSqlDatabaseHandler().setMarker(new DataObjectEdgeStorageMarker(videoSourceId, currentTime));
                this.logger.info("Initial marker set to " + new Date(currentTime) + " for " + videoSourceId);
            }
        }
        catch (Throwable throwable) {
            this.logger.warn("Could not set (initial) marker for " + this + " Exception: " + throwable);
        }
        try {
            VideoSourceParameter videoSourceParameter = this.getVideoSourceParameter();
            if (videoSourceParameter != null) {
                this.edgeStorageParameter = videoSourceParameter.getEdgeStorageParameter();
                if (this.edgeStorageParameter.isEnabled() && this.edgeStorageParameter.getSynchronizationTimes().length > 0) {
                    this.logger.info("START THREAD FOR EDGE STORAGE SYNC TIMES for " + this);
                    this.thread = new Thread((Runnable)this, CLASS_NAME);
                    this.thread.start();
                }
                if (this.edgeStorageParameter != null && this.edgeStorageParameter.isEnabled() && this.edgeStorageParameter.isCheckOnDeviceStart()) {
                    PlaybackVideoSourceClient localPlaybackVideoSourceClient = this.providePlaybackVideoSourceClient(false);
                    this.core.getEdgeStorageHandler().addPlaybackVideoSourceClient(localPlaybackVideoSourceClient);
                }
            }
        }
        catch (Throwable throwable) {
            this.logger.error("Error while initializing cyclic check for sync times for PlaybackVideoSourceClient for " + this.cameraSrv, throwable);
            return -21600;
        }
        return 0;
    }

    @Override
    public int checkEdgeStorageOnDeviceStart() {
        try {
            VideoSourceParameter videoSourceParameter = this.getVideoSourceParameter();
            if (videoSourceParameter != null) {
                EdgeStorageParameter tempEdgeStorageParameter = videoSourceParameter.getEdgeStorageParameter();
                if (tempEdgeStorageParameter.isEnabled() && tempEdgeStorageParameter.isCheckOnDeviceStart()) {
                    this.logger.info("DO CHECK ON START FOR EDGE STORAGE for " + this);
                    final long timestampStart = System.currentTimeMillis();
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            while (System.currentTimeMillis() < timestampStart + TimeUnit.SECONDS.toMillis(30L)) {
                                try {
                                    Thread.sleep(10L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            PlaybackVideoSourceClient localPlaybackVideoSourceClient = BasicVideoProfileHandler.this.providePlaybackVideoSourceClient(false);
                            BasicVideoProfileHandler.this.core.getEdgeStorageHandler().addPlaybackVideoSourceClient(localPlaybackVideoSourceClient);
                        }
                    }, "CheckEdgeStorageOnDeviceStart for " + this.toString());
                    t.start();
                }
                return 0;
            }
        }
        catch (Throwable throwable) {
            this.logger.error("Error while initializing EdgeStorage/adding local PlaybackVideoSourceClient to EdgeStorageHandler on device start for " + this.cameraSrv, throwable);
        }
        return -21600;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optionalMobotixDiscarding(MobotixCameraSrv mobotixCameraSrv, String videoMode) {
        if (this.core != null && this.core.isShutdown()) {
            return;
        }
        Object object = this.SPC_SEMAPHORE;
        synchronized (object) {
            try {
                int[] imgSize;
                long highestFramerate = this.getHighestFramerate();
                MobotixVideoSourceClient mobotixVideoSourceClient = (MobotixVideoSourceClient)this.videoSourceClient;
                if (this.videoSourceClient == null || this.videoSourceClient.isShutdown() || mobotixVideoSourceClient.getFramerate() != highestFramerate) {
                    this.discard();
                    return;
                }
                Integer milliCompression = mobotixCameraSrv.getVideoSourceCnf().getQuality(videoMode);
                int errorCode = mobotixVideoSourceClient.setImageParameter(null, milliCompression, imgSize = mobotixCameraSrv.getVideoSourceCnf().getImageSize(videoMode));
                if (errorCode != 0) {
                    this.logger.warn("Setting stream parameter failed with error [" + errorCode + "]");
                }
            }
            catch (Exception ex) {
                this.logger.error((Object)ex, (Throwable)ex);
                throw new RuntimeException(ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optionalSantecDiscarding(SantecCameraSrv santecCameraSrv, String videoMode) {
        int errorCode = 0;
        if (this.core != null && this.core.isShutdown()) {
            return;
        }
        Object object = this.SPC_SEMAPHORE;
        synchronized (object) {
            try {
                SantecVideoSourceClient santecVideoSourceClient = (SantecVideoSourceClient)this.videoSourceClient;
                if (this.videoSourceClient == null || this.videoSourceClient.isShutdown()) {
                    this.discard();
                    return;
                }
                long frameRate = this.getHighestFramerate();
                int width = this.getVideoSourceParameter().getImageSize()[0];
                int heigth = this.getVideoSourceParameter().getImageSize()[1];
                int widthOnCamera = santecVideoSourceClient.getWidth();
                int heightOnCamera = santecVideoSourceClient.getHeight();
                long milliCompression = this.getVideoSourceParameter().getQuality();
                if (this.videoSourceClient == null || this.videoSourceClient.isShutdown() || width != widthOnCamera || heigth != heightOnCamera) {
                    this.discard();
                    return;
                }
                errorCode = santecVideoSourceClient.setImageParameter(frameRate, milliCompression);
                if (errorCode != 0) {
                    this.logger.warn("Setting stream parameter failed with error [" + errorCode + "]");
                }
            }
            catch (Exception ex) {
                this.logger.warn("Setting stream parameter failed with error [" + errorCode + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optionalSanyoHD1Discarding(SanyoCameraSrv sanyoCameraSrv, String videoMode) {
        try {
            int errorCode = 0;
            if (this.core != null && this.core.isShutdown()) {
                return;
            }
            Object object = this.SPC_SEMAPHORE;
            synchronized (object) {
                try {
                    SanyoJPEGVideoSourceClient_HD1 sanyoJPEGVideoSourceClient_HD1 = (SanyoJPEGVideoSourceClient_HD1)this.videoSourceClient;
                    long milliCompression = this.getVideoSourceParameter().getQuality();
                    int width = this.getVideoSourceParameter().getImageSize()[0];
                    int heigth = this.getVideoSourceParameter().getImageSize()[1];
                    long milliCompressionOnCamera = sanyoJPEGVideoSourceClient_HD1.getMilliCompression();
                    int widthOnCamera = sanyoJPEGVideoSourceClient_HD1.getWidth();
                    int heightOnCamera = sanyoJPEGVideoSourceClient_HD1.getHeight();
                    if (this.videoSourceClient == null || this.videoSourceClient.isShutdown() || milliCompression != milliCompressionOnCamera || width != widthOnCamera || heigth != heightOnCamera) {
                        this.discard();
                        return;
                    }
                    long frameRate = this.getHighestFramerate();
                    errorCode = sanyoJPEGVideoSourceClient_HD1.restartServerPush((int)frameRate);
                    if (errorCode != 0) {
                        this.logger.warn("Setting stream parameter failed with error [" + errorCode + "]");
                    }
                }
                catch (Exception ex) {
                    this.logger.warn("Setting stream parameter failed with error [" + errorCode + "]");
                }
            }
        }
        catch (Exception ex) {
            this.logger.warn("Setting stream parameter failed: " + ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optionalSanyoHD2Discarding(SanyoCameraSrv sanyoCameraSrv, String videoMode) {
        try {
            int errorCode = 0;
            if (this.core != null && this.core.isShutdown()) {
                return;
            }
            Object object = this.SPC_SEMAPHORE;
            synchronized (object) {
                try {
                    SanyoJPEGVideoSourceClient_HD2 sanyoJPEGVideoSourceClient_HD2 = (SanyoJPEGVideoSourceClient_HD2)this.videoSourceClient;
                    long milliCompression = this.getVideoSourceParameter().getQuality();
                    int width = this.getVideoSourceParameter().getImageSize()[0];
                    int heigth = this.getVideoSourceParameter().getImageSize()[1];
                    long milliCompressionOnCamera = sanyoJPEGVideoSourceClient_HD2.getMilliCompression();
                    int widthOnCamera = sanyoJPEGVideoSourceClient_HD2.getWidth();
                    int heightOnCamera = sanyoJPEGVideoSourceClient_HD2.getHeight();
                    long frameRate = this.getHighestFramerate();
                    if (this.videoSourceClient == null || this.videoSourceClient.isShutdown() || milliCompression != milliCompressionOnCamera || width != widthOnCamera || heigth != heightOnCamera) {
                        this.discard();
                        return;
                    }
                    errorCode = sanyoJPEGVideoSourceClient_HD2.restartServerPush((int)frameRate);
                    if (errorCode != 0) {
                        this.logger.warn("Setting stream parameter failed with error [" + errorCode + "]");
                    }
                }
                catch (Exception ex) {
                    this.logger.warn("Setting stream parameter failed with error [" + errorCode + "]");
                }
            }
        }
        catch (Exception ex) {
            this.logger.warn("Setting stream parameter failed: " + ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optionalSiemensDiscarding(SiemensCameraSrv siemensCameraSrv, String videoMode) {
        try {
            int errorCode = 0;
            if (this.core != null && this.core.isShutdown()) {
                return;
            }
            Object object = this.SPC_SEMAPHORE;
            synchronized (object) {
                try {
                    SiemensJPEGVideoSourceClient_1345 siemensJPEGVideoSourceClient = (SiemensJPEGVideoSourceClient_1345)this.videoSourceClient;
                    if (this.videoSourceClient == null || this.videoSourceClient.isShutdown() || this.getHighestFramerate() < 1000L) {
                        this.discard();
                        return;
                    }
                    long frameRate = this.getHighestFramerate();
                    errorCode = siemensJPEGVideoSourceClient.setImageParameter(frameRate);
                    if (errorCode != 0) {
                        this.logger.warn("Setting stream parameter failed with error [" + errorCode + "]");
                    }
                }
                catch (Exception ex) {
                    this.logger.warn("Setting stream parameter failed with error [" + errorCode + "]");
                }
            }
        }
        catch (Exception ex) {
            this.logger.warn("Setting stream parameter failed: " + ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optionalSonyDiscarding(SonyCameraSrv sonyCameraSrv, String videoMode) {
        if (this.core != null && this.core.isShutdown()) {
            return;
        }
        Object object = this.SPC_SEMAPHORE;
        synchronized (object) {
            try {
                int fps = (int)this.getHighestFramerate() / 1000;
                if (fps > 0) {
                    SonyJPEGVideoSourceClient sonyJPEGVideoSourceClient = (SonyJPEGVideoSourceClient)this.videoSourceClient;
                    long milliCompression = this.getVideoSourceParameter().getQuality();
                    int width = this.getVideoSourceParameter().getImageSize()[0];
                    int heigth = this.getVideoSourceParameter().getImageSize()[1];
                    long milliCompressionOnCamera = sonyJPEGVideoSourceClient.getMilliCompression();
                    long widthOnCamera = sonyJPEGVideoSourceClient.getWidth();
                    long heightOnCamera = sonyJPEGVideoSourceClient.getHeight();
                    if (this.videoSourceClient == null || this.videoSourceClient.isShutdown() || milliCompression != milliCompressionOnCamera || (long)width != widthOnCamera || (long)heigth != heightOnCamera) {
                        this.discard();
                        return;
                    }
                    int errorCode = sonyJPEGVideoSourceClient.setImageParameters(fps);
                    if (errorCode != 0) {
                        this.logger.warn("Setting stream parameter failed with error [" + errorCode + "]");
                    }
                } else {
                    this.discard();
                }
            }
            catch (Exception ex) {
                this.logger.error((Object)ex, (Throwable)ex);
                throw new RuntimeException(ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optionalSamsungDiscarding(SamsungCameraSrv samsungCameraSrv, String videoMode) {
        if (this.core != null && this.core.isShutdown()) {
            return;
        }
        Object object = this.SPC_SEMAPHORE;
        synchronized (object) {
            try {
                if (this.videoSourceClient instanceof SamsungJPEGVideoSourceClient) {
                    SamsungJPEGVideoSourceClient samsungJPEGVideoSourceClient = (SamsungJPEGVideoSourceClient)this.videoSourceClient;
                    long milliCompression = this.getVideoSourceParameter().getQuality();
                    int width = this.getVideoSourceParameter().getImageSize()[0];
                    int heigth = this.getVideoSourceParameter().getImageSize()[1];
                    long milliCompressionOnCamera = samsungJPEGVideoSourceClient.getMilliCompression();
                    if (this.videoSourceClient == null || this.videoSourceClient.isShutdown() || milliCompression != milliCompressionOnCamera) {
                        this.discard();
                        return;
                    }
                    int fps = (int)this.getHighestFramerate();
                    if (fps > 0) {
                        int errorCode = samsungJPEGVideoSourceClient.setImageParameters(fps, width, heigth);
                        if (errorCode != 0) {
                            this.logger.warn("Setting stream parameter failed with error [" + errorCode + "]");
                        }
                    } else {
                        this.discard();
                    }
                } else if (this.videoSourceClient instanceof SamsungVideoSourceClient) {
                    SamsungVideoSourceClient samsungVideoSourceClient = (SamsungVideoSourceClient)this.videoSourceClient;
                    long milliCompression = this.getVideoSourceParameter().getQuality();
                    long milliCompressionOnCamera = samsungVideoSourceClient.getMilliCompression();
                    int width = this.getVideoSourceParameter().getImageSize()[0];
                    int heigth = this.getVideoSourceParameter().getImageSize()[1];
                    int widthOnCamera = samsungVideoSourceClient.getWidth();
                    int heightOnCamera = samsungVideoSourceClient.getHeight();
                    if (this.videoSourceClient == null || this.videoSourceClient.isShutdown() || milliCompression != milliCompressionOnCamera || width != widthOnCamera || heigth != heightOnCamera) {
                        this.discard();
                        return;
                    }
                    int fps = (int)this.getHighestFramerate();
                    if (fps > 0) {
                        int errorCode = samsungVideoSourceClient.setImageParameters(fps);
                        if (errorCode != 0) {
                            this.logger.warn("Setting stream parameter failed with error [" + errorCode + "]");
                        }
                    } else {
                        this.discard();
                    }
                }
            }
            catch (Exception ex) {
                this.logger.error((Object)ex, (Throwable)ex);
                throw new RuntimeException(ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optionalLumeneraDiscarding(LumeneraCameraSrv lumeneraCameraSrv, String videoMode) {
        if (this.core != null && this.core.isShutdown()) {
            return;
        }
        Object object = this.SPC_SEMAPHORE;
        synchronized (object) {
            try {
                int[] imgageSize;
                Integer milliCompression;
                LumeneraJPEGVideoSourceClient lumeneraVideoSourceClient = (LumeneraJPEGVideoSourceClient)this.videoSourceClient;
                if (this.videoSourceClient == null || this.videoSourceClient.isShutdown()) {
                    this.discard();
                    return;
                }
                Long highestFramerate = this.getHighestFramerate();
                int errorCode = lumeneraVideoSourceClient.setImageParameter(highestFramerate, milliCompression = Integer.valueOf(lumeneraCameraSrv.getVideoSourceCnf().getQuality(videoMode)), imgageSize = lumeneraCameraSrv.getVideoSourceCnf().getImageSize(videoMode));
                if (errorCode != 0) {
                    this.logger.warn("Setting stream parameter of " + lumeneraCameraSrv + " failed with error [" + errorCode + "]");
                }
            }
            catch (Exception ex) {
                this.logger.error((Object)ex, (Throwable)ex);
                throw new RuntimeException(ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optionalAcutvistaDiscarding(AcutvistaCameraSrv acutvistaCameraSrv, String videoMode) {
        int errorCode = 0;
        if (this.core != null && this.core.isShutdown()) {
            return;
        }
        Object object = this.SPC_SEMAPHORE;
        synchronized (object) {
            try {
                AcutvistaJPEGVideoSourceClient acutvistaJPEGVideoSourceClient = (AcutvistaJPEGVideoSourceClient)this.videoSourceClient;
                long milliCompression = this.getVideoSourceParameter().getQuality();
                int width = this.getVideoSourceParameter().getImageSize()[0];
                int heigth = this.getVideoSourceParameter().getImageSize()[1];
                long milliCompressionOnCamera = acutvistaJPEGVideoSourceClient.getMilliCompression();
                int widthOnCamera = acutvistaJPEGVideoSourceClient.getWidth();
                int heightOnCamera = acutvistaJPEGVideoSourceClient.getHeight();
                if (this.videoSourceClient == null || this.videoSourceClient.isShutdown() || milliCompression != milliCompressionOnCamera || width != widthOnCamera || heigth != heightOnCamera) {
                    this.discard();
                    return;
                }
                errorCode = acutvistaJPEGVideoSourceClient.changeFramerate((int)this.getHighestFramerate());
                if (errorCode != 0) {
                    this.logger.warn("Setting new framerate failed with error [" + errorCode + "]");
                }
            }
            catch (Exception ex) {
                this.logger.warn("Setting stream parameter failed with error [" + errorCode + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optionalHikvisionDiscarding(HikvisionCameraSrv hikvisionCameraSrv, String videoMode) {
        if (this.core != null && this.core.isShutdown()) {
            return;
        }
        Object object = this.SPC_SEMAPHORE;
        synchronized (object) {
            try {
                HikvisionVideoSourceClientISAPI hikvisionVideoSourceClient = (HikvisionVideoSourceClientISAPI)this.videoSourceClient;
                long milliCompression = this.getVideoSourceParameter().getQuality();
                int width = this.getVideoSourceParameter().getImageSize()[0];
                int heigth = this.getVideoSourceParameter().getImageSize()[1];
                long milliCompressionOnCamera = hikvisionVideoSourceClient.getMilliCompression();
                int widthOnCamera = hikvisionVideoSourceClient.getWidth();
                int heightOnCamera = hikvisionVideoSourceClient.getHeight();
                if (this.videoSourceClient == null || this.videoSourceClient.isShutdown() || milliCompression != milliCompressionOnCamera || width != widthOnCamera || heigth != heightOnCamera) {
                    this.discard();
                    return;
                }
                int fps = (int)this.getHighestFramerate() / 1000;
                if (fps > 0) {
                    int errorCode = hikvisionVideoSourceClient.setCameraParameters(fps);
                    if (errorCode != 0) {
                        this.logger.warn("Setting stream parameter failed with error [" + errorCode + "]");
                    }
                } else {
                    this.discard();
                }
            }
            catch (Exception ex) {
                this.logger.error((Object)ex, (Throwable)ex);
                throw new RuntimeException(ex.getMessage());
            }
        }
    }

    @Override
    public void deliverFrame(ContentFrame contentFrame, boolean hasRTPTimestamp) {
        if (this.isShutdown()) {
            return;
        }
        if (this.core != null && this.core.isShutdown() && this.cameraSrv != null) {
            this.cameraSrv.shutdown();
            return;
        }
        VideoSourceClient videoSourceClient = this.getVideoSourceClient();
        Codec videoCodec = null;
        if (videoSourceClient != null) {
            videoCodec = videoSourceClient.videoCodec;
        }
        if (contentFrame != null) {
            super.addToVideoBuffer(videoCodec, (ContentFrame)contentFrame.clone());
        }
        if (contentFrame != null && (contentFrame.getMediatype() == 0 || contentFrame.getMediatype() == 33 || contentFrame.getMediatype() == 35) && Basic.byteArrayToInt4((byte[])contentFrame.getData(), (int)0, (int)4) == 0) {
            this.logger.warn("Suspicious frame header with zero bytes for " + contentFrame);
        }
        try {
            LiveReader[] liveReaders;
            long ts = System.currentTimeMillis();
            if (this.multicastGateway != null) {
                liveReaders = this.cameraSrv.getLiveReaders(this);
                if (liveReaders.length > 0) {
                    this.multicastGateway.sendContentFrame(contentFrame);
                }
            } else {
                for (LiveReader liveReader : liveReaders = this.cameraSrv.getLiveReaders(this)) {
                    if (liveReader.isShutdown()) {
                        this.cameraSrv.removeLiveReader(liveReader);
                        continue;
                    }
                    try {
                        liveReader.deliverFrameToLive(contentFrame);
                    }
                    catch (Throwable ex) {
                        this.logger.warn("Trouble with LiveReader " + (Object)((Object)liveReader), ex);
                    }
                }
            }
            long duration = System.currentTimeMillis() - ts;
            if (duration > 1000L) {
                this.logger.warn("Latency to deliver Frame to LiveReaders: [" + Basic.longToFormattedString((long)duration) + " ms] for " + this.getLiveCameraSrv().getDevice());
            }
            ts = System.currentTimeMillis();
            if (this.cameraSrv.getRecordingHandler().getFramerate() > 0L) {
                if (contentFrame != null && !contentFrame.isFullVideoFrame() && this.cameraSrv.getLiveReaders(this).length > 0) {
                    this.cameraSrv.getRecordingHandler().getDatabaseWriter().deliverFrameToArchive((ContentFrame)contentFrame.clone(), hasRTPTimestamp);
                } else {
                    this.cameraSrv.getRecordingHandler().getDatabaseWriter().deliverFrameToArchive(contentFrame, hasRTPTimestamp);
                }
            }
            if ((duration = System.currentTimeMillis() - ts) > 1000L) {
                this.logger.warn("Latency to deliver Frame to MDB: [" + Basic.longToFormattedString((long)duration) + " ms] for " + this.getLiveCameraSrv().getDevice());
            }
        }
        catch (Exception ex) {
            this.logger.error("Problems while delivering frames to LiveReaders/MDB for " + this, (Throwable)ex);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void checkFramerate() {
        block94: {
            if (this.isShutdown() || this.core != null && this.core.isShutdown()) {
                return;
            }
            if (this.checkingFramerateActive) {
                return;
            }
            this.checkingFramerateActive = true;
            try {
                highestFramerate = this.getHighestFramerate();
                if (this.actualFramerate != highestFramerate) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.info("Different framerates wanted: ActualFramerate=[" + this.actualFramerate / 1000L + "." + this.actualFramerate % 1000L + "], HighestFramerate=[" + highestFramerate / 1000L + "." + highestFramerate % 1000L + "]), CameraService=" + this.cameraSrv);
                    }
                    this.actualFramerate = highestFramerate;
                    if (this.videoSourceClient == null || this.videoSourceClient.isShutdown()) {
                        this.discard();
                    } else if (this.cameraSrv.getEntityType() == 211325L || this.cameraSrv.getEntityType() == 211324L || this.cameraSrv.getEntityType() == 211323L) {
                        if (this.videoSourceClient instanceof IQinVisionJPEGSingleImageVideoSourceClient) {
                            ((IQinVisionJPEGSingleImageVideoSourceClient)this.videoSourceClient).changeFramerate(this.getHighestFramerate());
                        } else {
                            this.discard();
                        }
                    } else if (this.cameraSrv.getEntityType() < 219500L || this.cameraSrv.getEntityType() > 219599L) {
                        if (this.cameraSrv.getEntityType() >= 214500L && this.cameraSrv.getEntityType() <= 214599L) {
                            if (this.cameraSrv.getEntityType() == 214500L || this.cameraSrv.getEntityType() >= 214502L || this.cameraSrv.getEntityType() >= 214503L) {
                                try {
                                    errorCode = ((AmericanDynamicsVideoSourceClient)this.videoSourceClient).changeFramerate(this.getHighestFramerate());
                                    if (errorCode == 0) ** GOTO lbl203
                                    this.logger.warn("Setting stream parameter of " + this.cameraSrv + " failed with error [" + errorCode + "]");
                                }
                                catch (Throwable ex) {
                                    this.logger.error((Object)ex, ex);
                                    throw new RuntimeException(ex.getMessage());
                                }
                            } else if (this.cameraSrv.getEntityType() >= 214501L) {
                                try {
                                    errorCode = ((AmericanDynamicsVideoSourceClient400)this.videoSourceClient).changeFramerate(this.getHighestFramerate());
                                    if (errorCode == 0) ** GOTO lbl203
                                    this.logger.warn("Setting stream parameter of " + this.cameraSrv + " failed with error [" + errorCode + "]");
                                }
                                catch (Throwable ex) {
                                    this.logger.error((Object)ex, ex);
                                    throw new RuntimeException(ex.getMessage());
                                }
                            }
                        } else if (!(this.cameraSrv.getEntityType() >= 2142L && this.cameraSrv.getEntityType() <= 2241L || this.cameraSrv.getEntityType() >= 214100L && this.cameraSrv.getEntityType() <= 214199L && this.cameraSrv.getEntityType() != 214107L && this.cameraSrv.getEntityType() != 214150L && this.cameraSrv.getEntityType() != 214151L)) {
                            if (this.cameraSrv.getEntityType() >= 214000L && this.cameraSrv.getEntityType() <= 214099L) {
                                try {
                                    errorCode = ((IdsVideoSourceClient)this.videoSourceClient).changeFramerate(this.getHighestFramerate());
                                    if (errorCode == 0) ** GOTO lbl203
                                    this.logger.warn("Setting stream parameter of " + this.cameraSrv + " failed with error [" + errorCode + "]");
                                }
                                catch (Throwable ex) {
                                    this.logger.error((Object)ex, ex);
                                    throw new RuntimeException(ex.getMessage());
                                }
                            } else if (this.cameraSrv.getEntityType() == 219600L || this.cameraSrv.getEntityType() == 219601L || this.cameraSrv.getEntityType() == 219602L || this.cameraSrv.getEntityType() == 212207L || this.cameraSrv.getEntityType() == 215501L || this.cameraSrv.getEntityType() == 214203L) {
                                if (this.actualFramerate == 0L) {
                                    this.discard();
                                }
                            } else if (!(this.cameraSrv.getEntityType() >= 219700L && this.cameraSrv.getEntityType() <= 219799L || !this.cameraSrv.isMPEG() && this.cameraSrv.getEntityType() >= 213700L && this.cameraSrv.getEntityType() <= 213799L || this.cameraSrv.getEntityType() == 216801L)) {
                                if (this.cameraSrv.getDevice().getDeviceType() >= 202201L && this.cameraSrv.getDevice().getDeviceType() <= 202300L && this.cameraSrv.getDevice().getDeviceType() != 202203L) {
                                    try {
                                        errorCode = ((SiemensVideoSourceClient)this.videoSourceClient).setFramerate((int)this.getHighestFramerate());
                                        if (errorCode == 0) ** GOTO lbl203
                                        this.logger.warn("Setting stream parameter of " + this.cameraSrv + " failed with error [" + errorCode + "]");
                                        this.discard();
                                    }
                                    catch (Throwable ex) {
                                        this.logger.error((Object)ex, ex);
                                        throw new RuntimeException(ex.getMessage());
                                    }
                                } else if (!this.cameraSrv.isMPEG() && this.cameraSrv.getEntityType() == 210435L && this.cameraSrv.getDevice().getNumberOfVideoSources() > 1) {
                                    try {
                                        errorCode = ((HikvisionVideoSourceClientCGI)this.videoSourceClient).setCameraParameters(this.getHighestFramerate());
                                        if (errorCode == 0) ** GOTO lbl203
                                        this.logger.warn("Setting stream parameter of " + this.cameraSrv + " failed with error [" + errorCode + "]");
                                    }
                                    catch (Throwable ex) {
                                        this.logger.error((Object)ex, ex);
                                        throw new RuntimeException(ex.getMessage());
                                    }
                                } else if (!this.cameraSrv.isMPEG() && this.cameraSrv.getEntityType() >= 210400L && this.cameraSrv.getEntityType() <= 210499L || this.cameraSrv.getEntityType() >= 214400L && this.cameraSrv.getEntityType() <= 214499L) {
                                    try {
                                        errorCode = ((HikvisionVideoSourceClientISAPI)this.videoSourceClient).setCameraParameters(this.getHighestFramerate());
                                        if (errorCode == 0) ** GOTO lbl203
                                        this.logger.warn("Setting stream parameter of " + this.cameraSrv + " failed with error [" + errorCode + "]");
                                    }
                                    catch (Throwable ex) {
                                        this.logger.error((Object)ex, ex);
                                        throw new RuntimeException(ex.getMessage());
                                    }
                                } else if (!this.cameraSrv.isMPEG() && this.cameraSrv.getEntityType() >= 210801L && this.cameraSrv.getEntityType() <= 210900L) {
                                    try {
                                        errorCode = ((PelcoJPEGVideoSourceClient)this.videoSourceClient).setImageParameter(this.getHighestFramerate());
                                        if (errorCode == 0) ** GOTO lbl203
                                        this.logger.warn("Setting stream parameter of " + this.cameraSrv + " failed with error [" + errorCode + "]");
                                    }
                                    catch (Throwable ex) {
                                        this.logger.error((Object)ex, ex);
                                        throw new RuntimeException(ex.getMessage());
                                    }
                                } else if (this.cameraSrv.getEntityType() >= 211400L && this.cameraSrv.getEntityType() <= 211499L) {
                                    try {
                                        errorCode = ((LumeneraJPEGVideoSourceClient)this.videoSourceClient).setImageParameter(highestFramerate, null, null);
                                        if (errorCode == 0) ** GOTO lbl203
                                        this.logger.warn("Setting stream parameter of " + this.cameraSrv + " failed with error [" + errorCode + "]");
                                    }
                                    catch (Throwable ex) {
                                        this.logger.error((Object)ex, ex);
                                        throw new RuntimeException(ex.getMessage());
                                    }
                                } else if (this.cameraSrv.getEntityType() >= 210200L && this.cameraSrv.getEntityType() <= 210299L && this.cameraSrv.getEntityType() != 210210L && this.cameraSrv.getEntityType() != 210208L && this.cameraSrv.getEntityType() != 210207L) {
                                    if (highestFramerate > 0L) {
                                        try {
                                            errorCode = ((MobotixVideoSourceClient)this.videoSourceClient).setImageParameter(highestFramerate, null, null);
                                            if (errorCode == 0) ** GOTO lbl203
                                            this.logger.warn("Setting stream parameter of " + this.cameraSrv + " failed with error [" + errorCode + "]");
                                        }
                                        catch (Throwable ex) {
                                            this.logger.error((Object)ex, ex);
                                            throw new RuntimeException(ex.getMessage());
                                        }
                                    } else {
                                        this.discard();
                                    }
                                } else if (this.cameraSrv.getDevice().getDeviceType() >= 202500L && this.cameraSrv.getDevice().getDeviceType() <= 202599L || this.cameraSrv.getDevice().getDeviceType() >= 203400L && this.cameraSrv.getDevice().getDeviceType() <= 203499L) {
                                    try {
                                        errorCode = ((SantecVideoSourceClient)this.videoSourceClient).setImageParameter(highestFramerate, this.getVideoSourceParameter().getQuality());
                                        if (errorCode == 0) ** GOTO lbl203
                                        this.logger.warn("Setting stream parameter of " + this.cameraSrv + " failed with error [" + errorCode + "]");
                                    }
                                    catch (Throwable ex) {
                                        this.logger.error((Object)ex, ex);
                                        throw new RuntimeException(ex.getMessage());
                                    }
                                } else if (!(this.cameraSrv.isMPEG() || highestFramerate < 1000L || this.cameraSrv.getEntityType() != 211902L && this.cameraSrv.getEntityType() != 211911L && this.cameraSrv.getEntityType() != 211903L && this.cameraSrv.getEntityType() != 211912L && this.cameraSrv.getEntityType() != 211905L && this.cameraSrv.getEntityType() != 211914L && this.cameraSrv.getEntityType() != 211906L && this.cameraSrv.getEntityType() != 211915L)) {
                                    try {
                                        framerate = (int)highestFramerate;
                                        errorCode = ((SanyoJPEGVideoSourceClient_HD1)this.videoSourceClient).restartServerPush(framerate);
                                        if (errorCode == 0) ** GOTO lbl203
                                        this.logger.warn("Setting stream parameter of " + this.cameraSrv + " failed with error [" + errorCode + "]");
                                    }
                                    catch (Throwable ex) {
                                        this.logger.error((Object)ex, ex);
                                        throw new RuntimeException(ex.getMessage());
                                    }
                                } else if (!(this.cameraSrv.isMPEG() || highestFramerate < 1000L || this.cameraSrv.getEntityType() != 211904L && this.cameraSrv.getEntityType() != 211913L && this.cameraSrv.getEntityType() != 211907L && this.cameraSrv.getEntityType() != 211916L && this.cameraSrv.getEntityType() != 211908L && this.cameraSrv.getEntityType() != 211917L && this.cameraSrv.getEntityType() != 211909L && this.cameraSrv.getEntityType() != 211918L && this.cameraSrv.getEntityType() != 211910L && this.cameraSrv.getEntityType() != 211919L)) {
                                    try {
                                        framerate = (int)highestFramerate;
                                        errorCode = ((SanyoJPEGVideoSourceClient_HD2)this.videoSourceClient).restartServerPush(framerate);
                                        if (errorCode == 0) ** GOTO lbl203
                                        this.logger.warn("Setting stream parameter of " + this.cameraSrv + " failed with error [" + errorCode + "]");
                                    }
                                    catch (Throwable ex) {
                                        this.logger.error((Object)ex, ex);
                                        throw new RuntimeException(ex.getMessage());
                                    }
                                } else if (!this.cameraSrv.isMPEG() && this.cameraSrv.getEntityType() == 212200L) {
                                    try {
                                        framerate = highestFramerate;
                                        errorCode = ((SiemensJPEGVideoSourceClient_1345)this.videoSourceClient).setImageParameter(framerate);
                                        if (errorCode == 0) ** GOTO lbl203
                                        this.logger.warn("Setting stream parameter of " + this.cameraSrv + " failed with error [" + errorCode + "]");
                                    }
                                    catch (Throwable ex) {
                                        this.logger.error((Object)ex, ex);
                                        throw new RuntimeException(ex.getMessage());
                                    }
                                } else if (!(this.cameraSrv.isMPEG() || this.cameraSrv.getEntityType() != 210530L && this.cameraSrv.getEntityType() != 210526L && this.cameraSrv.getEntityType() != 210532L && this.cameraSrv.getEntityType() != 210533L && this.cameraSrv.getEntityType() != 210527L && this.cameraSrv.getEntityType() != 210528L && this.cameraSrv.getEntityType() != 210529L && this.cameraSrv.getEntityType() != 210534L && this.cameraSrv.getEntityType() != 210530L && this.cameraSrv.getEntityType() != 210531L && this.cameraSrv.getEntityType() != 210537L && this.cameraSrv.getEntityType() != 210538L && this.cameraSrv.getEntityType() != 210539L && this.cameraSrv.getEntityType() != 210540L && this.cameraSrv.getEntityType() != 210541L && this.cameraSrv.getEntityType() != 210536L && this.cameraSrv.getDevice().getDeviceType() != 200630L && this.cameraSrv.getDevice().getDeviceType() != 200631L && this.cameraSrv.getDevice().getDeviceType() != 200632L && this.cameraSrv.getDevice().getDeviceType() != 200633L)) {
                                    try {
                                        framerate = (int)highestFramerate / 1000;
                                        if (framerate > 0) {
                                            errorCode = ((SonyJPEGVideoSourceClient)this.videoSourceClient).setImageParameters(framerate);
                                            if (errorCode == 0) ** GOTO lbl203
                                            this.logger.warn("Setting framerate of " + this.cameraSrv + " failed with error [" + errorCode + "]");
                                        }
                                        this.discard();
                                    }
                                    catch (Throwable ex) {
                                        this.logger.error((Object)ex, ex);
                                        throw new RuntimeException(ex.getMessage());
                                    }
                                } else if (!this.cameraSrv.isMPEG() && (this.cameraSrv.getEntityType() >= 211800L && this.cameraSrv.getEntityType() < 211900L || this.cameraSrv.getDevice().getDeviceType() >= 201800L && this.cameraSrv.getDevice().getDeviceType() < 201900L)) {
                                    try {
                                        framerate = (int)highestFramerate;
                                        if (framerate > 0) {
                                            errorCode = ((SamsungJPEGVideoSourceClient)this.videoSourceClient).setImageParameters(framerate);
                                            if (errorCode == 0) ** GOTO lbl203
                                            this.logger.warn("Setting framerate of " + this.cameraSrv + " failed with error [" + errorCode + "]");
                                        }
                                        this.discard();
                                    }
                                    catch (ClassCastException ex) {
                                        this.logger.info("Samsung camera " + this + " does not support setting framerate on the fly. Will shut down and restart ");
                                        this.discard();
                                    }
                                    catch (Throwable ex) {
                                        this.logger.error((Object)ex, ex);
                                        throw new RuntimeException(ex.getMessage());
                                    }
                                } else if (!this.cameraSrv.isMPEG() && this.cameraSrv.getDevice().getDeviceType() == 202800L) {
                                    try {
                                        errorCode = ((AcutvistaJPEGVideoSourceClient)this.videoSourceClient).changeFramerate((int)highestFramerate);
                                        if (errorCode == 0) ** GOTO lbl203
                                        this.logger.warn("Setting stream parameter of " + this.cameraSrv + " failed with error [" + errorCode + "]");
                                    }
                                    catch (Throwable ex) {
                                        this.logger.error((Object)ex, ex);
                                        throw new RuntimeException(ex.getMessage());
                                    }
                                } else if (!(this.cameraSrv.isMPEG() || this.cameraSrv.getDevice().getDeviceType() != 203200L && this.cameraSrv.getDevice().getDeviceType() != 203201L && this.cameraSrv.getDevice().getDeviceType() != 203202L && this.cameraSrv.getDevice().getDeviceType() != 203206L)) {
                                    try {
                                        errorCode = ((SiquraJPEGVideoSourceClient)this.videoSourceClient).setFramerate((int)highestFramerate);
                                        if (errorCode == 0) ** GOTO lbl203
                                        this.logger.warn("Setting stream parameter of " + this.cameraSrv + " failed with error [" + errorCode + "]");
                                    }
                                    catch (Throwable ex) {
                                        this.logger.error((Object)ex, ex);
                                        throw new RuntimeException(ex.getMessage());
                                    }
                                } else {
                                    this.discard();
                                }
                            }
                        }
                    }
                }
lbl203:
                // 52 sources

                if (this.actualFramerate <= 0L || this.videoSourceClient != null && !this.videoSourceClient.isShutdown()) break block94;
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException var4_43) {
                    // empty catch block
                }
                this.logger.info("Recover broken camera connection of " + this + " ...");
                this.discard();
            }
            catch (Throwable ex) {
                this.logger.warn(this + ": " + ex.getMessage());
            }
        }
        this.checkingFramerateActive = false;
    }

    @Override
    public long getHighestFramerate() {
        try {
            LiveReader[] liveReaders;
            long framerateRecordingHandler;
            if (this.cameraSrv.isEdgeStorage() && this.videoSourceClient instanceof PlaybackVideoSourceClient) {
                return 1L;
            }
            long highestFramerate = framerateRecordingHandler = this.cameraSrv.getRecordingHandler().getFramerate();
            for (LiveReader liveReader : liveReaders = this.cameraSrv.getLiveReaders(this)) {
                if (!super.isMPEG() && this.cameraSrv.limitJpegFramerateToVideoProfile()) break;
                if (liveReader.isShutdown() || liveReader.getJpegFramerate() <= highestFramerate) continue;
                highestFramerate = (int)liveReader.getJpegFramerate();
            }
            if (super.isMPEG()) {
                if (highestFramerate > 0L || this.getVideoSourceParameter().isFetchPermanently()) {
                    if (framerateRecordingHandler > 0L && framerateRecordingHandler != this.getVideoSourceParameter().getFramerate()) {
                        return framerateRecordingHandler;
                    }
                    return this.getVideoSourceParameter().getFramerate();
                }
                return 0L;
            }
            if (highestFramerate > 0L) {
                return highestFramerate;
            }
            if (this.getVideoSourceParameter().isFetchPermanently()) {
                return this.getVideoSourceParameter().getFramerate();
            }
            return 0L;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            throw new RuntimeException(ex.getMessage());
        }
    }

    @Override
    public boolean isStandardVideoProfile() {
        return false;
    }

    @Override
    public String getVideoProfileName() {
        return "Basic";
    }

    public VideoSourceParameter getVideoSourceParameter(String videoMode) {
        if (videoMode.equalsIgnoreCase("standard")) {
            return this.standardVideoSourceParameter;
        }
        if (videoMode.equalsIgnoreCase("alarm")) {
            return this.alarmVideoSourceParameter;
        }
        throw new RuntimeException("Video mode [" + videoMode + "] invalid");
    }

    @Override
    public VideoSourceParameter getVideoSourceParameter() {
        String actualVideoMode = this.cameraSrv.getVideoMode();
        if (actualVideoMode.equalsIgnoreCase("standard")) {
            return this.standardVideoSourceParameter;
        }
        if (actualVideoMode.equalsIgnoreCase("alarm")) {
            return this.alarmVideoSourceParameter;
        }
        throw new RuntimeException("Actual video mode [" + actualVideoMode + "] invalid");
    }

    @Override
    public void notify(ContentFrame receivedContentFrame) {
        try {
            if (this.cameraSrv.getAudioOutServer() != null) {
                this.cameraSrv.getAudioOutServer().offer(MediaFrame.deserialize((byte[])receivedContentFrame.getData()));
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Error while deserializing ContentFrame: " + ex.getMessage());
        }
    }

    @Override
    public int shutdown() {
        super.setRunFinished(CLASS_NAME, false);
        this.shutdownPlaybackVideoSourceClients();
        return super.shutdown();
    }

    private void shutdownPlaybackVideoSourceClients() {
        if (this.gapFillingPlaybackVideoSourceClient != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.info("Discarding " + this.gapFillingPlaybackVideoSourceClient + " for " + this);
            }
            this.gapFillingPlaybackVideoSourceClient.shutdown();
            this.gapFillingPlaybackVideoSourceClient = null;
        }
        if (this.fullImportPlaybackVideoSourceClients != null && this.fullImportPlaybackVideoSourceClients.size() > 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.info("Discarding " + this.fullImportPlaybackVideoSourceClients.size() + " PlaybackVideoSourceClients for " + this);
            }
            for (PlaybackVideoSourceClient playbackVideoSourceClient : this.fullImportPlaybackVideoSourceClients) {
                if (playbackVideoSourceClient == null) continue;
                playbackVideoSourceClient.shutdown();
                Object var2_2 = null;
            }
        }
    }

    public final PlaybackVideoSourceClient providePlaybackVideoSourceClient(boolean manualTrigger) {
        try {
            VideoSourceParameter videoSourceParameter = this.getVideoSourceParameter();
            EdgeStorageParameter tempEdgeStorageParameter = videoSourceParameter.getEdgeStorageParameter();
            if (tempEdgeStorageParameter.getEdgeStorageMode() == EdgeStorageMode.GAP_FILLING) {
                if (this.gapFillingPlaybackVideoSourceClient != null && !this.gapFillingPlaybackVideoSourceClient.isShutdown()) {
                    return this.gapFillingPlaybackVideoSourceClient;
                }
                try {
                    boolean notInFailoverMode;
                    this.gapFillingPlaybackVideoSourceClient = null;
                    boolean bl = notInFailoverMode = this.core.getDmCnfMgr().getEntityID() == Long.parseLong(this.getLiveCameraSrv().getDevice().getDeviceCnf().getREID());
                    if (tempEdgeStorageParameter.isEnabled() && notInFailoverMode && this.getVideoSourceParameter().isRecordingEnabled("Standard")) {
                        this.gapFillingPlaybackVideoSourceClient = PlaybackVideoSourceClientFactory.createPlaybackVideoSourceClient(this.getLiveCameraSrv().getEntityType(), tempEdgeStorageParameter, this.core, this.getLiveCameraSrv(), this, manualTrigger);
                    }
                }
                catch (Throwable throwable) {
                    this.logger.error("Exception while creating or initalizing GapFilling PlaybackVideoSource client for " + this, throwable);
                }
                return this.gapFillingPlaybackVideoSourceClient;
            }
            if (tempEdgeStorageParameter.getEdgeStorageMode() == EdgeStorageMode.IMPORT) {
                try {
                    PlaybackVideoSourceClient playbackVideoSourceClient = PlaybackVideoSourceClientFactory.createPlaybackVideoSourceClient(this.getLiveCameraSrv().getEntityType(), tempEdgeStorageParameter, this.core, this.getLiveCameraSrv(), this, manualTrigger);
                    this.fullImportPlaybackVideoSourceClients.add(playbackVideoSourceClient);
                    return playbackVideoSourceClient;
                }
                catch (Throwable throwable) {
                    this.logger.error("Exception while creating or initalizing FullImport PlaybackVideoSource client for " + this, throwable);
                }
            }
        }
        catch (ConfigurationException configurationException) {
            this.logger.error("Exception while reading EdgeStorage configuration for " + this, (Throwable)configurationException);
        }
        return null;
    }

    @Override
    public final void run() {
        super.setRunFinished("de.seetec.v5.re.cm.device.shared.PlaybackVideoSourceClient", false);
        long oneMinute = TimeUnit.SECONDS.toMillis(60L);
        long currentTime = System.currentTimeMillis();
        while (!this.isShutdown()) {
            if (System.currentTimeMillis() > currentTime + oneMinute) {
                currentTime = System.currentTimeMillis();
                Calendar calendar = Calendar.getInstance();
                for (SynchronizationTime synchronizationTime : this.edgeStorageParameter.getSynchronizationTimes()) {
                    if (!this.isHoliday(calendar, synchronizationTime) && Day.convertJavaValue((int)calendar.get(7)) != synchronizationTime.getDay().DAYOFWEEK() || PlaybackVideoSourceClient.calculateTimeMillis(synchronizationTime.getTimeStamp()) / oneMinute != calendar.getTimeInMillis() / oneMinute) continue;
                    this.logger.info("Edge storage syncronization time matched for " + this);
                    this.core.getEdgeStorageHandler().addPlaybackVideoSourceClient(this.providePlaybackVideoSourceClient(false));
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        super.setRunFinished("de.seetec.v5.re.cm.device.shared.PlaybackVideoSourceClient", true);
        this.shutdown();
    }

    private boolean isHoliday(Calendar calendar, SynchronizationTime synchronizationTime) {
        if (synchronizationTime.getDay() == Day.HOLIDAY) {
            return synchronizationTime.getCalendarIds().stream().anyMatch(selectedCalendar -> this.core.getWorkCenterCalendarRepository().get(selectedCalendar.longValue()).isHoliday(calendar.getTimeInMillis()));
        }
        return false;
    }
}

