/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.videoprofile;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.videoprofile.MulticastGateway;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionVideoSourceClientISAPI;
import de.seetec.v5.re.cm.device.video.iqinvision.jpeg.IQinVisionJPEGSingleImageVideoSourceClient;
import de.seetec.v5.re.cm.device.video.lumenera.jpeg.LumeneraJPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.mobotix.MobotixVideoSourceClient;
import de.seetec.v5.re.cm.device.video.samsung.SamsungVideoSourceClient;
import de.seetec.v5.re.cm.device.video.samsung.jpeg.SamsungJPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.santec.SantecVideoSourceClient;
import de.seetec.v5.re.cm.device.video.sanyo.jpeg.SanyoJPEGVideoSourceClient_HD1;
import de.seetec.v5.re.cm.device.video.sanyo.jpeg.SanyoJPEGVideoSourceClient_HD2;
import de.seetec.v5.re.cm.device.video.siemens.SiemensVideoSourceClient;
import de.seetec.v5.re.cm.device.video.siqura.jpeg.SiquraJPEGVideoSourceClient;
import de.seetec.v5.re.cm.shared.communication.LiveReader;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.re.shared.VideoSourceParameter;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.ConfigurationException;

public class AdditionalVideoProfileHandler
extends VideoProfileHandler {
    private long actualFramerate = 0L;
    private boolean checkingFramerateActive = false;
    private VideoSourceParameter videoSourceParameter = null;
    private boolean additionalRecording = false;

    public int init(Core core, LiveCameraSrv cameraSrv, VideoSourceParameter videoSourceParameter, int dynamicVideoProfileID) {
        block8: {
            int errorCode = super.init(core, cameraSrv, dynamicVideoProfileID);
            if (errorCode != 0) {
                this.logger.error("Initializing " + this + " failed with error [" + errorCode + "]");
                return errorCode;
            }
            this.videoSourceParameter = videoSourceParameter;
            if (this.videoSourceParameter == null) {
                return -21601;
            }
            this.logger.info(this + " initialized");
            try {
                String[] multicastConfiguration = this.getVideoSourceParameter().getMulticastConfiguration();
                if (multicastConfiguration == null) break block8;
                String address = multicastConfiguration[0];
                int port = Integer.parseInt(multicastConfiguration[1]);
                int ttl = 1;
                try {
                    ttl = Integer.parseInt(multicastConfiguration[2]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.multicastGateway = new MulticastGateway(core, this.cameraSrv.getEntityID(), address, port, ttl);
                    this.logger.info("MulticastGateway created: " + this.multicastGateway + " / " + this.cameraSrv);
                }
                catch (IllegalArgumentException e) {
                    throw new Exception("Establishing Multicast gateway at [" + multicastConfiguration[0] + ":" + multicastConfiguration[1] + "] failed: " + e.getMessage());
                }
            }
            catch (Throwable ex) {
                this.logger.error((Object)ex, ex);
                return -21600;
            }
        }
        return 0;
    }

    @Override
    public void deliverFrame(ContentFrame contentFrame, boolean hasRTPTimestamp) {
        if (this.isShutdown()) {
            return;
        }
        if (this.core != null && this.core.isShutdown() && this.cameraSrv != null) {
            this.cameraSrv.shutdown();
            return;
        }
        VideoSourceClient videoSourceClient = this.getVideoSourceClient();
        Codec videoCodec = null;
        if (videoSourceClient != null) {
            videoCodec = videoSourceClient.videoCodec;
        }
        if (contentFrame != null) {
            super.addToVideoBuffer(videoCodec, (ContentFrame)contentFrame.clone());
        }
        if (contentFrame != null && (contentFrame.getMediatype() == 0 || contentFrame.getMediatype() == 33 || contentFrame.getMediatype() == 35) && Basic.byteArrayToInt4((byte[])contentFrame.getData(), (int)0, (int)4) == 0) {
            this.logger.warn("Suspicious header with zero bytes for " + contentFrame);
        }
        try {
            LiveReader[] liveReaders;
            long ts = System.currentTimeMillis();
            if (this.multicastGateway != null) {
                liveReaders = this.cameraSrv.getLiveReaders(this);
                if (liveReaders.length > 0) {
                    this.multicastGateway.sendContentFrame(contentFrame);
                }
            } else {
                for (LiveReader liveReaders1 : liveReaders = this.cameraSrv.getLiveReaders(this)) {
                    if (liveReaders1.isShutdown()) {
                        this.cameraSrv.removeLiveReader(liveReaders1);
                        continue;
                    }
                    try {
                        liveReaders1.deliverFrameToLive(contentFrame);
                    }
                    catch (Throwable ex) {
                        this.logger.warn("Trouble with LiveReader " + (Object)((Object)liveReaders1), ex);
                    }
                }
            }
            long duration = System.currentTimeMillis() - ts;
            if (duration > 1000L) {
                this.logger.fatal("Latency=[" + Basic.longToFormattedString((long)duration) + " ms]");
            }
            if (this.getAdditionalRecording()) {
                if (contentFrame != null && !contentFrame.isFullVideoFrame() && this.cameraSrv.getLiveReaders(this).length > 0) {
                    this.cameraSrv.getAdditionalRecordingHandler().getDatabaseWriter().deliverFrameToArchive((ContentFrame)contentFrame.clone(), hasRTPTimestamp);
                } else {
                    this.cameraSrv.getAdditionalRecordingHandler().getDatabaseWriter().deliverFrameToArchive(contentFrame, hasRTPTimestamp);
                }
            }
        }
        catch (Exception ex) {
            this.logger.error("Problems while delivering frames to LiveReaders for " + this, (Throwable)ex);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void checkFramerate() {
        block55: {
            if (this.isShutdown() || this.core != null && this.core.isShutdown()) {
                return;
            }
            if (this.checkingFramerateActive) {
                return;
            }
            this.checkingFramerateActive = true;
            try {
                highestFramerate = this.getHighestFramerate();
                if (this.actualFramerate != highestFramerate) {
                    this.logger.info("Different framerates wanted: ActualFramerate=[" + this.actualFramerate / 1000L + "." + this.actualFramerate % 1000L + "], HighestFramerate=[" + highestFramerate / 1000L + "." + highestFramerate % 1000L + "]), CameraService=" + this.cameraSrv);
                    this.actualFramerate = highestFramerate;
                    if (this.videoSourceClient == null || this.videoSourceClient.isShutdown()) {
                        this.discard();
                    } else if (this.cameraSrv.getEntityType() == 211325L || this.cameraSrv.getEntityType() == 211324L || this.cameraSrv.getEntityType() == 211323L) {
                        if (this.videoSourceClient instanceof IQinVisionJPEGSingleImageVideoSourceClient) {
                            ((IQinVisionJPEGSingleImageVideoSourceClient)this.videoSourceClient).changeFramerate(this.getHighestFramerate());
                        } else {
                            this.discard();
                        }
                    } else if (this.cameraSrv.getEntityType() >= 211400L && this.cameraSrv.getEntityType() <= 211499L) {
                        try {
                            errorCode = ((LumeneraJPEGVideoSourceClient)this.videoSourceClient).setImageParameter(highestFramerate, null, null);
                            if (errorCode == 0) ** GOTO lbl121
                            this.logger.warn("Setting stream parameter of " + this.cameraSrv + " failed with error [" + errorCode + "]");
                        }
                        catch (Throwable ex) {
                            this.logger.error((Object)ex, ex);
                            throw new RuntimeException(ex.getMessage());
                        }
                    } else if (this.cameraSrv.getEntityType() >= 210200L && this.cameraSrv.getEntityType() <= 210299L) {
                        if (highestFramerate > 0L) {
                            try {
                                errorCode = ((MobotixVideoSourceClient)this.videoSourceClient).setImageParameter(highestFramerate, null, null);
                                if (errorCode == 0) ** GOTO lbl121
                                this.logger.warn("Setting stream parameter of " + this.cameraSrv + " failed with error [" + errorCode + "] :-(");
                            }
                            catch (Throwable ex) {
                                this.logger.error((Object)ex, ex);
                                throw new RuntimeException(ex.getMessage());
                            }
                        } else {
                            this.discard();
                        }
                    } else if (this.videoSourceParameter.getMediaCodec() == Codec.MJPEG && (this.cameraSrv.getEntityType() >= 211800L && this.cameraSrv.getEntityType() < 211900L || this.cameraSrv.getDevice().getDeviceType() >= 201800L && this.cameraSrv.getDevice().getDeviceType() < 201900L)) {
                        try {
                            framerate = (int)highestFramerate;
                            if (framerate > 0) {
                                if (this.videoSourceClient instanceof SamsungJPEGVideoSourceClient) {
                                    errorCode = ((SamsungJPEGVideoSourceClient)this.videoSourceClient).setImageParameters(framerate);
                                    if (errorCode == 0) ** GOTO lbl121
                                    this.logger.warn("Setting framerate of " + this.cameraSrv + " failed with error [" + errorCode + "]");
                                }
                                if (!(this.videoSourceClient instanceof SamsungVideoSourceClient) || (errorCode = ((SamsungVideoSourceClient)this.videoSourceClient).setImageParameters(framerate)) == 0) ** GOTO lbl121
                                this.logger.warn("Setting framerate of " + this.cameraSrv + " failed with error [" + errorCode + "]");
                            }
                            this.discard();
                        }
                        catch (Throwable ex) {
                            this.logger.error((Object)ex, ex);
                            throw new RuntimeException(ex.getMessage());
                        }
                    } else if (!(this.cameraSrv.isMPEG() || highestFramerate < 1000L || this.cameraSrv.getEntityType() != 211902L && this.cameraSrv.getEntityType() != 211911L && this.cameraSrv.getEntityType() != 211903L && this.cameraSrv.getEntityType() != 211912L && this.cameraSrv.getEntityType() != 211905L && this.cameraSrv.getEntityType() != 211914L && this.cameraSrv.getEntityType() != 211906L && this.cameraSrv.getEntityType() != 211915L)) {
                        try {
                            framerate = (int)highestFramerate;
                            sanyoJpegVideoSourceClient_hd1 = (SanyoJPEGVideoSourceClient_HD1)this.videoSourceClient;
                            errorCode = sanyoJpegVideoSourceClient_hd1.restartServerPush(framerate);
                            if (errorCode == 0) ** GOTO lbl121
                            this.logger.warn("Setting stream parameter of " + this.cameraSrv + " failed with error [" + errorCode + "]");
                        }
                        catch (Throwable ex) {
                            this.logger.error((Object)ex, ex);
                            throw new RuntimeException(ex.getMessage());
                        }
                    } else if (!(this.cameraSrv.isMPEG() || highestFramerate < 1000L || this.cameraSrv.getEntityType() != 211904L && this.cameraSrv.getEntityType() != 211913L && this.cameraSrv.getEntityType() != 211907L && this.cameraSrv.getEntityType() != 211916L && this.cameraSrv.getEntityType() != 211909L && this.cameraSrv.getEntityType() != 211918L && this.cameraSrv.getEntityType() != 211910L && this.cameraSrv.getEntityType() != 211919L)) {
                        try {
                            framerate = (int)highestFramerate;
                            sanyoJpegVideoSourceClient_hd2 = (SanyoJPEGVideoSourceClient_HD2)this.videoSourceClient;
                            errorCode = sanyoJpegVideoSourceClient_hd2.restartServerPush(framerate);
                            if (errorCode == 0) ** GOTO lbl121
                            this.logger.warn("Setting stream parameter of " + this.cameraSrv + " failed with error [" + errorCode + "]");
                        }
                        catch (Throwable ex) {
                            this.logger.error((Object)ex, ex);
                            throw new RuntimeException(ex.getMessage());
                        }
                    } else if (!this.cameraSrv.isMPEG() && this.cameraSrv.getDevice().getDeviceType() >= 203200L && this.cameraSrv.getDevice().getDeviceType() <= 203299L) {
                        deviceType = this.cameraSrv.getDevice().getDeviceType();
                        if (deviceType == 203200L || deviceType == 203201L || deviceType == 203202L) {
                            try {
                                errorCode = ((SiquraJPEGVideoSourceClient)this.videoSourceClient).setFramerate((int)highestFramerate);
                                if (errorCode == 0) ** GOTO lbl121
                                this.logger.warn("Setting stream parameter of " + this.cameraSrv + " failed with error [" + errorCode + "]");
                            }
                            catch (Throwable ex) {
                                this.logger.error((Object)ex, ex);
                                throw new RuntimeException(ex.getMessage());
                            }
                        }
                    } else if (!this.isMPEG() && (this.cameraSrv.getEntityType() >= 210400L && this.cameraSrv.getEntityType() <= 210499L || this.cameraSrv.getEntityType() >= 214400L && this.cameraSrv.getEntityType() <= 214499L)) {
                        try {
                            errorCode = ((HikvisionVideoSourceClientISAPI)this.videoSourceClient).setCameraParameters((int)highestFramerate);
                            if (errorCode == 0) ** GOTO lbl121
                            this.logger.warn("Setting stream parameter of " + this.cameraSrv + " failed with error [" + errorCode + "] :-(");
                        }
                        catch (Throwable ex) {
                            this.logger.error((Object)ex, ex);
                            throw new RuntimeException(ex.getMessage());
                        }
                    } else if (this.cameraSrv.getDevice().getDeviceType() >= 203400L && this.cameraSrv.getDevice().getDeviceType() <= 203499L) {
                        try {
                            errorCode = ((SantecVideoSourceClient)this.videoSourceClient).setImageParameter(this.actualFramerate, this.getVideoSourceParameter().getQuality());
                            if (errorCode == 0) ** GOTO lbl121
                            this.logger.warn("Setting stream parameter of " + this.cameraSrv + " failed with error [" + errorCode + "]");
                        }
                        catch (Throwable ex) {
                            this.logger.error((Object)ex, ex);
                            throw new RuntimeException(ex.getMessage());
                        }
                    } else if (this.cameraSrv.getEntityType() >= 212200L && this.cameraSrv.getEntityType() <= 212299L) {
                        try {
                            errorCode = ((SiemensVideoSourceClient)this.videoSourceClient).setFramerate((int)highestFramerate);
                            if (errorCode == 0) ** GOTO lbl121
                            this.logger.warn("Setting stream parameter of " + this.cameraSrv + " failed with error [" + errorCode + "]");
                        }
                        catch (Throwable ex) {
                            this.logger.error((Object)ex, ex);
                            throw new RuntimeException(ex.getMessage());
                        }
                    } else if (this.cameraSrv.getEntityType() != 216801L) {
                        this.discard();
                    }
                }
lbl121:
                // 31 sources

                if (this.actualFramerate <= 0L || this.videoSourceClient != null && !this.videoSourceClient.isShutdown()) break block55;
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException var4_25) {
                    // empty catch block
                }
                this.logger.info("Recover broken camera connection of " + this + " ...");
                this.discard();
            }
            catch (Throwable ex) {
                this.logger.warn(this + ": " + ex.getMessage());
            }
        }
        this.checkingFramerateActive = false;
    }

    @Override
    public long getHighestFramerate() {
        try {
            LiveReader[] liveReaders;
            long profileFramerate = this.getVideoSourceParameter().getFramerate();
            long highestFramerate = 0L;
            for (LiveReader liveReaders1 : liveReaders = this.cameraSrv.getLiveReaders(this)) {
                if (!super.isMPEG() && this.cameraSrv.limitJpegFramerateToVideoProfile()) {
                    highestFramerate = profileFramerate;
                    break;
                }
                if (liveReaders1.isShutdown() || liveReaders1.getJpegFramerate() <= highestFramerate) continue;
                highestFramerate = (int)liveReaders1.getJpegFramerate();
            }
            if (this.getAdditionalRecording()) {
                highestFramerate = profileFramerate;
            }
            if (super.isMPEG()) {
                if (highestFramerate > 0L || this.getVideoSourceParameter().isFetchPermanently()) {
                    return profileFramerate;
                }
                return 0L;
            }
            if (highestFramerate > 0L) {
                return highestFramerate;
            }
            if (this.getVideoSourceParameter().isFetchPermanently()) {
                return profileFramerate;
            }
            return 0L;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            throw new RuntimeException(ex.getMessage());
        }
    }

    @Override
    public boolean isStandardVideoProfile() {
        try {
            return this.videoSourceParameter.isStandardProfile();
        }
        catch (ConfigurationException cex) {
            throw new RuntimeException(cex.getMessage());
        }
    }

    @Override
    public String getVideoProfileName() {
        return this.videoSourceParameter.getVideoProfileName();
    }

    @Override
    public VideoSourceParameter getVideoSourceParameter() {
        return this.videoSourceParameter;
    }

    public final boolean getAdditionalRecording() {
        return this.additionalRecording;
    }

    public final void setAdditionalRecording(boolean additionalRecording) {
        this.additionalRecording = additionalRecording;
    }

    @Override
    public int checkEdgeStorageOnDeviceStart() {
        return 0;
    }
}

