/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.onvif.services;

import de.seetec.v5.re.cm.device.shared.onvif.MultiStreamingInformation;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifDevice;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifHelper;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifService;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.ws.Holder;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.onvif.ver10.media.wsdl.Media;
import org.onvif.ver10.media.wsdl.VideoSourceMode;
import org.onvif.ver10.schema.AudioEncoderConfiguration;
import org.onvif.ver10.schema.AudioSourceConfiguration;
import org.onvif.ver10.schema.H264Options;
import org.onvif.ver10.schema.JpegOptions;
import org.onvif.ver10.schema.MediaUri;
import org.onvif.ver10.schema.Mpeg4Options;
import org.onvif.ver10.schema.Profile;
import org.onvif.ver10.schema.Rotate;
import org.onvif.ver10.schema.RotateMode;
import org.onvif.ver10.schema.StreamSetup;
import org.onvif.ver10.schema.StreamType;
import org.onvif.ver10.schema.Transport;
import org.onvif.ver10.schema.TransportProtocol;
import org.onvif.ver10.schema.VideoEncoderConfigurationOptions;
import org.onvif.ver10.schema.VideoResolution;
import org.onvif.ver10.schema.VideoSourceConfiguration;
import org.onvif.ver10.schema.VideoSourceConfigurationExtension;

public final class MediaService
extends OnvifService {
    private final Media onvifMediaService;
    private final String mediaServiceAddress;
    private MultiStreamingInformation multiStreamingInformation = null;

    public MediaService(JaxWsProxyFactoryBean factory, OnvifDevice onvifDevice, String mediaServiceAddress) throws Exception {
        super(factory, onvifDevice);
        this.mediaServiceAddress = mediaServiceAddress;
        this.onvifMediaService = this.createService(Media.class, this.mediaServiceAddress);
    }

    public Media getOnvifMediaService() {
        return this.onvifMediaService;
    }

    public String getMediaServiceAddress() {
        return this.mediaServiceAddress;
    }

    public Profile getProfile(String profileToken, String profileTokenDefault, int source, int stream) {
        if (profileToken == null || profileToken.equals("") || profileToken.equals(profileTokenDefault)) {
            return this.getSeeTecProfile(source, stream);
        }
        return this.onvifMediaService.getProfile(profileToken);
    }

    public Profile getSeeTecProfile(int source, int stream) {
        String profileToken = MediaService.getProfileName(source, stream);
        if (this.isProfileExisting(profileToken)) {
            return this.onvifMediaService.getProfile(profileToken);
        }
        Profile profile = this.onvifMediaService.createProfile(profileToken, profileToken);
        try {
            List allAudioEncoderConfigurations;
            List audioEncoderConfigurations;
            List allAudioSourceConfigurations;
            List audioSourceConfigurations = this.onvifMediaService.getCompatibleAudioSourceConfigurations(profile.getToken());
            if (audioSourceConfigurations.size() > 0) {
                this.onvifMediaService.removeAudioSourceConfiguration(profileToken);
            }
            if ((allAudioSourceConfigurations = this.onvifMediaService.getAudioSourceConfigurations()).size() > 0) {
                this.onvifMediaService.addAudioSourceConfiguration(profile.getName(), ((AudioSourceConfiguration)allAudioSourceConfigurations.get(0)).getToken());
            }
            if ((audioEncoderConfigurations = this.onvifMediaService.getCompatibleAudioEncoderConfigurations(profile.getToken())).size() > 0) {
                this.onvifMediaService.removeAudioEncoderConfiguration(profileToken);
            }
            if ((allAudioEncoderConfigurations = this.onvifMediaService.getAudioEncoderConfigurations()).size() > 0) {
                this.onvifMediaService.addAudioEncoderConfiguration(profile.getName(), ((AudioEncoderConfiguration)allAudioEncoderConfigurations.get(0)).getToken());
            }
        }
        catch (Exception ex) {
            this.getLogger().info("Exception while retrieving onvif capabilities. Will continue anyway for " + this);
        }
        return profile;
    }

    private boolean isProfileExisting(String profileToken) {
        for (Profile profile : this.onvifMediaService.getProfiles()) {
            if (!profile.getToken().equals(profileToken)) continue;
            return true;
        }
        return false;
    }

    public static String getProfileName(int source, int stream) {
        return "seetec-" + source + "_" + stream;
    }

    public String getStreamUri(String profileToken, StreamType streamType, TransportProtocol ... transportProtocols) throws Exception {
        StreamSetup streamSetup = MediaService.getStreamSetup(streamType, transportProtocols);
        MediaUri mediaUri = this.onvifMediaService.getStreamUri(streamSetup, profileToken);
        return mediaUri.getUri();
    }

    protected static StreamSetup getStreamSetup(StreamType streamType, TransportProtocol ... transportProtocols) {
        StreamSetup streamSetup = new StreamSetup();
        streamSetup.setStream(streamType);
        Transport transport = null;
        for (int i = transportProtocols.length - 1; i >= 0; --i) {
            Transport temp = new Transport();
            temp.setProtocol(transportProtocols[i]);
            if (transport != null) {
                temp.setTunnel(transport);
            }
            transport = temp;
        }
        streamSetup.setTransport(transport);
        return streamSetup;
    }

    public String getSnapshotUri(String profileToken) throws Exception {
        MediaUri snapshotUri = this.onvifMediaService.getSnapshotUri(profileToken);
        return snapshotUri.getUri();
    }

    public MultiStreamingInformation getMultiStreamingInformation(String videoSourceConfigurationToken) {
        if (this.multiStreamingInformation == null) {
            Holder totalNumber = new Holder();
            Holder numberOfJpegStreams = new Holder();
            Holder numberOfH264Streams = new Holder();
            Holder numberOfMpeg4Streams = new Holder();
            try {
                this.onvifMediaService.getGuaranteedNumberOfVideoEncoderInstances(videoSourceConfigurationToken, totalNumber, numberOfJpegStreams, numberOfH264Streams, numberOfMpeg4Streams);
            }
            catch (Exception exception) {
                totalNumber.value = 1;
                numberOfJpegStreams.value = 1;
                numberOfH264Streams.value = 1;
                numberOfMpeg4Streams.value = 1;
            }
            this.multiStreamingInformation = new MultiStreamingInformation((Integer)totalNumber.value, (Integer)numberOfJpegStreams.value, (Integer)numberOfH264Streams.value, (Integer)numberOfMpeg4Streams.value);
        }
        return this.multiStreamingInformation;
    }

    public boolean isAudioAvailable() {
        return this.onvifMediaService.getAudioSources().size() > 0;
    }

    public void rotateImage(RotateMode rotateMode, Integer degree) {
        Rotate rotate;
        VideoSourceConfiguration videoSourceConfiguration = new VideoSourceConfiguration();
        VideoSourceConfigurationExtension videoSourceConfigurationExtension = videoSourceConfiguration.getExtension();
        if (videoSourceConfigurationExtension != null && (rotate = videoSourceConfiguration.getExtension().getRotate()) != null) {
            rotate.setMode(rotateMode);
            if (degree != null) {
                rotate.setDegree(degree);
            }
        }
    }

    public void setVideoSourceModeAndWait(VideoSourceMode videoSourceMode, String defaultVideoSourceIndexToken) throws SeeTecException {
        this.getLogger().info("Setting CaptureMode \"" + videoSourceMode.getToken() + "\" for " + this.getOnvifDevice());
        boolean reboot = this.getOnvifMediaService().setVideoSourceMode(defaultVideoSourceIndexToken, videoSourceMode.getToken());
        if (reboot) {
            this.getLogger().info("Waiting for " + this.getOnvifDevice() + " to reboot and set the CaptureMode \"" + videoSourceMode.getToken() + "\"");
        } else {
            this.getLogger().info("Waiting for " + this.getOnvifDevice() + " to set the CaptureMode \"" + videoSourceMode.getToken() + "\"");
        }
        this.waitForCaptureMode(defaultVideoSourceIndexToken, videoSourceMode.getToken());
    }

    public void waitForCaptureMode(String videoSourceToken, String videoSourceModeToken) throws SeeTecException {
        long end;
        long start = System.currentTimeMillis();
        long maxWait = TimeUnit.MINUTES.toMillis(3L);
        VideoSourceMode videoSourceMode = null;
        while (videoSourceMode == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException exception) {
                this.getLogger().warn("Exception while waiting for capture mode: " + exception.getMessage() + " for " + this);
            }
            try {
                List availableVideoSourceModes = this.onvifMediaService.getVideoSourceModes(videoSourceToken);
                for (VideoSourceMode availableVideoSourceMode : availableVideoSourceModes) {
                    if (!availableVideoSourceMode.getToken().equals(videoSourceModeToken) || !availableVideoSourceMode.isEnabled().booleanValue()) continue;
                    videoSourceMode = availableVideoSourceMode;
                    break;
                }
            }
            catch (Throwable availableVideoSourceModes) {
                // empty catch block
            }
            end = System.currentTimeMillis();
            if (videoSourceMode != null || end - start < maxWait) continue;
            throw new SeeTecException(-21600, "CaptureMode \"" + videoSourceModeToken + "\" could not be set for " + this.getOnvifDevice());
        }
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException exception) {
                this.getLogger().warn("Exception while waiting: " + exception.getMessage() + " for " + this);
            }
            try {
                VideoEncoderConfigurationOptions videoEncoderConfigurationOptions = this.onvifMediaService.getVideoEncoderConfigurationOptions(null, null);
                H264Options h264 = videoEncoderConfigurationOptions.getH264();
                if (h264 != null && (OnvifHelper.contains(h264.getResolutionsAvailable(), videoSourceMode.getMaxResolution()) || this.maxResolutionNotDefined(videoSourceMode.getMaxResolution())) && (double)h264.getFrameRateRange().getMax() <= Math.ceil(videoSourceMode.getMaxFramerate())) {
                    return;
                }
                JpegOptions jpeg = videoEncoderConfigurationOptions.getJPEG();
                if (jpeg != null && (OnvifHelper.contains(jpeg.getResolutionsAvailable(), videoSourceMode.getMaxResolution()) || this.maxResolutionNotDefined(videoSourceMode.getMaxResolution())) && (double)jpeg.getFrameRateRange().getMax() <= Math.ceil(videoSourceMode.getMaxFramerate())) {
                    return;
                }
                Mpeg4Options mpeg4 = videoEncoderConfigurationOptions.getMPEG4();
                if (mpeg4 != null && (OnvifHelper.contains(mpeg4.getResolutionsAvailable(), videoSourceMode.getMaxResolution()) || this.maxResolutionNotDefined(videoSourceMode.getMaxResolution())) && (double)mpeg4.getFrameRateRange().getMax() <= Math.ceil(videoSourceMode.getMaxFramerate())) {
                    return;
                }
            }
            catch (Throwable videoEncoderConfigurationOptions) {
                // empty catch block
            }
        } while ((end = System.currentTimeMillis()) - start < maxWait);
        throw new SeeTecException(-21600, "CaptureMode \"" + videoSourceModeToken + "\" could not be set for " + this.getOnvifDevice());
    }

    private boolean maxResolutionNotDefined(VideoResolution videoResolution) {
        return videoResolution.getHeight() == 0 && videoResolution.getWidth() == 0;
    }
}

