/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.onvif.services;

import de.seetec.v5.re.cm.device.shared.onvif.OnvifDevice;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifService;
import de.seetec.v5.re.cm.device.shared.onvif.services.MediaService;
import java.util.ArrayList;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.onvif.ver10.schema.Rotate;
import org.onvif.ver10.schema.RotateMode;
import org.onvif.ver10.schema.StreamSetup;
import org.onvif.ver10.schema.StreamType;
import org.onvif.ver10.schema.Transport;
import org.onvif.ver10.schema.TransportProtocol;
import org.onvif.ver10.schema.VideoSourceConfiguration;
import org.onvif.ver10.schema.VideoSourceConfigurationExtension;
import org.onvif.ver20.media.wsdl.Media2;
import org.onvif.ver20.media.wsdl.MediaProfile;

public class Media2Service
extends OnvifService {
    private final Media2 onvifMediaService;
    private final String mediaServiceAddress;

    public Media2Service(JaxWsProxyFactoryBean factory, OnvifDevice onvifDevice, String mediaServiceAddress) throws Exception {
        super(factory, onvifDevice);
        this.mediaServiceAddress = mediaServiceAddress;
        this.onvifMediaService = this.createService(Media2.class, this.mediaServiceAddress);
    }

    public Media2 getOnvifMedia2Service() {
        return this.onvifMediaService;
    }

    public String getMediaServiceAddress() {
        return this.mediaServiceAddress;
    }

    public MediaProfile getProfile(String profileToken, String profileTokenDefault, int source, int stream) {
        if (profileToken == null || profileToken.equals("") || profileToken.equals(profileTokenDefault)) {
            return this.getSeeTecProfile(source, stream);
        }
        ArrayList<String> types = new ArrayList<String>();
        types.add("All");
        return (MediaProfile)this.onvifMediaService.getProfiles(profileToken, types).get(0);
    }

    public MediaProfile getSeeTecProfile(int source, int stream) {
        String profileToken = MediaService.getProfileName(source, stream);
        if (this.isProfileExisting(profileToken)) {
            ArrayList<String> types = new ArrayList<String>();
            types.add("All");
            return (MediaProfile)this.onvifMediaService.getProfiles(profileToken, types).get(0);
        }
        String mediaProfileToken = this.onvifMediaService.createProfile(profileToken, null);
        ArrayList<String> types = new ArrayList<String>();
        types.add("All");
        return (MediaProfile)this.onvifMediaService.getProfiles(mediaProfileToken, types).get(0);
    }

    private boolean isProfileExisting(String profileToken) {
        for (MediaProfile profile : this.onvifMediaService.getProfiles(null, null)) {
            if (!profile.getToken().equals(profileToken)) continue;
            return true;
        }
        return false;
    }

    public static String getProfileName(int source, int stream) {
        return "seetec-" + source + "_" + stream;
    }

    protected static StreamSetup getStreamSetup(StreamType streamType, TransportProtocol ... transportProtocols) {
        StreamSetup streamSetup = new StreamSetup();
        streamSetup.setStream(streamType);
        Transport transport = null;
        for (int i = transportProtocols.length - 1; i >= 0; --i) {
            Transport temp = new Transport();
            temp.setProtocol(transportProtocols[i]);
            if (transport != null) {
                temp.setTunnel(transport);
            }
            transport = temp;
        }
        streamSetup.setTransport(transport);
        return streamSetup;
    }

    public void rotateImage(RotateMode rotateMode, Integer degree) {
        Rotate rotate;
        VideoSourceConfiguration videoSourceConfiguration = new VideoSourceConfiguration();
        VideoSourceConfigurationExtension videoSourceConfigurationExtension = videoSourceConfiguration.getExtension();
        if (videoSourceConfigurationExtension != null && (rotate = videoSourceConfiguration.getExtension().getRotate()) != null) {
            rotate.setMode(rotateMode);
            if (degree != null) {
                rotate.setDegree(degree);
            }
        }
    }
}

