/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.onvif.metadata;

import de.seetec.v5.re.cm.device.shared.onvif.metadata.AccessoryDescription;
import de.seetec.v5.re.cm.device.shared.onvif.metadata.ColorDescriptor;
import de.seetec.v5.re.cm.device.shared.onvif.metadata.StringLikelihood;
import org.jdom.Element;
import org.jdom.Namespace;

public class JsonObject {
    protected Namespace namespaceHumanBody = Namespace.getNamespace((String)"bd", (String)"http://www.onvif.org/ver20/analytics/humanbody");
    protected Namespace namespaceHumanFace = Namespace.getNamespace((String)"fc", (String)"http://www.onvif.org/ver20/analytics/humanface");
    protected Namespace namespaceOnvifVersion1 = Namespace.getNamespace((String)"tt", (String)"http://www.onvif.org/ver10/schema");
    protected Namespace namespaceXmlSchema = Namespace.getNamespace((String)"xs", (String)"http://www.w3.org/2001/XMLSchema");

    protected final Boolean getBoolean(Element element, String elementName, Namespace namespace) {
        Element childElement = element.getChild(elementName, namespace);
        if (childElement != null) {
            return childElement.getText().equalsIgnoreCase("true");
        }
        return null;
    }

    protected final String getString(Element element, String elementName, Namespace namespace) {
        Element childElement = element.getChild(elementName, namespace);
        if (childElement != null) {
            return childElement.getText();
        }
        return null;
    }

    protected final Float getFloat(Element element, String elementName, Namespace namespace) {
        Element childElement = element.getChild(elementName, namespace);
        if (childElement != null) {
            try {
                return Float.valueOf(Float.parseFloat(childElement.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    protected final ColorDescriptor getColor(Element element, String elementName, Namespace namespace) {
        Element childElement = element.getChild(elementName, namespace);
        if (childElement != null) {
            return new ColorDescriptor(childElement);
        }
        return null;
    }

    protected final StringLikelihood getStringLikelihood(Element element, String elementName) {
        Element childElement = element.getChild(elementName, element.getNamespace());
        if (childElement != null) {
            String value = this.getString(childElement, "Value", this.namespaceXmlSchema);
            Float likelihood = this.getFloat(childElement, "Likelihood", this.namespaceXmlSchema);
            if (value != null || likelihood != null) {
                StringLikelihood stringLikelihood = new StringLikelihood();
                stringLikelihood.setLikelihood(likelihood.floatValue());
                stringLikelihood.setValue(value);
                return stringLikelihood;
            }
        }
        return null;
    }

    protected final AccessoryDescription getAccessoryDescription(Element element, String elementName, Namespace namespace) {
        Namespace tt = Namespace.getNamespace((String)"tt", (String)"http://www.onvif.org/ver10/schema");
        Namespace xs = Namespace.getNamespace((String)"xs", (String)"http://www.w3.org/2001/XMLSchema");
        Namespace fc = Namespace.getNamespace((String)"fc", (String)"http://www.onvif.org/ver20/analytics/humanface");
        Element childElement = element.getChild(elementName, namespace);
        if (childElement != null) {
            Boolean wear = this.getBoolean(childElement, "Wear", fc);
            ColorDescriptor colorDescriptor = this.getColor(childElement, "Color", tt);
            if (wear != null || colorDescriptor != null) {
                AccessoryDescription accessoryDescription = new AccessoryDescription();
                accessoryDescription.setColor(colorDescriptor);
                accessoryDescription.setWear(wear);
                return accessoryDescription;
            }
        }
        return null;
    }
}

