/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.onvif.metadata;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.seetec.v5.re.cm.device.shared.onvif.metadata.ClassDescriptor;
import de.seetec.v5.re.cm.device.shared.onvif.metadata.ColorDescriptor;
import de.seetec.v5.re.cm.device.shared.onvif.metadata.HumanBody;
import de.seetec.v5.re.cm.device.shared.onvif.metadata.HumanFace;
import de.seetec.v5.re.cm.device.shared.onvif.metadata.JsonObject;
import de.seetec.v5.re.cm.device.shared.onvif.metadata.LicensePlateInfo;
import de.seetec.v5.re.cm.device.shared.onvif.metadata.ShapeDescriptor;
import de.seetec.v5.re.cm.device.shared.onvif.metadata.VehicleInfo;
import java.util.List;
import org.jdom.Element;

public class Appearance
extends JsonObject {
    private ShapeDescriptor shape;
    private ColorDescriptor color;
    private ClassDescriptor classDescriptor;
    private VehicleInfo vehicleInfo;
    private LicensePlateInfo licensePlateInfo;
    private HumanFace humanFace;
    private HumanBody humanBody;
    private String image;

    Appearance(Element element) {
        Element humanBodyElement;
        Element humanFaceElement;
        Element classElement;
        Element shapeElement = element.getChild("Shape", this.namespaceOnvifVersion1);
        if (shapeElement != null) {
            this.shape = new ShapeDescriptor(shapeElement);
        }
        if ((classElement = element.getChild("Class", this.namespaceOnvifVersion1)) != null) {
            this.classDescriptor = new ClassDescriptor(classElement);
        }
        List vehicleInfos = element.getChildren("VehicleInfo", this.namespaceOnvifVersion1);
        for (Element vehicleInfoElement : vehicleInfos) {
            this.vehicleInfo = new VehicleInfo(vehicleInfoElement);
        }
        Element licensePlateInfoElement = element.getChild("LicensePlateInfo", this.namespaceOnvifVersion1);
        if (licensePlateInfoElement != null) {
            this.licensePlateInfo = new LicensePlateInfo(licensePlateInfoElement);
        }
        if ((humanFaceElement = element.getChild("HumanFace", this.namespaceOnvifVersion1)) != null) {
            this.humanFace = new HumanFace(humanFaceElement);
        }
        if ((humanBodyElement = element.getChild("HumanBody", this.namespaceOnvifVersion1)) != null) {
            this.humanBody = new HumanBody(humanBodyElement);
        }
        this.color = this.getColor(element, "Color", this.namespaceOnvifVersion1);
        this.image = this.getString(element, "Image", this.namespaceXmlSchema);
    }

    @JsonProperty(value="Shape")
    public ShapeDescriptor getShape() {
        return this.shape;
    }

    public void setShape(ShapeDescriptor shape) {
        this.shape = shape;
    }

    @JsonProperty(value="Color")
    public ColorDescriptor getColor() {
        return this.color;
    }

    public void setColor(ColorDescriptor color) {
        this.color = color;
    }

    @JsonProperty(value="ClassDescriptor")
    public ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    public void setClassDescriptor(ClassDescriptor classDescriptor) {
        this.classDescriptor = classDescriptor;
    }

    @JsonProperty(value="VehicleInfo")
    public VehicleInfo getVehicleInfo() {
        return this.vehicleInfo;
    }

    public void setVehicleInfo(VehicleInfo vehicleInfo) {
        this.vehicleInfo = vehicleInfo;
    }

    @JsonProperty(value="LicensePlateInfo")
    public LicensePlateInfo getLicensePlateInfo() {
        return this.licensePlateInfo;
    }

    public void setLicensePlateInfo(LicensePlateInfo licensePlateInfo) {
        this.licensePlateInfo = licensePlateInfo;
    }

    @JsonProperty(value="HumanFace")
    public HumanFace getHumanFace() {
        return this.humanFace;
    }

    public void setHumanFace(HumanFace humanFace) {
        this.humanFace = humanFace;
    }

    @JsonProperty(value="HumanBody")
    public HumanBody getHumanBody() {
        return this.humanBody;
    }

    public void setHumanBody(HumanBody humanBody) {
        this.humanBody = humanBody;
    }

    @JsonProperty(value="Image")
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }
}

