/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.onvif.enums;

import de.seetec.v5.re.cm.device.shared.onvif.services.AnalyticsService;
import de.seetec.v5.re.cm.device.shared.onvif.services.DeviceIoService;
import de.seetec.v5.re.cm.device.shared.onvif.services.DeviceService;
import de.seetec.v5.re.cm.device.shared.onvif.services.EventService;
import de.seetec.v5.re.cm.device.shared.onvif.services.ImagingService;
import de.seetec.v5.re.cm.device.shared.onvif.services.Media2Service;
import de.seetec.v5.re.cm.device.shared.onvif.services.MediaService;
import de.seetec.v5.re.cm.device.shared.onvif.services.PtzService;
import de.seetec.v5.re.cm.device.shared.onvif.services.ReplayService;
import de.seetec.v5.re.cm.device.shared.onvif.services.SearchService;

public enum ServiceConstants {
    DEVICE("Device", "http://www.onvif.org/ver10/device/wsdl", DeviceService.class, true),
    MEDIA("Media", "http://www.onvif.org/ver10/media/wsdl", MediaService.class, true),
    MEDIA2("Media2", "http://www.onvif.org/ver20/media/wsdl", Media2Service.class, true),
    EVENT("Event", "http://www.onvif.org/ver10/events/wsdl", EventService.class, false),
    DEVICEIO("DeviceIO", "http://www.onvif.org/ver10/deviceIO/wsdl", DeviceIoService.class, false),
    PTZ("PTZ", "http://www.onvif.org/ver20/ptz/wsdl", PtzService.class, false),
    IMAGING("Imaging", "http://www.onvif.org/ver20/imaging/wsdl", ImagingService.class, false),
    ANALYTICS("Analytics", "http://www.onvif.org/ver20/analytics/wsdl", AnalyticsService.class, false),
    REPLAY("Replay", "http://www.onvif.org/ver10/replay/wsdl", ReplayService.class, false),
    SEARCH("Search", "http://www.onvif.org/ver10/search/wsdl", SearchService.class, false);

    private final String serviceName;
    private final String serviceNamespace;
    private final Class<?> onvifServiceClass;
    private final boolean mandatory;

    private ServiceConstants(String serviceName, String serviceNamespace, Class<?> onvifServiceClass, boolean mandatory) {
        this.serviceName = serviceName;
        this.serviceNamespace = serviceNamespace;
        this.onvifServiceClass = onvifServiceClass;
        this.mandatory = mandatory;
    }

    public final String getServiceName() {
        return this.serviceName;
    }

    public final String getServiceNamespace() {
        return this.serviceNamespace;
    }

    public final Class getOnvifServiceClass() {
        return this.onvifServiceClass;
    }

    public final boolean isMandatory() {
        return this.mandatory;
    }
}

