/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.onvif;

import de.seetec.v5.re.cm.device.shared.onvif.OnvifDevice;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifHelper;
import de.seetec.v5.re.cm.device.shared.onvif.enums.ServiceConstants;

public final class OnvifException
extends Exception {
    public static final long serialVersionUID = -1L;
    private final OnvifDevice device;
    private final ServiceConstants service;
    private final int errorCode;

    public OnvifException(OnvifDevice device, ServiceConstants service, String message, Exception cause) {
        super("ONVIF " + service.getServiceName() + "-Service for " + device + " " + message, cause);
        this.device = device;
        this.service = service;
        this.errorCode = OnvifHelper.exceptionToErrorCode(cause);
    }

    public OnvifDevice getDevice() {
        return this.device;
    }

    public ServiceConstants getService() {
        return this.service;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String toString() {
        return this.getMessage() + " (ONVIF.ErrorCode: " + this.errorCode + ")";
    }
}

