/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.onvif;

import de.seetec.v5.shared.net.NetworkParameter;

public final class OnvifDevice {
    private final String name;
    private final NetworkParameter onvifNetworkParameter;
    private final String username;
    private final String password;
    private final String passwordType;
    private final boolean useAuthorization;

    public OnvifDevice(String name, NetworkParameter networkParameter, String username, String password, String passwordType, boolean useAuthorization) {
        this.name = name;
        this.onvifNetworkParameter = networkParameter;
        this.username = username;
        this.password = password;
        this.passwordType = passwordType;
        this.useAuthorization = useAuthorization;
    }

    public String getName() {
        return this.name;
    }

    public String getIp() {
        return this.onvifNetworkParameter.getHost();
    }

    public int getPort() {
        return this.onvifNetworkParameter.getHTTPport();
    }

    public int getSslPort() {
        return this.onvifNetworkParameter.getSSLport();
    }

    public boolean useHttps() {
        return this.onvifNetworkParameter.useHTTPS();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPasswordType() {
        return this.passwordType;
    }

    public boolean useAuthorization() {
        return this.useAuthorization;
    }

    public String toString() {
        return "[" + this.name + " | " + this.onvifNetworkParameter.getHost() + ":" + this.onvifNetworkParameter.getHTTPport() + "]";
    }
}

