/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.onvif;

import de.seetec.v5.re.cm.device.shared.onvif.OnvifHelper;
import java.util.Collections;
import java.util.List;
import org.onvif.ver10.schema.IntRange;
import org.onvif.ver10.schema.VideoEncoder2ConfigurationOptions;
import org.onvif.ver10.schema.VideoEncoderConfigurationOptions;
import org.onvif.ver10.schema.VideoResolution;

public class OnvifDefaultResolutionFramerate {
    private List<VideoResolution> videoResolutions;
    private IntRange frameRateRange;

    public OnvifDefaultResolutionFramerate(VideoEncoderConfigurationOptions videoEncoderConfigurationOptions) {
        if (videoEncoderConfigurationOptions == null) {
            throw new IllegalArgumentException("No valid videoEncoderConfigurationOptions");
        }
        if (videoEncoderConfigurationOptions.getH264() != null) {
            this.videoResolutions = videoEncoderConfigurationOptions.getH264().getResolutionsAvailable();
            this.frameRateRange = videoEncoderConfigurationOptions.getH264().getFrameRateRange();
        } else if (videoEncoderConfigurationOptions.getJPEG() != null) {
            this.videoResolutions = videoEncoderConfigurationOptions.getJPEG().getResolutionsAvailable();
            this.frameRateRange = videoEncoderConfigurationOptions.getJPEG().getFrameRateRange();
        } else if (videoEncoderConfigurationOptions.getMPEG4() != null) {
            this.videoResolutions = videoEncoderConfigurationOptions.getMPEG4().getResolutionsAvailable();
            this.frameRateRange = videoEncoderConfigurationOptions.getMPEG4().getFrameRateRange();
        }
    }

    public OnvifDefaultResolutionFramerate(VideoEncoder2ConfigurationOptions videoEncoderConfigurationOptions) {
        if (videoEncoderConfigurationOptions == null) {
            throw new IllegalArgumentException("No valid videoEncoderConfigurationOptions");
        }
        List videoResolutions2 = videoEncoderConfigurationOptions.getResolutionsAvailable();
        this.videoResolutions = OnvifHelper.convertResolution2ToResolution(videoResolutions2);
        List framerates = videoEncoderConfigurationOptions.getFrameRatesSupported();
        Float min = (Float)Collections.min(framerates);
        Float max = (Float)Collections.max(framerates);
        this.frameRateRange = new IntRange();
        this.frameRateRange.setMax(max.intValue());
        this.frameRateRange.setMin(min.intValue());
    }

    public List<VideoResolution> getResolutionsAvailable() {
        return this.videoResolutions;
    }

    public IntRange getFrameRateRange() {
        return this.frameRateRange;
    }
}

