/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.onvif;

import java.util.Objects;
import org.onvif.ver10.schema.ItemList;
import org.onvif.ver10.schema.Message;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class EventMessage {
    private final String topic;
    private final String propertyOperationValue;
    private final String sourceName;
    private final String sourceValue;
    private final String dataName;
    private final String dataValue;

    public EventMessage(String topic, String propertyOperationValue, String sourceName, String sourceValue, String dataName, String dataValue) {
        this.topic = topic;
        this.propertyOperationValue = propertyOperationValue;
        this.sourceName = sourceName;
        this.sourceValue = sourceValue;
        this.dataName = dataName;
        this.dataValue = dataValue;
    }

    public EventMessage(String topic, Message message) {
        this.topic = topic;
        this.propertyOperationValue = message.getPropertyOperation() != null ? message.getPropertyOperation().value() : null;
        StringBuilder sourceNam = new StringBuilder();
        StringBuilder sourceVal = new StringBuilder();
        StringBuilder dataNam = new StringBuilder();
        StringBuilder dataVal = new StringBuilder();
        for (ItemList.SimpleItem sourceItem : message.getSource().getSimpleItem()) {
            sourceNam.append(sourceItem.getName());
            sourceVal.append(sourceItem.getValue());
        }
        for (ItemList.SimpleItem dataItem : message.getData().getSimpleItem()) {
            dataNam.append(dataItem.getName());
            dataVal.append(dataItem.getValue());
        }
        this.sourceName = sourceNam.toString();
        this.sourceValue = sourceVal.toString();
        this.dataName = dataNam.toString();
        this.dataValue = dataVal.toString();
    }

    public EventMessage(String topic, Element message) {
        this.topic = topic;
        this.propertyOperationValue = message.getAttribute("PropertyOperation");
        String sourceNam = "";
        String sourceVal = "";
        String dataNam = "";
        String dataVal = "";
        NodeList messageNodes = message.getChildNodes();
        for (int i = 0; i < messageNodes.getLength(); ++i) {
            int j;
            Node messageNode = messageNodes.item(i);
            if (messageNode.getLocalName() != null && messageNode.getLocalName().equals("Source")) {
                NodeList sourceNodes = messageNode.getChildNodes();
                for (j = 0; j < sourceNodes.getLength(); ++j) {
                    Node sourceNode = sourceNodes.item(j);
                    if (sourceNode.getLocalName() == null || !sourceNode.getLocalName().equals("SimpleItem") || !sourceNam.equals("") || !sourceVal.equals("")) continue;
                    sourceNam = sourceNode.getAttributes().getNamedItem("Name").getNodeValue();
                    sourceVal = sourceNode.getAttributes().getNamedItem("Value").getNodeValue();
                }
            }
            if (messageNode.getLocalName() == null || !messageNode.getLocalName().equals("Data")) continue;
            NodeList dataNodes = messageNode.getChildNodes();
            for (j = 0; j < dataNodes.getLength(); ++j) {
                Node dataNode = dataNodes.item(j);
                if (dataNode.getLocalName() == null || !dataNode.getLocalName().equals("SimpleItem") || !dataNam.equals("") || !dataVal.equals("")) continue;
                dataNam = dataNode.getAttributes().getNamedItem("Name").getNodeValue();
                dataVal = dataNode.getAttributes().getNamedItem("Value").getNodeValue();
            }
        }
        this.sourceName = sourceNam;
        this.sourceValue = sourceVal;
        this.dataName = dataNam;
        this.dataValue = dataVal;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getPropertyOperationValue() {
        return this.propertyOperationValue;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getSourceValue() {
        return this.sourceValue;
    }

    public String getDataName() {
        return this.dataName;
    }

    public String getDataValue() {
        return this.dataValue;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof EventMessage) {
            boolean dataNameEquals;
            boolean sourceValueEquals;
            boolean sourceNameEquals;
            boolean propertyOperationValueEquals;
            boolean topicEquals;
            EventMessage that = (EventMessage)object;
            boolean bl = this.topic == null ? that.topic == null : (topicEquals = this.topic.equals(that.topic));
            boolean bl2 = this.propertyOperationValue == null ? that.propertyOperationValue == null : (propertyOperationValueEquals = this.propertyOperationValue.equals(that.propertyOperationValue));
            boolean bl3 = this.sourceName == null ? that.sourceName == null : (sourceNameEquals = this.sourceName.equals(that.sourceName));
            boolean bl4 = this.sourceValue == null ? that.sourceValue == null : (sourceValueEquals = this.sourceValue.equals(that.sourceValue));
            boolean bl5 = this.dataName == null ? that.dataName == null : (dataNameEquals = this.dataName.equals(that.dataName));
            boolean dataValueEquals = this.dataValue == null ? that.dataValue == null : this.dataValue.equals(that.dataValue);
            return topicEquals && propertyOperationValueEquals && sourceNameEquals && sourceValueEquals && dataNameEquals && dataValueEquals;
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 41 * hash + Objects.hashCode(this.topic);
        hash = 41 * hash + Objects.hashCode(this.propertyOperationValue);
        hash = 41 * hash + Objects.hashCode(this.sourceName);
        hash = 41 * hash + Objects.hashCode(this.sourceValue);
        hash = 41 * hash + Objects.hashCode(this.dataName);
        hash = 41 * hash + Objects.hashCode(this.dataValue);
        return hash;
    }

    public String toString() {
        return "EventMessage: \r\nData name: " + this.getDataName() + "\r\nData value: " + this.getDataValue() + "\r\nSource name: " + this.getSourceName() + "\r\nSource value: " + this.getSourceValue() + "\r\nProperty operation value: " + this.getPropertyOperationValue() + "\r\nTopic: " + this.getTopic() + "\r\n";
    }
}

