/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net.udp;

import de.seetec.v5.re.cm.device.shared.net.udp.UdpWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.apache.logging.log4j.LogManager;

public final class UdpWriterUnicast
extends UdpWriter {
    private final InetAddress remoteAddress;
    private final int remotePort;

    public UdpWriterUnicast(InetAddress address, DatagramSocket givenSocket, int port) {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        this.shutdown = false;
        this.remotePort = port;
        this.remoteAddress = address;
        if (givenSocket != null) {
            this.socket = givenSocket;
        } else {
            this.openSocket();
        }
        if (this.socket != null) {
            this.logger.info("Opened udp port [ " + this.socket.getLocalPort() + " ] for " + this.remoteAddress + ":" + this.remotePort);
        } else {
            this.logger.warn("No socket, shutting down");
        }
    }

    @Override
    protected void openSocket() {
        int i = 0;
        while (this.socket == null && i < 10) {
            ++i;
            try {
                this.socket = new DatagramSocket();
                this.socket.setSoTimeout(100000);
            }
            catch (Exception e) {
                this.logger.info((Object)e);
                this.socket = null;
            }
        }
        if (this.socket == null) {
            this.logger.warn("No socket available");
        }
    }

    @Override
    public int send(byte[] data) {
        if (this.shutdown) {
            return -21609;
        }
        try {
            DatagramPacket p = new DatagramPacket(data, data.length, this.remoteAddress, this.remotePort);
            this.socket.send(p);
        }
        catch (Exception e) {
            if (this.shutdown) {
                return -21609;
            }
            this.logger.warn((Object)e);
            this.shutdown();
            return -21656;
        }
        return 0;
    }
}

