/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net.udp;

import de.seetec.v5.re.cm.device.shared.net.NetworkCallback;
import de.seetec.v5.re.cm.device.shared.net.udp.UdpReader;
import java.net.InetAddress;
import java.net.MulticastSocket;
import org.apache.logging.log4j.LogManager;

public class UdpReaderMulticast
extends UdpReader {
    private String ip;
    private int port = -1;

    public UdpReaderMulticast(NetworkCallback callback, String ip, int port) {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        this.shutdown = false;
        this.callback = callback;
        this.ip = ip;
        this.port = port;
    }

    @Override
    protected void openSocket(int bufferSize, int soTimeout, boolean onlyAcceptEvenPorts) {
        try {
            this.logger.info(" try to open datagram socket, buffer is " + bufferSize + " bytes. Port: " + this.port);
            if (this.port != -1) {
                this.socket = new MulticastSocket(this.port);
            } else if (onlyAcceptEvenPorts) {
                while ((this.socket = new MulticastSocket()).getLocalPort() % 2 != 0) {
                    this.logger.info("UDP server port is specified to be EVEN, but we got '" + this.socket.getLocalPort() + "'. Close and try again.");
                    this.socket.close();
                }
            } else {
                this.socket = new MulticastSocket();
            }
            this.socket.setSoTimeout(soTimeout);
            this.socket.setReceiveBufferSize(bufferSize);
            InetAddress addr = InetAddress.getByName(this.ip);
            ((MulticastSocket)this.socket).joinGroup(addr);
            this.logger.info("Joining group: " + addr);
        }
        catch (Exception ex) {
            this.logger.warn("Exception during multicast socket creation", (Throwable)ex);
            this.socket = null;
        }
    }
}

