/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net.udp;

import de.seetec.v5.re.cm.device.shared.net.NetworkCallback;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class UdpReader
implements Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.shared.net.udp.UdpReader";
    private static final String CLASS_DEBUG_NAME = "UdpReader";
    protected Logger logger = null;
    protected NetworkCallback callback;
    protected boolean shutdown;
    protected DatagramSocket socket;
    protected boolean abortOnTimeout = false;
    protected int datagramBuffersize = 2048;
    protected int remotePort = -1;
    protected InetAddress remoteAddress = null;
    private int soTimeoutValue = Integer.MIN_VALUE;

    public void init(int bufferSize) {
        this.soTimeoutValue = 10000;
        this.init(bufferSize, 10000, false, false, 2048);
    }

    public void init(int bufferSize, int soTimeout, boolean abortOnTimeout) {
        this.soTimeoutValue = soTimeout;
        this.init(bufferSize, soTimeout, abortOnTimeout, false, 2048);
    }

    public void init(int bufferSize, int soTimeout, boolean abortOnTimeout, boolean onlyAcceptEvenPorts) {
        this.soTimeoutValue = soTimeout;
        this.init(bufferSize, soTimeout, abortOnTimeout, onlyAcceptEvenPorts, 2048);
    }

    public void init(int bufferSize, int soTimeout, boolean abortOnTimeout, boolean onlyAcceptEvenPorts, int datagramBuffersize) {
        this.soTimeoutValue = soTimeout;
        if (soTimeout < 0) {
            this.callback.onNetworkError(-21601);
            return;
        }
        this.abortOnTimeout = abortOnTimeout;
        this.datagramBuffersize = datagramBuffersize;
        this.logger = LogManager.getLogger((String)CLASS_NAME);
        this.openSocket(bufferSize, soTimeout, onlyAcceptEvenPorts);
        if (this.socket != null) {
            new Thread((Runnable)this, this.toString()).start();
        } else {
            this.logger.error("No socket, shutting down");
            this.callback.onNetworkError(-21656);
        }
    }

    public DatagramSocket getSocket() {
        return this.socket;
    }

    public int getPort() {
        return this.socket == null ? -1 : this.socket.getLocalPort();
    }

    public void shutdown() {
        this.shutdown = true;
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (Exception e) {
            this.logger.error("Exception closing stream", (Throwable)e);
        }
    }

    protected abstract void openSocket(int var1, int var2, boolean var3);

    @Override
    public void run() {
        byte[] buffer = new byte[this.datagramBuffersize];
        while (!this.shutdown) {
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
            try {
                this.socket.receive(packet);
            }
            catch (SocketTimeoutException ste) {
                this.logger.warn("Timeout reading from socket after [" + this.soTimeoutValue + " ms] for " + this.socket + " / " + this);
                if (!this.abortOnTimeout) continue;
                this.logger.warn(this.toString() + "SOTimeout reached. Aborting UDPReader.");
                this.callback.onNetworkError(-21656);
                return;
            }
            catch (Exception e) {
                if (this.shutdown) {
                    return;
                }
                this.logger.error("Exception reading udp data", (Throwable)e);
                this.callback.onNetworkError(-21656);
                return;
            }
            int length = packet.getLength();
            int offset = packet.getOffset();
            byte[] data = new byte[length];
            System.arraycopy(packet.getData(), offset, data, 0, length);
            this.callback.onUdpData(data);
        }
    }

    public String toString() {
        return "UdpReader[port=" + this.getPort() + ", callback=" + this.callback.toString() + "]";
    }

    public int send(byte[] data) {
        if (this.shutdown) {
            return -21609;
        }
        try {
            DatagramPacket p = new DatagramPacket(data, data.length, this.remoteAddress, this.remotePort);
            this.socket.send(p);
        }
        catch (Exception e) {
            if (this.shutdown) {
                return -21609;
            }
            this.logger.warn((Object)e);
            this.shutdown();
            return -21656;
        }
        return 0;
    }
}

