/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net.udp;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerIntf;
import de.seetec.v5.re.cm.device.shared.net.udp.UdpRTPReader;
import java.net.InetAddress;
import java.net.MulticastSocket;
import org.apache.logging.log4j.LogManager;

public class UdpRTPReaderMulticast
extends UdpRTPReader {
    private String ip;
    private String localServerAddress;
    private int port = -1;

    public UdpRTPReaderMulticast(RTSPHandlerIntf callback, String ip, int port, String localServerAddress) {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        this.shutdown = false;
        this.callback = callback;
        this.localServerAddress = localServerAddress;
        this.ip = ip;
        this.port = port;
    }

    public UdpRTPReaderMulticast(RTSPHandlerIntf callback, String ip, String localServerAddress) {
        this(callback, ip, -1, localServerAddress);
    }

    @Override
    protected void openSocket(int bufferSize, int soTimeout) {
        try {
            this.logger.info(" try to open datagram socket, buffer is " + bufferSize + " bytes. Port: " + this.port);
            if (this.port != -1) {
                this.socket = new MulticastSocket(this.port);
            } else {
                while ((this.socket = new MulticastSocket()).getLocalPort() % 2 != 0) {
                    this.logger.info("UDP server port is specified to be EVEN, but we got '" + this.socket.getLocalPort() + "'. Close and try again.");
                    this.socket.close();
                }
            }
            this.socket.setSoTimeout(soTimeout);
            this.socket.setReceiveBufferSize(bufferSize);
            if (this.localServerAddress != null) {
                ((MulticastSocket)this.socket).setInterface(InetAddress.getByName(this.localServerAddress));
            }
            InetAddress addr = InetAddress.getByName(this.ip);
            ((MulticastSocket)this.socket).joinGroup(addr);
            this.logger.info("Joining group: " + addr);
        }
        catch (Exception ex) {
            this.logger.warn("Exception during multicast socket creation", (Throwable)ex);
            this.socket = null;
        }
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
        try {
            if (this.socket != null) {
                if (this.socket instanceof MulticastSocket) {
                    InetAddress addr = InetAddress.getByName(this.ip);
                    ((MulticastSocket)this.socket).leaveGroup(addr);
                    this.logger.info("Leaving Group: " + addr);
                }
                this.socket.close();
                this.socket = null;
            }
        }
        catch (Exception e) {
            this.logger.error("Exception closing stream [" + this.ip + "]");
        }
    }
}

