/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net.rtsp.request;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPRequest;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;

public class PlayRequest
extends RTSPRequest {
    private String range;
    private Double scale = null;
    private String frames;
    private String requireField;

    public int init(String url, RTSPStreamSettings rtspSettings) {
        return this.init(url, null, rtspSettings);
    }

    public int init(String url, String range, RTSPStreamSettings rtspStreamSettings) {
        this.url = url;
        this.command = 8;
        this.range = range;
        this.requireField = rtspStreamSettings.getRequireField();
        this.userAgent = rtspStreamSettings.getUserAgent();
        this.scale = rtspStreamSettings.getScale();
        this.isBackChannelEnabled = rtspStreamSettings.isIsBackChannelEnabled();
        this.frames = rtspStreamSettings.getFrames();
        return super.init();
    }

    @Override
    public String toString() {
        String ret = "PLAY " + this.url + " RTSP/1.0" + "\r\n" + "CSeq: " + this.sequenceNumber + "\r\n";
        if (this.sessionID != null) {
            ret = ret + "Session: " + this.sessionID + "\r\n";
        }
        if (this.range != null) {
            ret = ret + "Range: " + this.range + "\r\n";
        }
        if (this.requireField != null) {
            ret = ret + "Require: " + this.requireField + "\r\n";
        }
        if (this.userAgent != null) {
            ret = ret + "User-Agent: " + this.userAgent + "\r\n";
        }
        if (this.scale != null) {
            ret = ret + "Scale: " + this.scale + "\r\n";
        }
        if (this.isBackChannelEnabled) {
            ret = ret + "Require: www.onvif.org/ver20/backchannel\r\n";
        }
        if (this.frames != null) {
            ret = ret + "Frames: " + this.frames + "\r\n";
        }
        if (this.passPhrase != null) {
            ret = ret + this.passPhrase;
        }
        return ret;
    }
}

