/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net.rtsp.mikey;

import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.MikeySegment;
import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.Payload;
import de.seetec.v5.shared.Basic;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.commons.net.ntp.TimeStamp;

public class Timestamp
extends MikeySegment {
    private byte timestampType;
    private TimeStamp timestamp;
    private byte[] time;

    public Timestamp() {
        this.timestampType = 0;
        this.timestamp = TimeStamp.getCurrentTime();
        this.time = Basic.int8ToByteArray((long)this.timestamp.ntpValue(), (int)8);
    }

    public Timestamp(byte[] input) {
        this.nextPayload = Payload.getPayloadByNumber(input[0]);
        this.timestampType = input[1];
        this.time = new byte[8];
        System.arraycopy(input, 2, this.time, 0, 8);
        this.timestamp = new TimeStamp(Basic.byteArrayToInt8((byte[])input, (int)2, (int)8));
        this.length = 10;
    }

    public byte getTimestampType() {
        return this.timestampType;
    }

    public long getTimestampAsNtp() {
        return this.timestamp.ntpValue();
    }

    public byte[] getTimestampAsByteArray() {
        return this.time;
    }

    @Override
    public byte[] getData() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.nextPayload.getType());
        baos.write(this.timestampType);
        baos.write(Basic.int8ToByteArray((long)this.timestamp.ntpValue()));
        return baos.toByteArray();
    }

    public String toString() {
        String ret = "Timestamp: \r\n\tNext Payload: " + (Object)((Object)this.nextPayload) + "\r\n" + "\tTimestamp type: " + this.timestampType + "\r\n" + "\tTimestamp: " + this.timestamp + "\r\n";
        return ret;
    }
}

