/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net.rtsp.mikey;

import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.AuthenticationAlgorithm;
import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.EncryptionAlgorithm;
import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.MikeySegment;
import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.Payload;
import de.seetec.v5.shared.Basic;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class SecurityPolicy
extends MikeySegment {
    private boolean isSrtpEncrypted;
    private boolean isSrtcpEncrypted;
    private boolean isSrtpAuthenticated;
    private byte policyNumber;
    private byte protocolType;
    private int policyParameterLength;
    private EncryptionAlgorithm encryptionAlgorithm;
    private AuthenticationAlgorithm authenticationAlgorithm;
    private Integer sessionEncryptionKeyLength = 16;
    private Integer sessionAuthenticationKeyLength = 20;
    private Integer sessionSaltKeyLength;
    private Integer pseudoRandomFunction;
    private Integer keyDerivationRate = null;
    private Integer senderFecOrder;
    private Integer authenticationTagLength = 10;
    private Integer srtpPrefixLength;

    public SecurityPolicy() {
        this.policyNumber = 0;
        this.protocolType = 0;
        this.policyParameterLength = 21;
        this.encryptionAlgorithm = EncryptionAlgorithm.AES_CM;
        this.sessionEncryptionKeyLength = 16;
        this.authenticationAlgorithm = AuthenticationAlgorithm.HMAC_SHA_1;
        this.sessionAuthenticationKeyLength = 20;
        this.isSrtpEncrypted = true;
        this.isSrtcpEncrypted = true;
        this.isSrtpAuthenticated = true;
        this.authenticationTagLength = 10;
    }

    public SecurityPolicy(byte[] input) {
        this.nextPayload = Payload.getPayloadByNumber(input[0]);
        this.policyNumber = input[1];
        this.protocolType = input[2];
        this.policyParameterLength = Basic.byteArrayToInt4((byte[])input, (int)3, (int)2);
        int pointer = 5;
        while (pointer < this.policyParameterLength + 5) {
            byte type = input[pointer++];
            switch (type) {
                case 0: {
                    byte lengthOfParameter = input[pointer++];
                    this.encryptionAlgorithm = EncryptionAlgorithm.getEncryptionAlgorithmByNumber(Basic.byteArrayToInt4((byte[])input, (int)pointer, (int)lengthOfParameter));
                    pointer += lengthOfParameter;
                    break;
                }
                case 1: {
                    byte lengthOfParameter = input[pointer++];
                    this.sessionEncryptionKeyLength = Basic.byteArrayToInt4((byte[])input, (int)pointer, (int)lengthOfParameter);
                    pointer += lengthOfParameter;
                    break;
                }
                case 2: {
                    byte lengthOfParameter = input[pointer++];
                    this.authenticationAlgorithm = AuthenticationAlgorithm.getAuthenticationAlgorithmByNumber(Basic.byteArrayToInt4((byte[])input, (int)pointer, (int)lengthOfParameter));
                    pointer += lengthOfParameter;
                    break;
                }
                case 3: {
                    byte lengthOfParameter = input[pointer++];
                    this.sessionAuthenticationKeyLength = Basic.byteArrayToInt4((byte[])input, (int)pointer, (int)lengthOfParameter);
                    pointer += lengthOfParameter;
                    break;
                }
                case 4: {
                    byte lengthOfParameter = input[pointer++];
                    this.sessionSaltKeyLength = Basic.byteArrayToInt4((byte[])input, (int)pointer, (int)lengthOfParameter);
                    pointer += lengthOfParameter;
                    break;
                }
                case 5: {
                    byte lengthOfParameter = input[pointer++];
                    this.pseudoRandomFunction = Basic.byteArrayToInt4((byte[])input, (int)pointer, (int)lengthOfParameter);
                    pointer += lengthOfParameter;
                    break;
                }
                case 6: {
                    byte lengthOfParameter = input[pointer++];
                    this.keyDerivationRate = Basic.byteArrayToInt4((byte[])input, (int)pointer, (int)lengthOfParameter);
                    pointer += lengthOfParameter;
                    break;
                }
                case 7: {
                    byte lengthOfParameter = input[pointer++];
                    this.isSrtpEncrypted = input[pointer] == 1;
                    pointer += lengthOfParameter;
                    break;
                }
                case 8: {
                    byte lengthOfParameter = input[pointer++];
                    this.isSrtcpEncrypted = input[pointer] == 1;
                    pointer += lengthOfParameter;
                    break;
                }
                case 9: {
                    byte lengthOfParameter = input[pointer++];
                    this.senderFecOrder = Basic.byteArrayToInt4((byte[])input, (int)pointer, (int)lengthOfParameter);
                    pointer += lengthOfParameter;
                    break;
                }
                case 10: {
                    byte lengthOfParameter = input[pointer++];
                    this.isSrtpAuthenticated = input[pointer] == 1;
                    pointer += lengthOfParameter;
                    break;
                }
                case 11: {
                    byte lengthOfParameter = input[pointer++];
                    this.authenticationTagLength = Basic.byteArrayToInt4((byte[])input, (int)pointer, (int)lengthOfParameter);
                    pointer += lengthOfParameter;
                    break;
                }
                case 12: {
                    byte lengthOfParameter = input[pointer++];
                    this.srtpPrefixLength = Basic.byteArrayToInt4((byte[])input, (int)pointer, (int)lengthOfParameter);
                    pointer += lengthOfParameter;
                    break;
                }
            }
        }
        this.length = 5 + this.policyParameterLength;
    }

    public byte getPolicyNumber() {
        return this.policyNumber;
    }

    public byte getProtocolType() {
        return this.protocolType;
    }

    public int getPolicyParameterLength() {
        return this.policyParameterLength;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public AuthenticationAlgorithm getAuthenticationAlgorithm() {
        return this.authenticationAlgorithm;
    }

    public int getSessionEncryptionKeyLength() {
        return this.sessionEncryptionKeyLength;
    }

    public int getSessionAuthenticationKeyLength() {
        return this.sessionAuthenticationKeyLength;
    }

    public boolean isIsSrtpEncrypted() {
        return this.isSrtpEncrypted;
    }

    public boolean isIsSrtcpEncrypted() {
        return this.isSrtcpEncrypted;
    }

    public boolean isIsSrtpAuthenticated() {
        return this.isSrtpAuthenticated;
    }

    public Integer getSessionSaltKeyLength() {
        return this.sessionSaltKeyLength;
    }

    public int getPseudoRandomFunction() {
        return this.pseudoRandomFunction;
    }

    public Integer getKeyDerivationRate() {
        if (this.keyDerivationRate == null) {
            return 0;
        }
        return this.keyDerivationRate;
    }

    public int getSenderFecOrder() {
        return this.senderFecOrder;
    }

    public int getAuthenticationTagLength() {
        return this.authenticationTagLength;
    }

    public int getSrtpPrefixLength() {
        return this.srtpPrefixLength;
    }

    @Override
    public byte[] getData() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.nextPayload.getType());
        baos.write(this.policyNumber);
        baos.write(this.protocolType);
        baos.write(Basic.int4ToByteArray((int)this.policyParameterLength, (int)2));
        if (this.encryptionAlgorithm != null) {
            baos.write(0);
            baos.write(1);
            baos.write(this.encryptionAlgorithm.getType());
        }
        if (this.sessionEncryptionKeyLength != null) {
            baos.write(1);
            baos.write(1);
            baos.write(this.sessionEncryptionKeyLength);
        }
        if (this.authenticationAlgorithm != null) {
            baos.write(2);
            baos.write(1);
            baos.write(this.authenticationAlgorithm.getType());
        }
        if (this.sessionAuthenticationKeyLength != null) {
            baos.write(3);
            baos.write(1);
            baos.write(this.sessionAuthenticationKeyLength);
        }
        if (this.sessionSaltKeyLength != null) {
            baos.write(4);
            baos.write(1);
            baos.write(this.sessionSaltKeyLength);
        }
        if (this.pseudoRandomFunction != null) {
            baos.write(5);
            baos.write(1);
            baos.write(this.pseudoRandomFunction);
        }
        if (this.keyDerivationRate != null) {
            baos.write(6);
            baos.write(1);
            baos.write(this.keyDerivationRate);
        }
        baos.write(7);
        baos.write(1);
        baos.write(this.isSrtpEncrypted ? 1 : 0);
        baos.write(8);
        baos.write(1);
        baos.write(this.isSrtcpEncrypted ? 1 : 0);
        if (this.senderFecOrder != null) {
            baos.write(9);
            baos.write(1);
            baos.write(this.senderFecOrder);
        }
        baos.write(10);
        baos.write(1);
        baos.write(this.isSrtpAuthenticated ? 1 : 0);
        return baos.toByteArray();
    }

    public String toString() {
        String ret = "Security Policy: \r\n\tNext payload: " + (Object)((Object)this.nextPayload) + "\r\n" + "\tPolicy number: " + this.policyNumber + "\r\n" + "\tProtocol type: " + this.protocolType + "\r\n" + "\tPolicy Parameter length: " + this.policyParameterLength + "\r\n" + "\tEncryption algorithm: " + (Object)((Object)this.encryptionAlgorithm) + "\r\n" + "\tSession encryption key length: " + this.sessionEncryptionKeyLength + "\r\n" + "\tAuthentication algorithm: " + (Object)((Object)this.authenticationAlgorithm) + "\r\n" + "\tSession authentication key length: " + this.sessionAuthenticationKeyLength + "\r\n" + "\tSRTP encryption: " + this.isSrtpEncrypted + "\r\n" + "\tSRTCP encryption: " + this.isSrtcpEncrypted + "\r\n" + "\tSRTP authentication: " + this.isSrtpAuthenticated + "\r\n";
        return ret;
    }
}

