/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net.rtsp.mikey;

import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.Header;
import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.KeyDataTransportPayload;
import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.MikeySegment;
import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.Payload;
import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.Rand;
import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.SecurityPolicy;
import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.Timestamp;
import java.io.ByteArrayOutputStream;
import java.util.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Mikey {
    private Header header;
    private Timestamp timestamp;
    private Rand rand;
    private SecurityPolicy securityPolicy;
    private KeyDataTransportPayload keyDataTransportPayload;
    private Logger logger = null;
    private String ip;

    public Mikey(String ip) throws Exception {
        this.ip = ip;
        this.header = new Header();
        this.header.nextPayload = Payload.TIMESTAMP;
        this.timestamp = new Timestamp();
        this.timestamp.nextPayload = Payload.RAND;
        this.rand = new Rand();
        this.rand.nextPayload = Payload.SECURITY_POLICY;
        this.securityPolicy = new SecurityPolicy();
        this.securityPolicy.nextPayload = Payload.KEMAC;
        this.keyDataTransportPayload = new KeyDataTransportPayload();
        this.keyDataTransportPayload.nextPayload = Payload.LAST;
    }

    public Mikey(String ip, String inputString) {
        this.ip = ip;
        try {
            this.logger = LogManager.getLogger((String)this.getClass().getName());
            byte[] mikeyData = Base64.getDecoder().decode(inputString.trim());
            int pointer = 0;
            this.header = new Header(mikeyData);
            pointer += this.header.getLength();
            Payload payload = this.header.getNextPayload();
            while (pointer < mikeyData.length && payload != Payload.LAST) {
                byte[] data = new byte[mikeyData.length - pointer];
                System.arraycopy(mikeyData, pointer, data, 0, data.length);
                switch (payload) {
                    case TIMESTAMP: {
                        this.timestamp = new Timestamp(data);
                        pointer += this.timestamp.length;
                        payload = this.timestamp.getNextPayload();
                        break;
                    }
                    case RAND: {
                        this.rand = new Rand(data);
                        pointer += this.rand.length;
                        payload = this.rand.getNextPayload();
                        break;
                    }
                    case SECURITY_POLICY: {
                        this.securityPolicy = new SecurityPolicy(data);
                        pointer += this.securityPolicy.length;
                        payload = this.securityPolicy.getNextPayload();
                        break;
                    }
                    case KEMAC: {
                        this.keyDataTransportPayload = new KeyDataTransportPayload(data);
                        pointer += this.keyDataTransportPayload.length;
                        payload = this.keyDataTransportPayload.getNextPayload();
                        break;
                    }
                    case LAST: {
                        break;
                    }
                }
            }
        }
        catch (Exception ex) {
            this.logger.warn("Exception while reading key for SRTP streaming for " + this.ip + " : " + ex.getMessage());
        }
    }

    public static byte[] generateKey() {
        return Mikey.generateRandomByteArray(30);
    }

    public static byte[] generateCryptoSessionBundle() {
        return Mikey.generateRandomByteArray(4);
    }

    public static byte[] generateSsrc() {
        return Mikey.generateRandomByteArray(4);
    }

    public static byte[] generateRandomByteArray(int length) {
        byte[] key = new byte[length];
        for (int i = 0; i < length; ++i) {
            byte b;
            key[i] = b = (byte)(Math.random() * 128.0);
        }
        return key;
    }

    public Header getHeader() {
        return this.header;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public Rand getRand() {
        return this.rand;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this.securityPolicy;
    }

    public KeyDataTransportPayload getKeyDataTransportPayload() {
        return this.keyDataTransportPayload;
    }

    public String toBase64String() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            MikeySegment mikeySegment = this.header;
            baos.write(this.header.getData());
            while (mikeySegment.nextPayload != Payload.LAST) {
                switch (mikeySegment.nextPayload) {
                    case KEMAC: {
                        mikeySegment = this.keyDataTransportPayload;
                        break;
                    }
                    case TIMESTAMP: {
                        mikeySegment = this.timestamp;
                        break;
                    }
                    case SECURITY_POLICY: {
                        mikeySegment = this.securityPolicy;
                        break;
                    }
                    case RAND: {
                        mikeySegment = this.rand;
                        break;
                    }
                }
                baos.write(((MikeySegment)mikeySegment).getData());
            }
            baos.write(0);
        }
        catch (Exception ex) {
            this.logger.error("Exception while converting MIKEY data to Base64 for " + this.ip);
        }
        return Base64.getEncoder().encodeToString(baos.toByteArray());
    }
}

