/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net.rtsp.mikey;

import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.EncryptionAlgorithm;
import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.KeyDataSubPayload;
import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.MikeySegment;
import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.Payload;
import de.seetec.v5.shared.Basic;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class KeyDataTransportPayload
extends MikeySegment {
    private EncryptionAlgorithm encryptionAlgorithm = EncryptionAlgorithm.AES_CM;
    private final int encryptionDataLength;
    private List<KeyDataSubPayload> keyDataSubPayloads;

    public KeyDataTransportPayload() {
        this.encryptionAlgorithm = EncryptionAlgorithm.NULL;
        this.encryptionDataLength = 25;
        KeyDataSubPayload keyDataSubPayload = new KeyDataSubPayload();
        keyDataSubPayload.nextPayload = Payload.LAST;
        this.keyDataSubPayloads = new ArrayList<KeyDataSubPayload>();
        this.keyDataSubPayloads.add(keyDataSubPayload);
    }

    public KeyDataTransportPayload(byte[] input) {
        int pointer;
        KeyDataSubPayload keyDataSubPayload;
        this.nextPayload = Payload.getPayloadByNumber(input[0]);
        if (EncryptionAlgorithm.getEncryptionAlgorithmByNumber(input[1]) != null) {
            this.encryptionAlgorithm = EncryptionAlgorithm.getEncryptionAlgorithmByNumber(input[1]);
        }
        this.encryptionDataLength = Basic.byteArrayToInt4((byte[])input, (int)2, (int)2);
        this.keyDataSubPayloads = new ArrayList<KeyDataSubPayload>();
        for (pointer = 4; pointer < 4 + this.encryptionDataLength; pointer += keyDataSubPayload.length) {
            byte[] subPayloadData = new byte[input.length - 4];
            System.arraycopy(input, 4, subPayloadData, 0, subPayloadData.length);
            keyDataSubPayload = new KeyDataSubPayload(subPayloadData);
            this.keyDataSubPayloads.add(keyDataSubPayload);
        }
        this.length = pointer;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public int getEncryptionDataLength() {
        return this.keyDataSubPayloads.get(0).getLength();
    }

    public List<KeyDataSubPayload> getKeyDataSubPayloads() {
        return this.keyDataSubPayloads;
    }

    public void setEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public void setKeyDataSubPayloads(List<KeyDataSubPayload> keyDataSubPayloads) {
        this.keyDataSubPayloads = keyDataSubPayloads;
    }

    @Override
    public byte[] getData() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.nextPayload.getType());
        baos.write(this.encryptionAlgorithm.getType());
        baos.write(Basic.int4ToByteArray((int)this.getEncryptionDataLength(), (int)2));
        for (KeyDataSubPayload keyDataSubPayload : this.keyDataSubPayloads) {
            baos.write(keyDataSubPayload.getData());
        }
        return baos.toByteArray();
    }

    public String toString() {
        String ret = "KEMAC: \r\n\tNext Payload: " + (Object)((Object)this.nextPayload) + "\r\n" + "\tEncryption Algorithm: " + (Object)((Object)this.encryptionAlgorithm) + "\r\n" + "\tEncryption data length: " + this.getEncryptionDataLength() + "\r\n" + "\tKey Data Sub Payloads: " + "\r\n";
        for (KeyDataSubPayload keyDataSubPayload : this.keyDataSubPayloads) {
            ret = ret + keyDataSubPayload.toString();
        }
        return ret;
    }
}

