/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net.rtsp.mikey;

import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.KeyType;
import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.KeyValidityIntervall;
import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.MikeySegment;
import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.Payload;
import de.seetec.v5.shared.Basic;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Random;

public class KeyDataSubPayload
extends MikeySegment {
    private final KeyType keyType;
    private KeyValidityIntervall keyValidityIntervall;
    private final int keyDataLength;
    private byte[] key;
    private int mkiLength = 0;
    private byte[] mki = null;

    public KeyDataSubPayload() {
        this.keyType = KeyType.getKeyTypeByNumber(2);
        this.keyValidityIntervall = KeyValidityIntervall.SPI;
        this.keyDataLength = 30;
        this.key = new byte[this.keyDataLength];
        new Random().nextBytes(this.key);
        if (this.keyValidityIntervall != KeyValidityIntervall.NULL) {
            this.mkiLength = 4;
            this.mki = new byte[this.mkiLength];
            this.length += 1 + this.mkiLength;
        }
    }

    public KeyDataSubPayload(byte[] input) {
        this.nextPayload = Payload.getPayloadByNumber(input[0]);
        this.keyType = KeyType.getKeyTypeByNumber(input[1] >>> 4);
        this.keyValidityIntervall = KeyValidityIntervall.getKeyValidityIntervallByNumber(input[1] & 0xF);
        this.keyDataLength = Basic.byteArrayToInt4((byte[])input, (int)2, (int)2);
        this.key = new byte[this.keyDataLength];
        System.arraycopy(input, 4, this.key, 0, this.key.length);
        this.length = 4 + this.keyDataLength;
        if (this.keyValidityIntervall != KeyValidityIntervall.NULL) {
            this.mkiLength = input[4 + this.keyDataLength];
            this.mki = new byte[this.mkiLength];
            System.arraycopy(input, 4 + this.keyDataLength + 1, this.mki, 0, this.mki.length);
            this.length += 1 + this.mkiLength;
        }
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public KeyValidityIntervall getKeyValidityIntervall() {
        return this.keyValidityIntervall;
    }

    public int getKeyDataLength() {
        return this.keyDataLength;
    }

    public byte[] getKey() {
        return this.key;
    }

    public void setKey(byte[] key) {
        this.key = key;
    }

    public int getMkiLength() {
        return this.mkiLength;
    }

    public byte[] getMki() {
        return this.mki;
    }

    public void setMki(byte[] mki) {
        this.mki = mki;
        this.keyValidityIntervall = KeyValidityIntervall.SPI;
        this.mkiLength = mki.length;
    }

    public byte[] getMasterKey() {
        byte[] masterKey = new byte[16];
        System.arraycopy(this.key, 0, masterKey, 0, 16);
        return masterKey;
    }

    public byte[] getMasterSalt() {
        byte[] masterSalt = new byte[14];
        System.arraycopy(this.key, 16, masterSalt, 0, 14);
        return masterSalt;
    }

    @Override
    public byte[] getData() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.nextPayload.getType());
        baos.write((byte)((byte)((byte)this.keyType.getType() << 4) | (byte)this.keyValidityIntervall.getType()));
        baos.write(Basic.int4ToByteArray((int)this.key.length, (int)2));
        baos.write(this.key);
        if (this.mki != null) {
            baos.write(this.mki.length);
            baos.write(this.mki);
        }
        return baos.toByteArray();
    }

    @Override
    public int getLength() {
        return 4 + this.key.length + (this.mki != null ? 1 + this.mki.length : 0);
    }

    public String toString() {
        String ret = "\tKey Data Sub Payload: \r\n\t\tNext Payload: " + (Object)((Object)this.nextPayload) + "\r\n" + "\t\tType: " + (Object)((Object)this.keyType) + "\r\n" + "\t\tKV: " + (Object)((Object)this.keyValidityIntervall) + "\r\n" + "\t\tKey Data Length: " + this.keyDataLength + "\r\n";
        if (this.mki != null) {
            ret = ret + "\t\tSPI/MKI length: " + this.mki.length + "\r\n" + "\t\tSPI/MKI Value: " + Basic.byteArrayToHexString((byte[])this.mki) + "\r\n";
        }
        return ret;
    }
}

