/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net.rtsp.mikey;

import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.CryptoSession;
import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.MikeySegment;
import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.Payload;
import de.seetec.v5.shared.Basic;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class Header
extends MikeySegment {
    private byte version;
    private byte dataType;
    private boolean verify;
    private byte pseudoRandomFunction;
    private byte[] cryptoSessionBundleId;
    private int numberOfCryptoSessions;
    private byte cryptoSessionIdMapType;
    private List<CryptoSession> cryptoSessions;

    public Header() throws Exception {
        this.version = 1;
        this.dataType = 0;
        this.verify = false;
        this.pseudoRandomFunction = 0;
        this.cryptoSessionBundleId = new byte[4];
        new Random().nextBytes(this.cryptoSessionBundleId);
        this.numberOfCryptoSessions = 1;
        this.cryptoSessionIdMapType = 0;
        this.cryptoSessions = new ArrayList<CryptoSession>();
        CryptoSession cryptoSession = new CryptoSession();
        this.cryptoSessions.add(cryptoSession);
        this.length = 10 + 9 * this.numberOfCryptoSessions;
    }

    public Header(byte[] input) throws Exception {
        this.version = input[0];
        this.dataType = input[1];
        this.nextPayload = Payload.getPayloadByNumber(input[2]);
        this.verify = (input[3] & 0xFFFFFF80) == 128;
        this.pseudoRandomFunction = (byte)(input[3] & 0x7F);
        this.cryptoSessionBundleId = new byte[4];
        System.arraycopy(input, 4, this.cryptoSessionBundleId, 0, 4);
        this.numberOfCryptoSessions = input[8];
        this.cryptoSessionIdMapType = input[9];
        this.cryptoSessions = new ArrayList<CryptoSession>();
        for (int i = 0; i < this.numberOfCryptoSessions; ++i) {
            byte[] cryptoSessionData = new byte[9];
            System.arraycopy(input, 10 + i * 9, cryptoSessionData, 0, 9);
            CryptoSession cryptoSession = new CryptoSession(cryptoSessionData);
            this.cryptoSessions.add(cryptoSession);
        }
        this.length = 10 + 9 * this.numberOfCryptoSessions;
    }

    public byte getVersion() {
        return this.version;
    }

    public byte getDataType() {
        return this.dataType;
    }

    public boolean isVerify() {
        return this.verify;
    }

    public byte getPseudoRandomFunction() {
        return this.pseudoRandomFunction;
    }

    public byte[] getCryptoSessionBundleId() {
        return this.cryptoSessionBundleId;
    }

    public void setCryptoSessionBundleId(byte[] cryptoSessionBundleId) {
        this.cryptoSessionBundleId = cryptoSessionBundleId;
    }

    public int getNumberOfCryptoSessions() {
        return this.numberOfCryptoSessions;
    }

    public byte getCryptoSessionIdMapType() {
        return this.cryptoSessionIdMapType;
    }

    public List<CryptoSession> getCryptoSessions() {
        return this.cryptoSessions;
    }

    @Override
    public byte[] getData() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.version);
        baos.write(this.dataType);
        baos.write((byte)this.nextPayload.getType());
        baos.write(this.getPseudoRandomFunction() | (this.verify ? -128 : 0));
        baos.write(this.cryptoSessionBundleId);
        baos.write(this.numberOfCryptoSessions);
        baos.write(this.cryptoSessionIdMapType);
        for (CryptoSession cryptoSession : this.cryptoSessions) {
            baos.write(cryptoSession.getData());
        }
        return baos.toByteArray();
    }

    public String toString() {
        String ret = "Header: \r\n\tVersion: " + this.version + "\r\n" + "\tData type: " + this.dataType + "\r\n" + "\tNext Payload: " + (Object)((Object)this.nextPayload) + "\r\n" + "\tVerify: " + this.verify + "\r\n" + "\tPseudo Random Function: " + this.pseudoRandomFunction + "\r\n" + "\tCrypto Session Bundle: " + Basic.byteArrayToHexString((byte[])this.cryptoSessionBundleId) + "\r\n" + "\tNumber of Crypto Sessions: " + this.numberOfCryptoSessions + "\r\n" + "\tCrypto Session ID map type: " + this.cryptoSessionIdMapType + "\r\n";
        for (CryptoSession cryptoSession : this.cryptoSessions) {
            ret = ret + "Crypto session: \r\n\tPolicy Number: " + cryptoSession.getPolicyNumber() + "\r\n" + "\tSSRC: " + Basic.byteArrayToHexString((byte[])cryptoSession.getSynchronizationSource()) + "\r\n" + "\tRol over counter: " + Basic.byteArrayToHexString((byte[])cryptoSession.getRollOverCounter()) + "\r\n";
        }
        return ret;
    }
}

