/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net.rtsp.mikey;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class CryptoSession {
    private int policyNumber;
    private byte[] synchronizationSource;
    private byte[] rollOverCounter;

    public CryptoSession() throws Exception {
        this.policyNumber = 0;
        this.synchronizationSource = new byte[4];
        this.rollOverCounter = new byte[4];
    }

    public CryptoSession(byte[] input) throws Exception {
        if (input.length != 9) {
            throw new Exception("Input data not valid for CryptoSession");
        }
        this.policyNumber = input[0];
        this.synchronizationSource = new byte[4];
        System.arraycopy(input, 1, this.synchronizationSource, 0, 4);
        this.rollOverCounter = new byte[4];
        System.arraycopy(input, 5, this.rollOverCounter, 0, 4);
    }

    public int getPolicyNumber() {
        return this.policyNumber;
    }

    public byte[] getSynchronizationSource() {
        return this.synchronizationSource;
    }

    public byte[] getRollOverCounter() {
        return this.rollOverCounter;
    }

    public byte[] getData() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.policyNumber);
        baos.write(this.synchronizationSource);
        baos.write(this.rollOverCounter);
        return baos.toByteArray();
    }

    public void setSsrc(byte[] ssrc) {
        this.synchronizationSource = ssrc;
    }
}

