/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net.rtsp;

public class SdpVideoData {
    private String control;
    private String rtpmap;
    private final String data;
    private boolean containsThumbnailData = false;

    SdpVideoData(String inputData) {
        String[] contentLines;
        if (inputData == null) {
            throw new IllegalArgumentException();
        }
        this.data = inputData;
        for (String contentLine : contentLines = inputData.split("\r\n")) {
            if (contentLine.startsWith("a=control:")) {
                this.control = contentLine.replace("a=control:", "");
                continue;
            }
            if (contentLine.startsWith("a=rtpmap:")) {
                this.rtpmap = contentLine.replace("a=rtpmap:", "");
                continue;
            }
            if (!contentLine.toLowerCase().contains("i=metaimagesession")) continue;
            this.containsThumbnailData = true;
        }
    }

    public String getControl() {
        return this.control;
    }

    public String getRtpmap() {
        return this.rtpmap;
    }

    public boolean containsThumbnailData() {
        return this.containsThumbnailData;
    }

    public String toString() {
        return this.data;
    }
}

