/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net.rtsp;

import de.seetec.v5.re.cm.device.shared.net.rtp.RtpSenderPacket;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerSuper;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPRequest;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPResponse;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.RTSPStatusCode;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;

@SuppressFBWarnings(value={"UNENCRYPTED_SOCKET"}, justification="No encryption possible for RTSP 1.")
public class RTSPHandlerTCP
extends RTSPHandlerSuper {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerTCP";
    private byte[] array = null;
    private final byte[] buffer = new byte[4096];
    private int bytesRead = 0;
    private int contentLength = -1;
    private Thread myThread = null;
    private int channelIdentifier = -1;
    private Socket socket;
    private InputStream inputStream;
    private OutputStream outputStream;
    private String host;
    private int tcpVideoChannel = Integer.MIN_VALUE;
    private int tcpAudioChannel = Integer.MIN_VALUE;
    private int tcpMetadataChannel = Integer.MIN_VALUE;
    private int tcpBackChannel = Integer.MIN_VALUE;
    private RTSPResponse rtspResponse;
    private int rtspPort;

    public RTSPHandlerTCP() {
        this.shutdown = false;
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public int init(RTSPStreamSettings rtspSettings) {
        this.rtspSettings = rtspSettings;
        this.networkParameter = rtspSettings.getNetworkParameter();
        this.host = this.rtspSettings.getRtspHost() != null ? this.rtspSettings.getRtspHost() : this.networkParameter.getHost();
        this.rtspPort = rtspSettings.getRTSPPort() != -1 ? rtspSettings.getRTSPPort() : 554;
        this.audioHandlerCallback = rtspSettings.getAudioHandlerCallback();
        this.metadataHandlerCallback = rtspSettings.getMetadataHandlerCallback();
        this.backChannelCallback = rtspSettings.getBackChannelCallback();
        this.callback = rtspSettings.getCallback();
        this.isAudioEnabled = rtspSettings.isIsAudioEnabled();
        this.isMetadataEnabled = rtspSettings.isMetadataEnabled();
        this.isBackChannelEnabled = rtspSettings.isIsBackChannelEnabled();
        this.basicAuthenticationDisabled = rtspSettings.isBasicAuthenticationDisabled();
        try {
            this.socket = new Socket(this.host, this.rtspPort);
            this.socket.setSoTimeout(this.rtspSettings.getTimeOut());
            this.socket.setReceiveBufferSize(262144);
            this.socket.setSendBufferSize(262144);
            this.inputStream = this.socket.getInputStream();
            this.outputStream = this.socket.getOutputStream();
        }
        catch (UnknownHostException ex) {
            this.logger.error("Error creating socket for " + this + " : " + ex.getMessage());
            return -21603;
        }
        catch (IOException ex) {
            this.logger.error("Error creating socket for " + this + " : " + ex.getMessage());
            return -21603;
        }
        return 0;
    }

    public void readStream() {
        if (this.shutdown) {
            return;
        }
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while (!this.shutdown) {
                int counter = 0;
                while (baos.size() < 4 && counter < 4) {
                    this.bytesRead = this.inputStream.read(this.buffer);
                    if (this.bytesRead < 0) {
                        this.logger.error("Error reading from RTSP stream.");
                        this.callback.onNetworkError(-21656);
                        return;
                    }
                    baos.write(this.buffer, 0, this.bytesRead);
                }
                if (baos.size() < 4) {
                    this.callback.onNetworkError(-21656);
                    return;
                }
                this.array = baos.toByteArray();
                if (Basic.indexOfByteArray((byte[])this.array, (byte[])"RTSP/1.0".getBytes(), (int)0, (boolean)true) == 0) {
                    int endIndex = -1;
                    while ((endIndex = this.indexOfByteArrayOutputStream(baos, DOUBLE_CRLF_BYTE, 0, false)) < 0) {
                        this.bytesRead = this.inputStream.read(this.buffer);
                        if (this.bytesRead <= 0) continue;
                        baos.write(this.buffer, 0, this.bytesRead);
                    }
                    String header = new String(baos.toByteArray());
                    if (header.toLowerCase().contains("content-length:")) {
                        String[] headerLines;
                        int length = -1;
                        for (String headerLine : headerLines = header.split("\r\n")) {
                            if (!headerLine.toLowerCase().contains("content-length:")) continue;
                            length = Integer.parseInt(headerLine.substring(headerLine.toLowerCase().indexOf("content-length:") + "content-length:".length()).trim());
                            break;
                        }
                        if (length == -1) {
                            this.logger.error("Content Length not found");
                            return;
                        }
                        while (baos.size() < length) {
                            this.bytesRead = this.inputStream.read(this.buffer);
                            if (this.bytesRead <= 0) continue;
                            baos.write(this.buffer, 0, this.bytesRead);
                        }
                        endIndex += length;
                    }
                    this.array = baos.toByteArray();
                    baos.reset();
                    byte[] rtspPackage = Arrays.copyOfRange(this.array, 0, endIndex);
                    baos.write(this.array, endIndex, this.array.length - endIndex);
                    this.rtspResponse = new RTSPResponse(rtspPackage, this.rtspSettings);
                    if (this.rtspResponse.getErrorCode() == RTSPStatusCode.RTSP_UNSUPPORTED_TRANSPORT.getStatusCode()) {
                        this.callback.onNetworkError(-21659);
                    }
                    if (this.rtspResponse.getChannelIdentifier() == -1) continue;
                    if (this.isMetadataEnabled) {
                        this.tcpMetadataChannel = this.rtspResponse.getChannelIdentifier();
                        continue;
                    }
                    if (this.isAudioEnabled) {
                        this.tcpAudioChannel = this.rtspResponse.getChannelIdentifier();
                        continue;
                    }
                    if (this.isBackChannelEnabled) {
                        this.tcpBackChannel = this.rtspResponse.getChannelIdentifier();
                        continue;
                    }
                    this.tcpVideoChannel = this.rtspResponse.getChannelIdentifier();
                    continue;
                }
                if (this.array[0] != 36) {
                    this.array = this.getStartOfFrame(this.array);
                    if (this.array.length == 0) {
                        baos.reset();
                        continue;
                    }
                    baos.reset();
                    baos.write(this.array);
                }
                this.channelIdentifier = this.array[1] & 0xFF;
                this.contentLength = Basic.byteArrayToInt4((byte[])Arrays.copyOfRange(this.array, 2, 4));
                while (baos.size() - 4 < this.contentLength) {
                    this.bytesRead = this.inputStream.read(this.buffer);
                    if (this.bytesRead < 0) {
                        this.logger.error("Could not read stream ");
                        this.callback.onNetworkError(-21656);
                        return;
                    }
                    baos.write(this.buffer, 0, this.bytesRead);
                    this.array = baos.toByteArray();
                }
                try {
                    byte[] content = Arrays.copyOfRange(this.array, 4, this.contentLength + 4);
                    if (this.channelIdentifier == this.tcpVideoChannel || this.channelIdentifier == this.tcpVideoChannel + 1) {
                        this.callback.processData(content);
                    } else if (this.channelIdentifier == this.tcpAudioChannel || this.channelIdentifier == this.tcpAudioChannel + 1) {
                        this.audioHandlerCallback.processData(content);
                    } else if (this.channelIdentifier == this.tcpMetadataChannel || this.channelIdentifier == this.tcpMetadataChannel + 1) {
                        this.metadataHandlerCallback.processData(content);
                    } else if (this.channelIdentifier == this.tcpBackChannel || this.channelIdentifier == this.tcpBackChannel + 1) {
                        this.backChannelCallback.processData(content);
                    }
                    baos.reset();
                    baos.write(this.array, this.contentLength + 4, this.array.length - (this.contentLength + 4));
                }
                catch (IndexOutOfBoundsException e) {
                    this.logger.error("Error filling data array: " + e);
                    this.callback.onNetworkError(-21656);
                    return;
                }
            }
        }
        catch (SocketTimeoutException ste) {
            this.logger.warn("SOTimeout reached. Aborting RTSPHandler: " + ste);
            this.callback.onNetworkError(-21656);
            return;
        }
        catch (SocketException se) {
            if (this.shutdown) {
                this.logger.info("Socket Exception occured while shutting down stream: " + se);
                return;
            } else {
                this.logger.error("Exception writing to network", (Throwable)se);
                this.callback.onNetworkError(-21656);
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.logger.error("Exception writing array");
            this.callback.onNetworkError(-21656);
            return;
        }
        catch (Exception e) {
            this.logger.error("Exception writing to network: " + e.getMessage());
            this.callback.onNetworkError(-21656);
        }
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
        super.shutdown();
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException ex) {
            this.logger.warn("Could not close socket");
        }
    }

    @Override
    protected RTSPResponse sendRTSPPacket(RTSPRequest request) {
        request.setSequenceNumber(this.sequenceNumber++);
        long waitingSince = System.currentTimeMillis();
        try {
            this.isAudioEnabled = request.isIsAudioSetup();
            this.isMetadataEnabled = request.isMetadataSetup();
            this.outputStream.write(request.serialize());
            while (this.rtspResponse == null && !this.shutdown) {
                try {
                    Thread.sleep(100L);
                    if (this.rtspSettings.isPrintDebug()) {
                        this.logger.info("Waiting for RTSP response...");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (waitingSince + (long)this.networkParameter.getSoTimeout() >= System.currentTimeMillis()) continue;
                this.logger.warn("No answer reached for tunneled RTSP request. Aborting for " + this.callback);
                this.logger.fatal("Assure that Antivirus WebGuard and stuff like that is switched off!!!");
                break;
            }
        }
        catch (IOException ex) {
            this.logger.error("Exception while reading TCP data for " + this + " : " + ex.getMessage());
        }
        RTSPResponse ret = this.rtspResponse;
        this.rtspResponse = null;
        return ret;
    }

    @Override
    public int start() {
        this.myThread = new Thread((Runnable)this, CLASS_NAME);
        this.myThread.start();
        return super.start();
    }

    @Override
    public int sendReceiverReportAudio(byte[] receiverReport) {
        if (receiverReport != null) {
            this.setReceiverReportAudio(new byte[receiverReport.length]);
            System.arraycopy(receiverReport, 0, this.getReceiverReportAudio(), 0, receiverReport.length);
        }
        return this.sendReceiverReport(this.getReceiverReportAudio(), this.tcpAudioChannel + 1);
    }

    @Override
    public int sendReceiverReportMetadata(byte[] receiverReport) {
        if (receiverReport != null) {
            this.setReceiverReportMetadata(new byte[receiverReport.length]);
            System.arraycopy(receiverReport, 0, this.getReceiverReportMetadata(), 0, receiverReport.length);
        }
        return this.sendReceiverReport(this.getReceiverReportMetadata(), this.tcpMetadataChannel + 1);
    }

    @Override
    public int sendReceiverReportVideo(byte[] receiverReport) {
        if (receiverReport != null) {
            this.setReceiverReportVideo(new byte[receiverReport.length]);
            System.arraycopy(receiverReport, 0, this.getReceiverReportVideo(), 0, receiverReport.length);
        }
        return this.sendReceiverReport(this.getReceiverReportVideo(), this.tcpVideoChannel + 1);
    }

    @Override
    public int sendRTPPacket(RtpSenderPacket rtpData) {
        try {
            byte[] rtpPacket = new byte[rtpData.getData().length + 4];
            rtpPacket[0] = 36;
            rtpPacket[1] = (byte)this.tcpBackChannel;
            byte[] length = Basic.int4ToByteArray((int)rtpData.getData().length);
            System.arraycopy(length, 2, rtpPacket, 2, 2);
            System.arraycopy(rtpData.getData(), 0, rtpPacket, 4, rtpData.getData().length);
            this.outputStream.write(rtpPacket);
        }
        catch (Exception ex) {
            return -20100;
        }
        return 0;
    }

    private byte[] getStartOfFrame(byte[] array) {
        for (int i = 0; i < array.length - 4; ++i) {
            int length;
            byte channel;
            if (array[i] != 36 || !this.belongsTo(channel = array[i + 1]) || (length = Basic.byteArrayToInt4((byte[])Arrays.copyOfRange(array, i + 2, i + 4))) <= 0) continue;
            return Arrays.copyOfRange(array, i, array.length);
        }
        return new byte[0];
    }

    private boolean belongsTo(int i) {
        return i == this.tcpVideoChannel || i == this.tcpVideoChannel + 1 || i == this.tcpAudioChannel || i == this.tcpAudioChannel + 1 || i == this.tcpMetadataChannel || i == this.tcpMetadataChannel + 1;
    }

    private int sendReceiverReport(byte[] receiverReport, int channel) {
        try {
            byte[] completeReceiverReport = new byte[receiverReport.length + 4];
            completeReceiverReport[0] = 36;
            completeReceiverReport[1] = (byte)channel;
            byte[] length = Basic.int4ToByteArray((int)receiverReport.length);
            System.arraycopy(length, 2, completeReceiverReport, 2, 2);
            System.arraycopy(receiverReport, 0, completeReceiverReport, 4, receiverReport.length);
            this.outputStream.write(completeReceiverReport);
        }
        catch (IOException ex) {
            this.logger.error("Exception while sending receiver report for " + this.callback + " : " + ex.getMessage());
            return -21656;
        }
        return 0;
    }
}

