/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net.rtsp;

import de.seetec.v5.re.cm.device.shared.net.rtp.RtpSenderPacket;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPConstantsIntf;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerIntf;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPRequest;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPResponse;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.net.rtsp.SDPContent;
import de.seetec.v5.re.cm.device.shared.net.rtsp.SdpAudioData;
import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.Mikey;
import de.seetec.v5.re.cm.device.shared.net.rtsp.request.DescribeRequest;
import de.seetec.v5.re.cm.device.shared.net.rtsp.request.GetParameterRequest;
import de.seetec.v5.re.cm.device.shared.net.rtsp.request.OptionsRequest;
import de.seetec.v5.re.cm.device.shared.net.rtsp.request.PlayRequest;
import de.seetec.v5.re.cm.device.shared.net.rtsp.request.SetupRequest;
import de.seetec.v5.re.cm.device.shared.net.rtsp.request.TeardownRequest;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelper;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelperH264;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.SSLConstantsIntf;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.RTSPStatusCode;
import de.seetec.v5.shared.util.SeeTecException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;

public abstract class RTSPHandlerSuper
implements SSLConstantsIntf,
RTSPConstantsIntf,
Runnable {
    protected static final String CONTENT_LENGTH = "content-length:";
    protected Logger logger = null;
    protected boolean shutdown;
    protected NetworkParameter networkParameter;
    protected RTSPHandlerIntf callback;
    protected RTSPHandlerIntf audioHandlerCallback;
    protected RTSPHandlerIntf metadataHandlerCallback;
    protected RTSPHandlerIntf backChannelCallback;
    protected int keepAliveInterval;
    protected KeepAliveReader keepAliveReader;
    protected RTSPStreamSettings rtspSettings;
    protected String sessionID;
    protected int sequenceNumber = 1;
    protected boolean isAudioEnabled = false;
    protected boolean isMetadataEnabled = false;
    protected boolean isBackChannelEnabled = false;
    protected boolean printDebug;
    protected boolean basicAuthenticationDisabled;
    private byte[] receiverReportVideo;
    private byte[] receiverReportAudio;
    private byte[] receiverReportMetadata;
    private Integer keepAliveMethod;
    private String keepAliveUrl;
    private int authenticationMethod = -1;
    private String passPhrase;
    private String contentBase;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="It is just a byte array, without any critical internal representation.")
    public byte[] getReceiverReportVideo() {
        return this.receiverReportVideo;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="It is just a byte array, without any critical internal representation.")
    public void setReceiverReportVideo(byte[] receiverReportVideo) {
        this.receiverReportVideo = receiverReportVideo;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="It is just a byte array, without any critical internal representation.")
    public byte[] getReceiverReportAudio() {
        return this.receiverReportAudio;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="It is just a byte array, without any critical internal representation.")
    public void setReceiverReportAudio(byte[] receiverReportAudio) {
        this.receiverReportAudio = receiverReportAudio;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="It is just a byte array, without any critical internal representation.")
    public byte[] getReceiverReportMetadata() {
        return this.receiverReportMetadata;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="It is just a byte array, without any critical internal representation.")
    public void setReceiverReportMetadata(byte[] receiverReportMetadata) {
        this.receiverReportMetadata = receiverReportMetadata;
    }

    public abstract int init(RTSPStreamSettings var1);

    protected abstract RTSPResponse sendRTSPPacket(RTSPRequest var1);

    public abstract int sendReceiverReportVideo(byte[] var1);

    public int sendReceiverReportVideo() {
        return this.sendReceiverReportVideo(this.receiverReportVideo);
    }

    public abstract int sendReceiverReportAudio(byte[] var1);

    public int sendReceiverReportAudio() {
        return this.sendReceiverReportAudio(this.receiverReportAudio);
    }

    public abstract int sendReceiverReportMetadata(byte[] var1);

    public int sendReceiverReportMetadata() {
        return this.sendReceiverReportMetadata(this.receiverReportMetadata);
    }

    public abstract int sendRTPPacket(RtpSenderPacket var1);

    protected int indexOfByteArrayOutputStream(ByteArrayOutputStream baos, byte[] pattern, int offset, boolean returnIndexBeforePattern) {
        return Basic.indexOfByteArray((byte[])baos.toByteArray(), (byte[])pattern, (int)offset, (boolean)returnIndexBeforePattern);
    }

    public RTSPResponse sendRTSPRequest(RTSPRequest request) throws SeeTecException {
        RTSPResponse packetResponse;
        if (this.printDebug) {
            this.logger.info("Request for " + this.callback + ":\r\n" + request.getData());
        }
        if (this.sessionID != null) {
            request.setSessionID(this.sessionID);
        }
        request.init();
        if (this.authenticationMethod != -1) {
            try {
                if (this.authenticationMethod == 100 || this.authenticationMethod == 102 && this.networkParameter.getRealm() == null && this.networkParameter.getNonce() == null) {
                    if (!this.basicAuthenticationDisabled) {
                        this.passPhrase = NetworkHelper.createBasicAuthorization((NetworkParameter)this.networkParameter);
                        request.setPassPhrase(this.passPhrase);
                    }
                } else if ((this.authenticationMethod == 102 || this.authenticationMethod == 101) && this.networkParameter.getRealm() != null && this.networkParameter.getNonce() != null) {
                    this.passPhrase = NetworkHelper.createDigestAuthorization((NetworkParameter)this.networkParameter, (String)this.networkParameter.getRealm(), (String)this.networkParameter.getNonce(), (String)this.getCommandString(request.getCommand()), (String)request.getUrl());
                    request.setPassPhrase(this.passPhrase);
                    request.init();
                }
            }
            catch (Exception ex) {
                this.logger.error("Exception while creating Authentication for " + this.callback);
            }
        }
        if ((packetResponse = this.sendRTSPPacket(request)) == null) {
            throw new SeeTecException(-20100, "No RTSP answer received for url " + request.getUrl());
        }
        if (packetResponse.getErrorCode() == RTSPStatusCode.RTSP_UNAUTHORIZED.getStatusCode()) {
            try {
                this.authenticationMethod = packetResponse.getAuthenticationMethod();
                this.networkParameter.setRealm(packetResponse.getRealm());
                this.networkParameter.setNonce(packetResponse.getNonce());
                if (this.authenticationMethod == 100) {
                    this.passPhrase = NetworkHelper.createBasicAuthorization((NetworkParameter)this.networkParameter);
                    request.setPassPhrase(this.passPhrase);
                    request.init();
                    packetResponse = this.sendRTSPPacket(request);
                    if (packetResponse != null && packetResponse.getErrorCode() != RTSPStatusCode.RTSP_UNAUTHORIZED.getStatusCode()) {
                        return packetResponse;
                    }
                }
                if (this.authenticationMethod == 101 || this.authenticationMethod == 102) {
                    this.passPhrase = NetworkHelper.createDigestAuthorization((NetworkParameter)this.networkParameter, (String)this.networkParameter.getRealm(), (String)this.networkParameter.getNonce(), (String)this.getCommandString(request.getCommand()), (String)request.getUrl());
                    request.setPassPhrase(this.passPhrase);
                    request.init();
                    packetResponse = this.sendRTSPPacket(request);
                    if (packetResponse != null) {
                        if (packetResponse.getErrorCode() == RTSPStatusCode.RTSP_UNAUTHORIZED.getStatusCode()) {
                            return new RTSPResponse(-21657);
                        }
                        return packetResponse;
                    }
                }
            }
            catch (Exception ex) {
                this.logger.error("Exception while creating Authentication for " + this.callback + " : " + ex.getMessage());
            }
        }
        return packetResponse;
    }

    protected String getBackChannelURL(String mediaType, String data, String contentBase) {
        String[] sdpLines = data.split("\r\n");
        String control = "";
        boolean sendonlyFound = false;
        for (String sdpLine : sdpLines) {
            if (sdpLine.contains("m=" + mediaType)) {
                control = "";
            } else if (sdpLine.contains("a=control:")) {
                control = sdpLine.replace("a=control:", "");
            }
            if (sdpLine.contains("a=sendonly")) {
                sendonlyFound = true;
            }
            if (!sendonlyFound || control.isEmpty()) continue;
            if (!control.toLowerCase().contains("rtsp://") && contentBase != null) {
                control = contentBase + "/" + control;
            }
            control = control.replace("//", "/").replace("//", "/").replace("rtsp:/", "rtsp://");
            return control;
        }
        return "";
    }

    public int start() {
        int errorCode;
        try {
            RTSPResponse describeResponse;
            String rtspUrl = this.rtspSettings.getRtspUrl();
            this.passPhrase = this.rtspSettings.isBasicAuthenticationDisabled() ? "" : NetworkHelper.createBasicAuthorization((NetworkParameter)this.rtspSettings.getNetworkParameter());
            OptionsRequest optionsReq = new OptionsRequest();
            optionsReq.setPassPhrase(this.passPhrase);
            optionsReq.init(rtspUrl, this.rtspSettings);
            Object response = this.sendRTSPRequest(optionsReq);
            if (this.rtspSettings.isPrintDebug()) {
                this.logger.info("Answer to RTSP OPTIONS: " + ((RTSPResponse)response).getData());
            }
            if ((this.rtspSettings.getKeepAliveMethod() & 2) == 2) {
                boolean getParameterOffered = false;
                int[] options = ((RTSPResponse)response).getOptions();
                for (int i = 0; i < options.length; ++i) {
                    if (options[i] != 2) continue;
                    getParameterOffered = true;
                    break;
                }
                if (!getParameterOffered) {
                    this.rtspSettings.setKeepAliveMethod(this.rtspSettings.getKeepAliveMethod() & 0xFFFFFFFD);
                }
            }
            if (this.isShutdown()) {
                return -21659;
            }
            DescribeRequest describeReq = new DescribeRequest();
            describeReq.init(rtspUrl, this.rtspSettings);
            int numberOfTries = this.rtspSettings.getCheckResolutionTries();
            int widthOnCamera = 0;
            int heightOnCamera = 0;
            int counter = 0;
            boolean resolutionMatches = true;
            do {
                ++counter;
                response = this.sendRTSPRequest(describeReq);
                describeResponse = response;
                if (this.rtspSettings.isPrintDebug()) {
                    this.logger.info("Answer to RTSP DESCRIBE: " + ((RTSPResponse)response).getData());
                }
                if (!this.rtspSettings.isVideoEnabled()) {
                    this.callback.sendDescribeResponse((RTSPResponse)response);
                    break;
                }
                if ((((RTSPResponse)response).getCodec() != null && ((RTSPResponse)response).getCodec() == Codec.H264 || this.rtspSettings.getCodec() != null && this.rtspSettings.getCodec().equals((Object)Codec.H264)) && ((RTSPResponse)response).getPictureParameterSet().length > 0 && ((RTSPResponse)response).getSequenceParameterSet().length > 0) {
                    byte[] pictureParameterSet = ((RTSPResponse)response).getPictureParameterSet();
                    byte[] sequenceParameterSet = ((RTSPResponse)response).getSequenceParameterSet();
                    byte[] parameterSet = new byte[pictureParameterSet.length + 3 + (sequenceParameterSet.length + 3)];
                    System.arraycopy(StreamingHelper.START_SEQUENCE, 0, parameterSet, 0, StreamingHelper.START_SEQUENCE.length);
                    System.arraycopy(sequenceParameterSet, 0, parameterSet, 3, sequenceParameterSet.length);
                    System.arraycopy(StreamingHelper.START_SEQUENCE, 0, parameterSet, 3 + sequenceParameterSet.length, StreamingHelper.START_SEQUENCE.length);
                    System.arraycopy(pictureParameterSet, 0, parameterSet, 3 + sequenceParameterSet.length + 3, pictureParameterSet.length);
                    int[] resolutionFromStream = StreamingHelperH264.extractH264Resolution(parameterSet);
                    if (resolutionFromStream != null) {
                        widthOnCamera = resolutionFromStream[0];
                        heightOnCamera = resolutionFromStream[1];
                    }
                    resolutionMatches = this.resolutionMatches(widthOnCamera, heightOnCamera, this.rtspSettings);
                    if (counter > 1) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (!resolutionMatches && this.rtspSettings.getResolution().length > 1) {
                            int width = this.rtspSettings.getResolution()[0];
                            int height = this.rtspSettings.getResolution()[1];
                            this.logger.info("Resolution on camera not set. Should be " + width + " x " + height + ", is " + widthOnCamera + " x " + heightOnCamera + ". Reading again...");
                        }
                    }
                }
                this.callback.sendDescribeResponse((RTSPResponse)response);
            } while (counter < numberOfTries && !resolutionMatches);
            if (this.rtspSettings.isVideoEnabled() && !resolutionMatches && this.rtspSettings.getResolution().length > 1) {
                int width = this.rtspSettings.getResolution()[0];
                int height = this.rtspSettings.getResolution()[1];
                this.logger.error("Could not set resolution " + width + "x" + height + ". Using resolution " + widthOnCamera + "x" + heightOnCamera + " instead.");
            }
            if (counter > 1 && this.rtspSettings.getWaitingTime() > 0L) {
                Thread.sleep(this.rtspSettings.getWaitingTime());
            }
            List<String> videoSetupUrls = ((RTSPResponse)response).getSetupUrls("video", rtspUrl, this.networkParameter.getHost());
            List<String> audioSetupUrls = ((RTSPResponse)response).getSetupUrls("audio", rtspUrl, this.networkParameter.getHost());
            List<String> metadataSetupUrls = ((RTSPResponse)response).getSetupUrls("application", rtspUrl, this.networkParameter.getHost());
            this.contentBase = ((RTSPResponse)response).getContentBase();
            if (metadataSetupUrls == null) {
                metadataSetupUrls = ((RTSPResponse)response).getSetupUrls("metadata", rtspUrl, this.networkParameter.getHost());
            }
            String backChannelSetupUrl = "";
            if (this.rtspSettings.isIsBackChannelEnabled()) {
                backChannelSetupUrl = this.getBackChannelURL("audio", ((RTSPResponse)response).getData(), this.contentBase);
            }
            if ((errorCode = ((RTSPResponse)response).getErrorCode()) == RTSPStatusCode.RTSP_UNAUTHORIZED.getStatusCode()) {
                return -21665;
            }
            if (errorCode != RTSPStatusCode.RTSP_OK.getStatusCode()) {
                this.logger.error("Error while first RTSP request. errorCode: " + errorCode + " for " + this.callback);
                return -21659;
            }
            if (this.rtspSettings.haveToExecuteOperationAfterDescribe()) {
                this.rtspSettings.getStreamingVideoSourceClientRtsp().executeOperationAfterDescribe();
            }
            response = null;
            SetupRequest setupReq = new SetupRequest();
            if (this.rtspSettings.getTransmissionID() == TransmissionType.SRTP_OVER_UDP_UNICAST || this.rtspSettings.getTransmissionID() == TransmissionType.SRTP_OVER_UDP_MULTICAST) {
                if (describeResponse.getKey() != null) {
                    Mikey incomingMikey = new Mikey(this.networkParameter.getHost(), describeResponse.getKey());
                    this.callback.setMikey(incomingMikey);
                    if (!this.rtspSettings.isIsClientProvidingSrtpMasterKey()) {
                        this.rtspSettings.setMikey(incomingMikey);
                    }
                }
                if (this.rtspSettings.isIsClientProvidingSrtpMasterKey()) {
                    Mikey outgoingMikey = new Mikey(this.networkParameter.getHost());
                    this.callback.setMikey(outgoingMikey);
                    this.rtspSettings.setMikey(outgoingMikey);
                    this.logger.info("Starting SRTP stream for " + this.callback);
                }
            }
            for (String videoSetupUrl : videoSetupUrls) {
                if (this.rtspSettings.isVideoEnabled()) {
                    setupReq.setIsAudioSetup(false);
                    setupReq.init(videoSetupUrl, this.rtspSettings);
                    response = this.sendRTSPRequest(setupReq);
                    if (((RTSPResponse)response).getSessionID() != null) {
                        this.sessionID = ((RTSPResponse)response).getSessionID();
                    }
                }
                if (this.rtspSettings.isStartAllTrackIds()) continue;
                break;
            }
            if (audioSetupUrls.size() > 1 && this.rtspSettings.getAudioCodec() != null && !this.rtspSettings.isStartAllTrackIds()) {
                audioSetupUrls = RTSPHandlerSuper.selectAudioSetupUrl(describeResponse, audioSetupUrls, this.rtspSettings.getAudioCodec());
            }
            for (String audioSetupUrl : audioSetupUrls) {
                if (this.rtspSettings.isIsAudioEnabled() && !audioSetupUrl.equals(backChannelSetupUrl)) {
                    setupReq = new SetupRequest();
                    setupReq.setIsAudioSetup(true);
                    setupReq.init(audioSetupUrl, this.rtspSettings);
                    RTSPResponse rtspResponse = this.sendRTSPRequest(setupReq);
                    if (response == null) {
                        response = rtspResponse;
                    }
                    if (response != null && ((RTSPResponse)response).getSessionID() != null) {
                        this.sessionID = ((RTSPResponse)response).getSessionID();
                    }
                    if (this.rtspSettings.isPrintDebug() && rtspResponse != null) {
                        this.logger.info("Answer to RTSP SETUP (Audio): " + rtspResponse.getData());
                    }
                }
                if (this.rtspSettings.isStartAllTrackIds()) continue;
                break;
            }
            if (this.rtspSettings.isIsBackChannelEnabled() && !backChannelSetupUrl.isEmpty()) {
                setupReq = new SetupRequest();
                setupReq.setIsBackChannelSetup(true);
                setupReq.init(backChannelSetupUrl, this.rtspSettings);
                RTSPResponse rtspResponse = this.sendRTSPRequest(setupReq);
                if (response == null) {
                    response = rtspResponse;
                }
                if (rtspResponse.getErrorCode() == RTSPStatusCode.RTSP_UNSUPPORTED_TRANSPORT.getStatusCode() || rtspResponse.getErrorCode() == RTSPStatusCode.RTSP_SERVICE_UNAVAILABLE.getStatusCode()) {
                    TeardownRequest teardownRequest = new TeardownRequest();
                    teardownRequest.init(rtspUrl, this.rtspSettings);
                    this.sendRTSPRequest(teardownRequest);
                    return -21659;
                }
                if (this.rtspSettings.isPrintDebug()) {
                    this.logger.info("Answer to RTSP SETUP (Audio Backchannel): " + rtspResponse.getData());
                }
            }
            if (this.rtspSettings.isPrintDebug() && response != null) {
                this.logger.info("Answer to RTSP SETUP (Video): " + ((RTSPResponse)response).getData());
            }
            for (String metadataSetupUrl : metadataSetupUrls) {
                if (metadataSetupUrl != null && this.rtspSettings.isMetadataEnabled()) {
                    setupReq = new SetupRequest();
                    if (this.rtspSettings.getTransmissionID() == TransmissionType.SRTP_OVER_UDP_UNICAST && this.rtspSettings.isIsClientProvidingSrtpMasterKey()) {
                        Mikey outgoingMikey = new Mikey(this.networkParameter.getHost());
                        this.callback.setMikey(outgoingMikey);
                        this.rtspSettings.setMikey(outgoingMikey);
                    }
                    setupReq.setIsMetadataSetup(true);
                    setupReq.setIsAudioSetup(false);
                    setupReq.init(metadataSetupUrl, this.rtspSettings);
                    RTSPResponse rtspMetadataResponse = this.sendRTSPRequest(setupReq);
                    if (this.rtspSettings.isPrintDebug() && rtspMetadataResponse != null) {
                        this.logger.info("Answer to RTSP SETUP (Metadata): " + rtspMetadataResponse.getData());
                    }
                    if (response == null && rtspMetadataResponse != null) {
                        response = rtspMetadataResponse;
                    }
                }
                if (this.rtspSettings.isStartAllTrackIds()) continue;
                break;
            }
            if (response != null && (errorCode = ((RTSPResponse)response).getErrorCode()) == RTSPStatusCode.RTSP_OK.getStatusCode()) {
                this.keepAliveInterval = this.rtspSettings.getKeepAliveInterval();
                if (this.keepAliveInterval <= 0) {
                    this.keepAliveInterval = 500 * ((RTSPResponse)response).getResponseTimeout();
                    if (this.keepAliveInterval <= 1000) {
                        this.keepAliveInterval = 5000;
                    }
                }
                if (((RTSPResponse)response).getSessionID() != null) {
                    this.sessionID = ((RTSPResponse)response).getSessionID();
                }
                if (!this.rtspSettings.getIgnoreSSRC() && ((RTSPResponse)response).getSSRC() != null && RTSPHandlerSuper.isValidSsrc(((RTSPResponse)response).getSSRC())) {
                    this.callback.setSsrcfromRtsp(((RTSPResponse)response).getSSRC());
                } else {
                    this.logger.warn("No (valid) SSRC in the RTSP setup response for " + rtspUrl);
                }
                if (this.contentBase != null) {
                    rtspUrl = this.contentBase;
                    this.rtspSettings.setRTSPUrl(this.contentBase);
                }
                if (this.rtspSettings.haveToExecuteOperationAfterSetup()) {
                    this.rtspSettings.getStreamingVideoSourceClientRtsp().executeOperationAfterSetup();
                }
                PlayRequest playReq = new PlayRequest();
                if (this.rtspSettings.getRange() != null) {
                    playReq.init(rtspUrl, this.rtspSettings.getRange(), this.rtspSettings);
                } else {
                    playReq.init(rtspUrl, this.rtspSettings);
                }
                response = this.sendRTSPRequest(playReq);
                if (this.rtspSettings.isPrintDebug()) {
                    this.logger.info("Answer to RTSP PLAY: " + ((RTSPResponse)response).getData());
                }
                if (this.rtspSettings.isEdgeStoragePlayback() && ((RTSPResponse)response).getScale() > 0.0) {
                    this.rtspSettings.setScale(((RTSPResponse)response).getScale());
                }
                if ((errorCode = ((RTSPResponse)response).getErrorCode()) != RTSPStatusCode.RTSP_OK.getStatusCode()) {
                    this.logger.error("Starting stream failed with errorCode: " + errorCode + " for " + this.callback);
                    return -21659;
                }
                if (this.rtspSettings.haveToExecuteOperationAfterPlay()) {
                    this.rtspSettings.getStreamingVideoSourceClientRtsp().executeOperationAfterPlay();
                }
            } else {
                this.logger.error("Setting up stream failed with errorCode: " + errorCode + " for " + this.callback);
                return -21659;
            }
            this.keepAliveReader = new KeepAliveReader();
            this.keepAliveReader.init(this);
        }
        catch (SeeTecException ex) {
            if (ex.getErrorCode() != -2147483647) {
                this.logger.error("Exception while setting up RTSP stream for " + this.callback + ": " + ex.getMessage(), (Throwable)ex);
            }
            return ex.getErrorCode();
        }
        catch (Exception ex) {
            this.logger.error("Exception while setting up RTSP stream for " + this.callback + ": " + ex.getMessage(), (Throwable)ex);
            return -21659;
        }
        errorCode = errorCode == RTSPStatusCode.RTSP_OK.getStatusCode() ? 0 : errorCode;
        return errorCode;
    }

    public void shutdown() {
        try {
            TeardownRequest teardownReq = new TeardownRequest();
            teardownReq.init(this.rtspSettings.getRtspUrl(), this.rtspSettings);
            RTSPResponse responsePacket = this.sendRTSPRequest(teardownReq);
            if (responsePacket == null) {
                this.logger.warn("Error when tearing down mpeg stream for " + this);
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while tearing down stream for " + this.callback);
        }
    }

    public final void storeReceiverReportVideo(byte[] receiverReportVideo) {
        this.receiverReportVideo = new byte[receiverReportVideo.length];
        System.arraycopy(receiverReportVideo, 0, this.receiverReportVideo, 0, receiverReportVideo.length);
    }

    public final void storeReceiverReportAudio(byte[] receiverReportAudio) {
        this.receiverReportAudio = new byte[receiverReportAudio.length];
        System.arraycopy(receiverReportAudio, 0, this.receiverReportAudio, 0, receiverReportAudio.length);
    }

    public final void storeReceiverReportMetadata(byte[] receiverReportMetadata) {
        this.receiverReportMetadata = new byte[receiverReportMetadata.length];
        System.arraycopy(receiverReportMetadata, 0, this.receiverReportMetadata, 0, receiverReportMetadata.length);
    }

    public String getCommandString(int command) {
        if (command == 4) {
            return "OPTIONS";
        }
        if (command == 5) {
            return "DESCRIBE";
        }
        if (command == 6) {
            return "ANNOUNCE";
        }
        if (command == 7) {
            return "PAUSE";
        }
        if (command == 8) {
            return "PLAY";
        }
        if (command == 9) {
            return "RECORD";
        }
        if (command == 10) {
            return "REDIRECT";
        }
        if (command == 11) {
            return "SETUP";
        }
        if (command == 12) {
            return "SET_PARAMETER";
        }
        if (command == 2) {
            return "GET_PARAMETER";
        }
        if (command == 13) {
            return "TEARDOWN";
        }
        return "";
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public void setAuthenticationMethod(int authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    protected boolean resolutionMatches(int widthOnCamera, int heightOnCamera, RTSPStreamSettings rtspStreamSettings) {
        boolean result;
        if (rtspStreamSettings.getResolution().length > 1) {
            int widthFromSettings = rtspStreamSettings.getResolution()[0];
            int heightFromSettings = rtspStreamSettings.getResolution()[1];
            result = rtspStreamSettings.isCheckResolutionWidth() ? (rtspStreamSettings.isConsiderAspectRatio() ? widthFromSettings == widthOnCamera || widthFromSettings == heightOnCamera : widthFromSettings == widthOnCamera) : (rtspStreamSettings.isCheckResolution() ? (rtspStreamSettings.isConsiderAspectRatio() ? !(widthFromSettings != widthOnCamera && widthFromSettings != heightOnCamera || heightFromSettings != heightOnCamera && heightFromSettings != widthOnCamera) : widthFromSettings == widthOnCamera && heightFromSettings == heightOnCamera) : true);
        } else {
            result = true;
        }
        return result;
    }

    protected static boolean isValidSsrc(String ssrc) {
        return !ssrc.isEmpty() && !ssrc.matches("[0]+");
    }

    protected static List<String> selectAudioSetupUrl(RTSPResponse describeResponse, List<String> audioSetupUrls, Codec audioCodec) throws SeeTecException {
        ArrayList<String> result = new ArrayList<String>();
        SDPContent sdpContent = new SDPContent(describeResponse.getData(), false);
        List<SdpAudioData> sdpAudioDataList = sdpContent.getSdpAudioData();
        for (SdpAudioData sdpAudioData : sdpAudioDataList) {
            if (!sdpAudioData.getRtpmap().toLowerCase().contains("pcmu") || !audioCodec.equals((Object)Codec.G711U)) continue;
            result.add(sdpAudioData.getControl());
            return result;
        }
        return audioSetupUrls;
    }

    protected class KeepAliveReader
    implements Runnable {
        private Thread myThread = null;
        private int errorCode = 0;
        private RTSPResponse response = null;
        private String session;

        protected KeepAliveReader() {
        }

        public int init(RTSPHandlerSuper rtspHandler) {
            if (RTSPHandlerSuper.this.keepAliveMethod == null) {
                RTSPHandlerSuper.this.keepAliveMethod = RTSPHandlerSuper.this.rtspSettings.getKeepAliveMethod();
            }
            this.session = rtspHandler.sessionID;
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
            return 0;
        }

        @Override
        public void run() {
            try {
                long time = System.currentTimeMillis();
                RTSPHandlerSuper.this.keepAliveMethod = RTSPHandlerSuper.this.rtspSettings.getKeepAliveMethod();
                if (RTSPHandlerSuper.this.keepAliveUrl == null) {
                    if (RTSPHandlerSuper.this.contentBase != null) {
                        RTSPHandlerSuper.this.keepAliveUrl = RTSPHandlerSuper.this.contentBase;
                    } else {
                        RTSPHandlerSuper.this.keepAliveUrl = RTSPHandlerSuper.this.rtspSettings.getKeepAliveUrl();
                    }
                }
                while (!this.isShutdown()) {
                    if (System.currentTimeMillis() - (long)RTSPHandlerSuper.this.keepAliveInterval < time) {
                        Thread.sleep(time + (long)RTSPHandlerSuper.this.keepAliveInterval - System.currentTimeMillis());
                    }
                    if (this.isShutdown()) continue;
                    if ((RTSPHandlerSuper.this.keepAliveMethod & 1) == 1 && RTSPHandlerSuper.this.receiverReportVideo != null && (this.errorCode = RTSPHandlerSuper.this.sendReceiverReportVideo()) != 0) {
                        RTSPHandlerSuper.this.callback.onNetworkError(this.errorCode);
                    }
                    if ((RTSPHandlerSuper.this.keepAliveMethod & 4) == 4 || (RTSPHandlerSuper.this.keepAliveMethod & 2) == 2) {
                        RTSPHandlerSuper.this.keepAliveUrl = RTSPHandlerSuper.this.keepAliveUrl == null ? RTSPHandlerSuper.this.rtspSettings.getRtspUrl() : RTSPHandlerSuper.this.keepAliveUrl;
                        try {
                            if ((RTSPHandlerSuper.this.keepAliveMethod & 4) == 4) {
                                OptionsRequest keepAliveReq = new OptionsRequest(false);
                                if (this.session != null) {
                                    keepAliveReq.setSessionID(this.session);
                                }
                                keepAliveReq.init(RTSPHandlerSuper.this.keepAliveUrl, RTSPHandlerSuper.this.rtspSettings);
                                this.response = RTSPHandlerSuper.this.sendRTSPRequest(keepAliveReq);
                                if (RTSPHandlerSuper.this.rtspSettings.getKeepAliveForTimeouts() && this.response == null) {
                                    RTSPHandlerSuper.this.callback.sendStatusService(-20100);
                                }
                            }
                            if ((RTSPHandlerSuper.this.keepAliveMethod & 2) == 2) {
                                GetParameterRequest getParameterReq = new GetParameterRequest();
                                if (this.session != null) {
                                    getParameterReq.setSessionID(this.session);
                                }
                                getParameterReq.init(RTSPHandlerSuper.this.keepAliveUrl, RTSPHandlerSuper.this.rtspSettings);
                                this.response = RTSPHandlerSuper.this.sendRTSPRequest(getParameterReq);
                                if (RTSPHandlerSuper.this.rtspSettings.isShutdownOnKeepAliveError() && this.response == null || this.response.getErrorCode() == RTSPStatusCode.RTSP_SESSION_NOT_FOUND.getStatusCode()) {
                                    RTSPHandlerSuper.this.callback.onNetworkError(-20100);
                                }
                            }
                        }
                        catch (Exception e) {
                            RTSPHandlerSuper.this.logger.error("Exception while sending keepalive request for " + RTSPHandlerSuper.this.callback + ": " + e.getMessage());
                        }
                    }
                    time = System.currentTimeMillis();
                }
            }
            catch (Throwable t) {
                RTSPHandlerSuper.this.logger.error("KeepAlive exception [" + t.getMessage() + "] for " + this.session);
            }
        }

        public boolean isShutdown() {
            return RTSPHandlerSuper.this.shutdown;
        }
    }
}

