/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net.rtsp;

import de.seetec.v5.re.cm.device.shared.net.rtsp.HttpStreamListenerIntf;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpStreamHandler
extends Basic
implements Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.shared.net.rtsp.HttpStreamHandler";
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private Thread thread = null;
    private HttpStreamListenerIntf listener = null;
    private NetworkParameter networkParameter = null;
    private Socket getSocket = null;
    private Socket postSocket = null;
    private String url = null;
    private boolean useHttpPersistentDuplexTunnel = false;
    private boolean useAuthenticationForHttpTunnel = false;

    public HttpStreamHandler() {
    }

    public HttpStreamHandler(boolean useHttpPersistentDuplexTunnel, boolean useAuthenticationForHttpTunnel) {
        this.useHttpPersistentDuplexTunnel = useHttpPersistentDuplexTunnel;
        this.useAuthenticationForHttpTunnel = useAuthenticationForHttpTunnel;
    }

    public int init(HttpStreamListenerIntf listener, NetworkParameter networkParameter, String url) {
        this.listener = listener;
        if (this.listener == null || (this.networkParameter = networkParameter) == null || (this.url = url) == null) {
            return -20002;
        }
        return 0;
    }

    public final int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.getSocket != null) {
            try {
                this.getSocket.close();
            }
            catch (Throwable ex) {
                this.logger.warn("Unable to close RTSP get socket. Setting to null");
            }
            this.getSocket = null;
        }
        if (this.postSocket != null) {
            try {
                this.postSocket.close();
            }
            catch (Throwable ex) {
                this.logger.warn("Unable to close RTSP post socket. Setting to null");
            }
            this.postSocket = null;
        }
        return 0;
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public final int startStreaming(boolean asynchronous, boolean headerOnly) {
        int errorCode = 0;
        if (this.listener == null || this.networkParameter == null || this.url == null) {
            errorCode = -20002;
        } else {
            this.logger.info(Basic.generateIndentedMultiLineLog((String[])new String[]{"Starting Http Streaming with following Parameter:", "   Listener        : " + this.listener, "   NetworkParameter: " + this.networkParameter, "   URL             : [" + this.url + "]"}));
            try {
                boolean useAuthentication = this.useAuthenticationForHttpTunnel || !this.useHttpPersistentDuplexTunnel;
                this.getSocket = this.establishServerPushStream(this.networkParameter, this.url, headerOnly, useAuthentication);
                this.postSocket = this.establishPostSocket(this.networkParameter);
                this.listener.sendStatusService(0);
            }
            catch (Throwable ex) {
                errorCode = -20100;
                this.logger.error((Object)ex, ex);
                this.listener.sendStatusService(errorCode);
                return errorCode;
            }
            if (asynchronous) {
                this.thread = new Thread((Runnable)this, this.toString());
                this.thread.start();
            } else {
                errorCode = this.readHttpStream();
            }
        }
        return errorCode;
    }

    @Override
    public final void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            int errorCode = this.readHttpStream();
            if (errorCode != 0) {
                this.listener.sendStatusService(errorCode);
            }
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    private Socket establishPostSocket(NetworkParameter networkParameter) {
        try {
            this.postSocket = networkParameter.useHTTPS() ? NetworkHelper.createNetworkConnection((String)networkParameter.getHost(), (int)networkParameter.getSSLport(), (boolean)true, (int)networkParameter.getSoTimeout()) : NetworkHelper.createNetworkConnection((String)networkParameter.getHost(), (int)networkParameter.getHTTPport(), (boolean)false, (int)networkParameter.getSoTimeout());
            this.postSocket.setSoTimeout(networkParameter.getSoTimeout());
            this.logger.info(Basic.generateIndentedMultiLineLog((String[])new String[]{"Opening socket for RTSP post requests on port " + this.postSocket.getLocalPort() + " for " + this.listener + ":", "   NetworkParameter: " + networkParameter}));
            return this.postSocket;
        }
        catch (SocketException socketException) {
            this.logger.error("Error creating socket for tunneled RTSP request " + networkParameter);
        }
        catch (Exception exception) {
            this.logger.error("Unexpected error while creating socket for tunneled RTSP request " + networkParameter);
        }
        return null;
    }

    private Socket establishServerPushStream(NetworkParameter networkParameter, String url, boolean headerOnly, boolean useAuthentication) throws Exception {
        String realm = networkParameter.getRealm();
        String nonce = networkParameter.getNonce();
        String qop = networkParameter.getQop();
        String authorization = realm != null && nonce != null ? NetworkHelper.createDigestAuthorization((NetworkParameter)networkParameter, (String)realm, (String)nonce, (String)"GET", (String)url, (String)qop) : NetworkHelper.createBasicAuthorization((String[])networkParameter.getUserPWD());
        String additionalData = networkParameter.getAdditionalData() != null ? networkParameter.getAdditionalData() : "";
        String request = "GET " + url + " HTTP/1.1\r\n" + additionalData + (useAuthentication ? authorization : "") + "User-Agent: Java/1.7.0\r\nHost: " + networkParameter.getHost() + "\r\nAccept: text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2, application/x-rtsp-tunnelled\r\nConnection: keep-alive\r\n\r\n";
        Socket socket = networkParameter.useHTTPS() ? NetworkHelper.createNetworkConnection((String)networkParameter.getHost(), (int)networkParameter.getSSLport(), (boolean)true) : NetworkHelper.createNetworkConnection((String)networkParameter.getHost(), (int)networkParameter.getHTTPport(), (boolean)false);
        socket.setSoTimeout(networkParameter.getSoTimeout());
        socket.setReceiveBufferSize(262144);
        socket.setSendBufferSize(262144);
        this.logger.info(Basic.generateIndentedMultiLineLog((String[])new String[]{"Opening socket for GET requests on port " + socket.getLocalPort() + " for " + this.listener + ":", "   NetworkParameter: " + networkParameter}));
        OutputStream os = socket.getOutputStream();
        os.write(request.getBytes());
        os.flush();
        if (headerOnly) {
            InputStream is = socket.getInputStream();
            byte[] buffer = new byte[2048];
            ByteArrayOutputStream baos = new ByteArrayOutputStream(buffer.length);
            int len = is.read(buffer);
            if (len > 0) {
                baos.write(buffer, 0, len);
            }
        }
        return socket;
    }

    public Socket getPostSocket() {
        return this.postSocket;
    }

    public final String toString() {
        String sThis = this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", Listener=" + this.listener + ", " + this.networkParameter + ", " + this.getSocket + (this.useHttpPersistentDuplexTunnel ? ", " + this.postSocket : "") + ", URL=[" + this.url + "]]";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final int readHttpStream() {
        int errorCode = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[65535];
        try {
            InputStream is = this.getSocket.getInputStream();
            while (!this.isShutdown() && !this.listener.isShutdown()) {
                try {
                    baos.reset();
                    int len = is.read(buffer);
                    if (len <= 0) {
                        errorCode = -20103;
                        break;
                    }
                    baos.write(buffer, 0, len);
                    this.listener.deliverRawContent(baos.toByteArray());
                }
                catch (SocketTimeoutException ex) {
                    this.logger.warn("Timeout reading from socket after [" + this.networkParameter.getSoTimeout() + " ms] for " + this.getSocket + " / " + this);
                    if (this.networkParameter.getIgnoreSoTimeout()) continue;
                    throw ex;
                }
                catch (NullPointerException npe) {
                    this.shutdown();
                    return 0;
                }
            }
        }
        catch (IOException ex) {
            if (!this.isShutdown()) {
                this.logger.warn("Network problems for " + this + " on port " + this.getSocket.getLocalPort());
                this.listener.notifyForNetworkProblems();
            }
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
            this.logger.warn("Unexpected exception occured for " + this);
            this.listener.notifyForNetworkProblems();
        }
        try {
            if (this.getSocket != null) {
                this.getSocket.close();
                this.getSocket = null;
            }
        }
        catch (IOException ioex) {
            this.logger.warn((Object)ioex, (Throwable)ioex);
        }
        try {
            if (this.useHttpPersistentDuplexTunnel && this.postSocket != null) {
                this.postSocket.close();
                this.postSocket = null;
            }
        }
        catch (IOException ioex) {
            this.logger.warn((Object)ioex, (Throwable)ioex);
        }
        if (errorCode != 0) {
            this.listener.notifyForNetworkProblems();
        }
        return errorCode;
    }
}

