/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net.rtp;

import de.seetec.v5.shared.Basic;

public class RtpSenderPacket {
    private byte version = (byte)-128;
    private byte padding = 0;
    private byte extension = 0;
    private byte csrcCount = 0;
    private byte marker = 0;
    private byte payloadType = 0;
    byte[] content;

    public RtpSenderPacket(byte[] payload, int sequenceNumber, int timestamp, int ssrc) {
        this.content = new byte[payload.length + 12];
        this.content[0] = (byte)(this.version | this.padding | this.extension | this.csrcCount);
        this.content[1] = (byte)(this.marker | this.payloadType);
        System.arraycopy(Basic.int4ToByteArray((int)sequenceNumber), 2, this.content, 2, 2);
        System.arraycopy(Basic.int4ToByteArray((int)timestamp), 0, this.content, 4, 4);
        System.arraycopy(Basic.int4ToByteArray((int)ssrc), 0, this.content, 8, 4);
        System.arraycopy(payload, 0, this.content, 12, payload.length);
    }

    public byte[] getData() {
        byte[] ret = new byte[this.content.length];
        System.arraycopy(this.content, 0, ret, 0, this.content.length);
        return ret;
    }
}

