/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net;

import de.seetec.v5.re.cm.DeviceManagerConstantsIntf;
import de.seetec.v5.re.cm.device.shared.net.RTPoverHTTPCallback;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RTPoverHTTPHandler
implements Runnable,
DeviceManagerConstantsIntf {
    private static final byte[] MPEG4_BOUNDARY = new byte[]{36, 0};
    protected Logger logger = null;
    private Socket socket;
    private boolean isShutdown = false;
    private NetworkParameter networkParameter;
    private RTPoverHTTPCallback listener;
    private String streamingUrl;
    private Thread myThread;

    public int init(RTPoverHTTPCallback listener, NetworkParameter networkParameter, String streamingUrl) {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        this.listener = listener;
        this.networkParameter = networkParameter;
        this.streamingUrl = streamingUrl;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String authorization = "";
        try {
            authorization = NetworkHelper.createBasicAuthorization((NetworkParameter)this.networkParameter);
        }
        catch (Exception ex) {
            this.logger.error("Exception while creating Basic Authorization for " + this + ": " + ex.getMessage());
        }
        authorization = authorization == null ? "" : authorization;
        String host = this.networkParameter.getHost();
        String request = "GET " + this.streamingUrl + " HTTP/1.1\r\n" + authorization + "User-Agent: Java/1.4.2\r\nHost: " + host + "\r\nAccept: */*\r\nConnection: keep-alive\r\n\r\n";
        try {
            this.socket = this.networkParameter.useHTTPS() ? NetworkHelper.createNetworkConnection((String)host, (int)this.networkParameter.getSSLport(), (boolean)true) : NetworkHelper.createNetworkConnection((String)host, (int)this.networkParameter.getHTTPport(), (boolean)false);
            this.socket.setSoTimeout(5000);
            OutputStream os = this.socket.getOutputStream();
            os.write(request.getBytes());
            os.flush();
            InputStream is = this.socket.getInputStream();
            byte[] buffer = new byte[4096];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while (!this.isShutdown) {
                int len = is.read(buffer);
                if (len < 0) {
                    break;
                }
                baos.write(buffer, 0, len);
                int startIndex = 0;
                startIndex = this.indexOfByteArrayOutputStream(baos, MPEG4_BOUNDARY, 0, false);
                if (startIndex == -1) continue;
                byte[] lengthBytes = Arrays.copyOfRange(baos.toByteArray(), startIndex, startIndex + 2);
                int length = ((lengthBytes[0] & 0xFF) << 8) + (lengthBytes[1] & 0xFF);
                startIndex += 2;
                while (baos.size() - startIndex < length && (len = is.read(buffer)) >= 0) {
                    baos.write(buffer, 0, len);
                }
                byte[] completeBuffer = baos.toByteArray();
                baos.reset();
                this.listener.onHttpData(Arrays.copyOfRange(completeBuffer, startIndex, startIndex + length));
                if (completeBuffer.length - (startIndex + length) <= 0) continue;
                baos.write(completeBuffer, startIndex + length, completeBuffer.length - (startIndex + length));
            }
        }
        catch (Exception ex) {
            this.logger.error("Exception while reading data from " + this + ": " + ex.getMessage());
            this.onNetworkError(-20100);
        }
        finally {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException ex) {
                    this.logger.error("Exception closing audio socket for " + this + ": " + ex.getMessage());
                }
                this.socket = null;
            }
        }
        this.listener.sendStatusService(-20103);
    }

    private boolean isShutdown() {
        return this.isShutdown;
    }

    private void onNetworkError(int errorCode) {
        if (!this.isShutdown()) {
            this.logger.error("Network error: " + errorCode);
            this.listener.onNetworkError(errorCode);
        }
    }

    public int shutdown() {
        this.isShutdown = true;
        if (this.socket != null) {
            try {
                this.socket.close();
                this.socket = null;
            }
            catch (IOException ex) {
                this.logger.error("Exception while closing socket for " + this.listener + ": " + ex.getMessage());
                return -20100;
            }
        }
        return 0;
    }

    public void startStreaming() {
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.start();
    }

    private int indexOfByteArrayOutputStream(ByteArrayOutputStream baos, byte[] pattern, int offset, boolean returnIndexBeforePattern) {
        byte[] array = baos.toByteArray();
        return Basic.indexOfByteArray((byte[])array, (byte[])pattern, (int)offset, (boolean)returnIndexBeforePattern);
    }
}

