/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net;

public class DSCPCommandHandler {
    private final byte receiver;

    public DSCPCommandHandler(int destID) {
        this.receiver = (byte)destID;
    }

    private byte[] getCompleteCommand(byte[] command) {
        byte[] completeCommand = new byte[6];
        completeCommand[0] = this.receiver;
        completeCommand[1] = 0;
        System.arraycopy(command, 0, completeCommand, 2, 3);
        completeCommand[5] = (byte)(completeCommand[0] ^ completeCommand[1] ^ completeCommand[2] ^ completeCommand[3] ^ completeCommand[4]);
        return completeCommand;
    }

    public byte[] getPanCommand(int panValue) {
        int speed;
        if (panValue == 0) {
            return this.getCompleteCommand(new byte[]{19, 0, 0});
        }
        byte[] command = new byte[]{24, 0, 0};
        if (panValue < 0) {
            command[1] = 1;
        }
        speed = (speed = Math.abs(panValue) / 12500) > 7 ? 7 : speed;
        command[2] = (byte)speed;
        return this.getCompleteCommand(command);
    }

    public byte[] getTiltCommand(int tiltValue) {
        int speed;
        if (tiltValue == 0) {
            return this.getCompleteCommand(new byte[]{20, 0, 0});
        }
        byte[] command = new byte[]{24, 2, 0};
        if (tiltValue < 0) {
            command[1] = 3;
        }
        speed = (speed = Math.abs(tiltValue) / 12500) > 7 ? 7 : speed;
        command[2] = (byte)speed;
        return this.getCompleteCommand(command);
    }

    public byte[] getAddPresetCommand(long presetID) {
        return this.getCompleteCommand(new byte[]{29, 0, (byte)presetID});
    }

    public byte[] getGetPresetCommand(long presetID) {
        return this.getCompleteCommand(new byte[]{17, 0, (byte)presetID});
    }

    public byte[] getZoomDirectionCommand(int zoomValue) {
        if (zoomValue == 0) {
            return this.getCompleteCommand(new byte[]{36, 4, 0});
        }
        byte[] command = new byte[]{36, 0, 0};
        if (zoomValue > 0) {
            command[1] = 1;
        }
        return this.getCompleteCommand(command);
    }

    public byte[] getZoomSpeedCommand(int zoomValue) {
        if (zoomValue == 0) {
            return this.getCompleteCommand(new byte[]{36, 4, 0});
        }
        byte[] command = new byte[]{36, 3, 0};
        int speed = Math.abs(zoomValue) / 12500;
        speed = speed > 7 ? 7 : speed;
        command[2] = (byte)speed;
        return this.getCompleteCommand(command);
    }

    public byte[] getFocusCommand(int focusValue) {
        if (focusValue == 0) {
            return this.getCompleteCommand(new byte[]{37, 4, 0});
        }
        byte[] command = new byte[]{37, 4, 3};
        command[1] = focusValue < 0 ? (byte)1 : 0;
        return this.getCompleteCommand(command);
    }

    public byte[] getAutoFocusCommand(boolean auto) {
        if (auto) {
            return this.getCompleteCommand(new byte[]{38, 6, 0});
        }
        return this.getCompleteCommand(new byte[]{38, 7, 0});
    }

    public byte[] getIrisCommand(int direction) {
        if (direction > 0) {
            return this.getCompleteCommand(new byte[]{35, 2, 0});
        }
        if (direction < 0) {
            return this.getCompleteCommand(new byte[]{35, 3, 0});
        }
        return this.getCompleteCommand(new byte[]{18, 0, 0});
    }

    public byte[] getAutoIrisCommand(boolean value) {
        if (value) {
            return this.getCompleteCommand(new byte[]{35, 4, 0});
        }
        return this.getCompleteCommand(new byte[]{35, 6, 8});
    }
}

