/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.motiondetection;

import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetectionCnf;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.video.abus.AbusHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.acti.ActiHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.acutvista.AcutvistaHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.americandynamics.AmericanDynamicsHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.americandynamics.AmericanDynamicsHardwareMotionDetection400;
import de.seetec.v5.re.cm.device.video.aper.AperHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.arecont.ArecontHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.arh.ARHHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.avigilon.AvigilonHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.axis.AxisHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.basler.BaslerHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.bosch.BoschHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.cbc.CBCHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.convision.ConvisionHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.dahua.DahuaHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.dlink.DLinkHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.dynacolor.DynacolorHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.etrovision.EtrovisionHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.flir.FlirHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.grandeye.GrandEyeHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.grundig.GrundigHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.iqinvision.IQinVisionHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.iqle.IqleHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.jvc.JVCHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.lg.LGHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.lumenera.LumeneraHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.norbain.NorbainHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifHelper;
import de.seetec.v5.re.cm.device.video.onvif.sistore.SistoreOnvifHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.panasonic.PanasonicHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2HardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.samsung.SamsungHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.santec.SantecHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.siqura.SiquraHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.siqura.SiquraOnvifHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.sony.SonyHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.vivotek.VivotekHardwareMotionDetection;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class HardwareMotionDetection<T extends MotionDetectionHandler>
extends Basic {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.shared.HardwareMotionDetection";
    private static final Logger STATIC_LOGGER = LogManager.getLogger((String)"de.seetec.v5.re.cm.device.shared.HardwareMotionDetection");
    protected Logger logger = null;
    protected T generalHandler = null;
    private VideoSrv videoSrv = null;
    private HardwareMotionDetectionCnf[] hardwareMotionDetectionCnf = null;
    private Map<String, String> windowLatestDetection = new HashMap<String, String>();
    private Map<String, HardwareMotionDetectionCnf> windowObjects = new HashMap<String, HardwareMotionDetectionCnf>();
    private final Semaphore semaphore = new Semaphore(1);
    private long recordOnMotionDeadtime = Long.MIN_VALUE;

    protected HardwareMotionDetection() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    public static HardwareMotionDetection<? extends MotionDetectionHandler> getInstance(VideoSrv videoSrv, HardwareMotionDetectionCnf[] hardwareMotionDetectionCnf) throws SeeTecException {
        HardwareMotionDetection hardwareMotionDetection = null;
        if (videoSrv != null && videoSrv.getDevice() != null && videoSrv.getDevice().getDeviceType() != null && hardwareMotionDetectionCnf != null) {
            if (videoSrv.getDevice().getDeviceType() / 100L == 2046L || videoSrv.getDevice().getDeviceType() / 100L == 2047L) {
                hardwareMotionDetection = new EtrovisionHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() / 100L == 2006L) {
                hardwareMotionDetection = new SonyHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() / 100L == 2000L || videoSrv.getDevice().getDeviceType() / 100L == 2023L || videoSrv.getDevice().getDeviceType() == 202101L) {
                hardwareMotionDetection = new AxisHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() / 100L == 2009L) {
                hardwareMotionDetection = new ArecontHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() / 100L == 2010L) {
                hardwareMotionDetection = new ActiHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() / 100L == 2016L) {
                hardwareMotionDetection = new BaslerHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() / 100L == 2014L) {
                hardwareMotionDetection = new LumeneraHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() / 100L == 2013L) {
                hardwareMotionDetection = new IQinVisionHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() / 100L == 2017L) {
                hardwareMotionDetection = new BoschHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() / 100L == 2019L) {
                hardwareMotionDetection = new SanyoHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() / 100L == 2024L) {
                hardwareMotionDetection = new VivotekHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() / 100L == 2012L) {
                hardwareMotionDetection = new GrandEyeHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() / 100L == 2018L) {
                hardwareMotionDetection = new SamsungHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() / 100L == 2050L) {
                hardwareMotionDetection = new DLinkHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() / 100L == 2025L || videoSrv.getDevice().getDeviceType() >= 200120L && videoSrv.getDevice().getDeviceType() <= 200199L || videoSrv.getDevice().getDeviceType() / 100L == 2034L || videoSrv.getDevice().getDeviceType() >= 203800L && videoSrv.getDevice().getDeviceType() <= 203899L || videoSrv.getDevice().getDeviceType() == 200316L || videoSrv.getDevice().getDeviceType() == 200317L) {
                hardwareMotionDetection = new SantecHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() / 100L == 2003L) {
                hardwareMotionDetection = new JVCHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() / 100L == 2053L) {
                hardwareMotionDetection = new DynacolorHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() == 200100L) {
                hardwareMotionDetection = new CBCHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() / 100L == 2011L || videoSrv.getDevice().getDeviceType() / 100L == 2027L) {
                hardwareMotionDetection = new ConvisionHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() / 100L == 2028L) {
                hardwareMotionDetection = new AcutvistaHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() == 200550L) {
                hardwareMotionDetection = new Panasonic2HardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() == 200534L || videoSrv.getDevice().getDeviceType() == 200535L || videoSrv.getDevice().getDeviceType() == 200533L || videoSrv.getDevice().getDeviceType() == 200532L || videoSrv.getDevice().getDeviceType() == 200529L || videoSrv.getDevice().getDeviceType() == 200528L || videoSrv.getDevice().getDeviceType() == 200536L || videoSrv.getDevice().getDeviceType() == 200542L || videoSrv.getDevice().getDeviceType() == 200543L || videoSrv.getDevice().getDeviceType() == 200544L || videoSrv.getDevice().getDeviceType() == 200548L) {
                hardwareMotionDetection = new PanasonicHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() == 203200L || videoSrv.getDevice().getDeviceType() == 203201L || videoSrv.getDevice().getDeviceType() == 203202L || videoSrv.getDevice().getDeviceType() == 203206L) {
                hardwareMotionDetection = new SiquraHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() == 203203L || videoSrv.getDevice().getDeviceType() == 203205L || videoSrv.getDevice().getDeviceType() == 203204L) {
                hardwareMotionDetection = new SiquraOnvifHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() >= 203300L && videoSrv.getDevice().getDeviceType() <= 203399L || videoSrv.getDevice().getDeviceType() >= 204300L && videoSrv.getDevice().getDeviceType() <= 204399L) {
                hardwareMotionDetection = new AperHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() >= 200400L && videoSrv.getDevice().getDeviceType() <= 200499L || videoSrv.getDevice().getDeviceType() >= 204400L && videoSrv.getDevice().getDeviceType() <= 204499L) {
                hardwareMotionDetection = new HikvisionHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() >= 203600L && videoSrv.getDevice().getDeviceType() <= 203699L) {
                hardwareMotionDetection = new IqleHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() >= 203700L && videoSrv.getDevice().getDeviceType() <= 203799L) {
                hardwareMotionDetection = new ARHHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() >= 203900L && videoSrv.getDevice().getDeviceType() <= 203999L) {
                hardwareMotionDetection = new LGHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() >= 204150L && videoSrv.getDevice().getDeviceType() <= 204199L || videoSrv.getDevice().getDeviceType() == 204108L) {
                hardwareMotionDetection = new DynacolorHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() >= 205600L && videoSrv.getDevice().getDeviceType() <= 205699L) {
                hardwareMotionDetection = new DahuaHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() >= 204100L && videoSrv.getDevice().getDeviceType() <= 204149L) {
                hardwareMotionDetection = new GrundigHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() == 204500L || videoSrv.getDevice().getDeviceType() == 204502L || videoSrv.getDevice().getDeviceType() == 204503L || videoSrv.getDevice().getDeviceType() == 204504L) {
                hardwareMotionDetection = new AmericanDynamicsHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() == 204501L) {
                hardwareMotionDetection = new AmericanDynamicsHardwareMotionDetection400();
            } else if (videoSrv.getDevice().getDeviceType() >= 204900L && videoSrv.getDevice().getDeviceType() <= 204999L) {
                hardwareMotionDetection = new NorbainHardwareMotionDetection();
            } else if (GenericOnvifHelper.isOnvifDevice(videoSrv.getDevice().getDeviceType())) {
                hardwareMotionDetection = new GenericOnvifHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() == 202208L) {
                hardwareMotionDetection = new SistoreOnvifHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() >= 205400L && videoSrv.getDevice().getDeviceType() <= 205499L) {
                hardwareMotionDetection = new AvigilonHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() == 205500L) {
                hardwareMotionDetection = new FlirHardwareMotionDetection();
            } else if (videoSrv.getDevice().getDeviceType() >= 205700L && videoSrv.getDevice().getDeviceType() <= 205799L) {
                hardwareMotionDetection = new AbusHardwareMotionDetection();
            } else {
                STATIC_LOGGER.error("Tried to instantiate motion detection with device not supporting it.");
                throw new SeeTecException(-20003, "Error while instantiating HardwareMotionDetection.");
            }
            int errorCode = hardwareMotionDetection.init(videoSrv, hardwareMotionDetectionCnf);
            if (errorCode == 0) {
                return hardwareMotionDetection;
            }
            String mdClass = ((Object)((Object)hardwareMotionDetection)).getClass().getName();
            if (mdClass == null) {
                mdClass = "null";
            }
            STATIC_LOGGER.error("Error while instantiating " + mdClass + ". errorCode: " + errorCode);
            throw new SeeTecException(errorCode, "Error while instantiating " + mdClass + ".");
        }
        STATIC_LOGGER.error("A given parameter is null.");
        throw new SeeTecException(-21601, "Error while instantiating HardwareMotionDetection for " + videoSrv);
    }

    public abstract T getMotionDetectionHandlerInstance();

    protected int init(VideoSrv videoSrv, HardwareMotionDetectionCnf[] hardwareMotionDetectionCnf, boolean initializeHandler) {
        this.videoSrv = videoSrv;
        if (this.videoSrv == null) {
            return -21601;
        }
        this.hardwareMotionDetectionCnf = hardwareMotionDetectionCnf;
        if (hardwareMotionDetectionCnf == null) {
            return -21601;
        }
        try {
            for (HardwareMotionDetectionCnf hardwareMotionDetectionCnf1 : this.getHardwareMotionDetectionCnf()) {
                this.windowLatestDetection.put(String.valueOf(hardwareMotionDetectionCnf1.getWindow()), String.valueOf(Long.MIN_VALUE));
                this.windowObjects.put(String.valueOf(hardwareMotionDetectionCnf1.getWindow()), hardwareMotionDetectionCnf1);
            }
        }
        catch (Exception e) {
            this.logger.error("Error while reading configuration of MD windows for " + (Object)((Object)this));
            return -20036;
        }
        if (initializeHandler) {
            this.generalHandler = this.getMotionDetectionHandlerInstance();
            int errorCode = ((MotionDetectionHandler)((Object)this.generalHandler)).init(this);
            if (errorCode != 0) {
                this.logger.error("Error [" + errorCode + "] while initializing handler for " + (Object)((Object)this));
                return errorCode;
            }
        }
        return 0;
    }

    public int init(VideoSrv videoSrv, HardwareMotionDetectionCnf[] hardwareMotionDetectionCnf) {
        return this.init(videoSrv, hardwareMotionDetectionCnf, true);
    }

    public int shutdown() {
        int errorCode;
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.generalHandler != null && (errorCode = ((MotionDetectionHandler)((Object)this.generalHandler)).shutdown()) != 0) {
            this.logger.error("Error while shutting down MotionDetectionHandler. errorCode: " + errorCode);
        }
        this.windowObjects.clear();
        this.windowObjects = null;
        this.windowLatestDetection.clear();
        this.windowLatestDetection = null;
        return 0;
    }

    public VideoSrv getVideoSrv() {
        return this.videoSrv;
    }

    public HardwareMotionDetectionCnf[] getHardwareMotionDetectionCnf() {
        return this.hardwareMotionDetectionCnf;
    }

    public void evaluateWindow(int windowNumber) {
        block9: {
            if (++windowNumber >= 1) {
                try {
                    if (!this.windowObjects.containsKey(String.valueOf(windowNumber))) break block9;
                    try {
                        if (System.currentTimeMillis() > this.recordOnMotionDeadtime) {
                            this.videoSrv.checkAndStartMotionRecording(true);
                            this.recordOnMotionDeadtime = System.currentTimeMillis() + 500L;
                        }
                    }
                    catch (ConfigurationException ex) {
                        this.logger.error("Exception [" + ex.getMessage() + "] while starting motion recording for " + (Object)((Object)this));
                    }
                    long timestamp = Long.parseLong(this.windowLatestDetection.get(String.valueOf(windowNumber)));
                    try {
                        if (timestamp + this.windowObjects.get(String.valueOf(windowNumber)).getDeadTime() < System.currentTimeMillis()) {
                            this.windowLatestDetection.put(String.valueOf(windowNumber), String.valueOf(System.currentTimeMillis()));
                            this.logger.info("Window " + windowNumber + " should be evaluated for " + this.getVideoSrv());
                            this.sendEvent(this.windowObjects.get(String.valueOf(windowNumber)).getEntityID());
                        }
                    }
                    catch (ConfigurationException e) {
                        this.logger.warn("Something's wrong while reading deadtime from config. " + e.getMessage() + " for " + this.getVideoSrv());
                    }
                }
                catch (NumberFormatException nfe) {
                    this.logger.error("Error while converting number for " + this.getVideoSrv());
                }
            }
        }
    }

    public int sendEvent(long sourceID) {
        if (this.videoSrv.isShutdown() || this.videoSrv.getCore().isShutdown()) {
            this.logger.warn("Ignore event of source [" + sourceID + "] from " + (Object)((Object)this) + " because of shutdown!");
            return 0;
        }
        return this.videoSrv.getCore().sendApplicationEvent(sourceID);
    }

    public T getMotionDetectionHandler() {
        return this.generalHandler;
    }

    public abstract void notifyForNetworkProblems();

    protected abstract boolean isShutdown();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reinitializeMD() {
        if (this.semaphore.tryAcquire()) {
            try {
                this.logger.info("Re-initialize MD for " + (Object)((Object)this));
                long nanoStart = System.nanoTime();
                this.unsynchronizedReinitializeMD();
                long duration = (System.nanoTime() - nanoStart) / 1000000L;
                if (duration > 10000L) {
                    this.logger.info("Re-initialize MD lasts for [" + duration + " ms] / " + (Object)((Object)this));
                }
            }
            finally {
                this.semaphore.release();
            }
        }
    }

    private void unsynchronizedReinitializeMD() {
        if (!this.isShutdown()) {
            int errorCode;
            if (this.generalHandler != null) {
                errorCode = ((MotionDetectionHandler)((Object)this.generalHandler)).shutdown();
                if (errorCode != 0) {
                    this.logger.error("Error [" + errorCode + "] while shutting down MotionDetectionHandler for " + (Object)((Object)this));
                }
                this.generalHandler = null;
            }
            long waitTill = System.currentTimeMillis() + 10000L;
            while (!this.isShutdown() && System.currentTimeMillis() < waitTill) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
            while (!this.isShutdown()) {
                try {
                    this.logger.info("Restart MD Handler for " + (Object)((Object)this));
                    this.generalHandler = this.getMotionDetectionHandlerInstance();
                    errorCode = ((MotionDetectionHandler)((Object)this.generalHandler)).init(this);
                    if (errorCode == 0) break;
                    this.logger.error("Error [" + errorCode + "] while re-initializing handler for " + (Object)((Object)this));
                    this.generalHandler = null;
                }
                catch (Exception e) {
                    this.logger.error("Exception [" + e.getMessage() + "] while re-initializing handler for " + (Object)((Object)this));
                    this.generalHandler = null;
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception e) {
                    this.logger.debug("Error while sleeping.");
                }
            }
        }
    }

    public String toString() {
        StringBuilder finalString = new StringBuilder();
        String firstPart = super.toString();
        finalString.append("[").append(firstPart.substring(firstPart.lastIndexOf(46) + 1)).append(", ").append(this.videoSrv).append("]");
        return finalString.toString();
    }
}

