/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.metadata.capabilities;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.ColorDescriptorType;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.DataType;
import de.seetec.v5.re.cm.device.shared.onvif.metadata.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Parameter
extends JsonObject {
    private DataType dataType;
    private List<String> availableStringValues;
    private String path;
    private String name;
    private Integer minInt;
    private Integer maxInt;
    private Float minFloat;
    private Float maxFloat;
    private ColorDescriptorType colorType;

    public Parameter() {
        this.availableStringValues = new ArrayList<String>();
    }

    public Parameter(String name, String path, DataType dataType, String ... availableStringValues) {
        this.name = name;
        this.path = path;
        this.dataType = dataType;
        this.availableStringValues = new ArrayList<String>(Arrays.asList(availableStringValues));
    }

    public Parameter(String name, String path, DataType dataType, List<String> availableStringValues) {
        this.name = name;
        this.path = path;
        this.dataType = dataType;
        this.availableStringValues = availableStringValues;
    }

    public Parameter(String name, String path, String colorType, DataType dataType) {
        this.dataType = dataType;
        this.path = path;
        this.name = name;
        this.availableStringValues = new ArrayList<String>();
        this.colorType = colorType.equalsIgnoreCase("rgb") ? ColorDescriptorType.RGB : (colorType.equalsIgnoreCase("ycbcr") ? ColorDescriptorType.YCbCr : ColorDescriptorType.ColorString);
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getAvailableStringValues() {
        return this.availableStringValues;
    }

    public void addAvailableStringValues(String[] availableValues) {
        for (String value : availableValues) {
            this.addAvailableStringValue(value);
        }
    }

    public void addAvailableStringValues(List<String> availableValues) {
        availableValues.forEach(this::addAvailableStringValue);
    }

    public void addAvailableStringValue(String availableValue) {
        if (!this.availableStringValues.contains(availableValue)) {
            this.availableStringValues.add(availableValue);
        }
    }

    public void removeAvailableStringValues() {
        this.availableStringValues.clear();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getMinInt() {
        return this.minInt;
    }

    public void setMinInt(int min) {
        this.minInt = min;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getMaxInt() {
        return this.maxInt;
    }

    public void setMaxInt(int max) {
        this.maxInt = max;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Float getMinFloat() {
        return this.minFloat;
    }

    public void setMinFloat(float min) {
        this.minFloat = Float.valueOf(min);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Float getMaxFloat() {
        return this.maxFloat;
    }

    public void setMaxFloat(float max) {
        this.maxFloat = Float.valueOf(max);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ColorDescriptorType getColorType() {
        return this.colorType;
    }

    public void setColorType(ColorDescriptorType colorType) {
        this.colorType = colorType;
    }
}

