/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.metadata.capabilities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.seetec.v5.re.cm.device.shared.metadata.QmmData;
import de.seetec.v5.re.cm.device.shared.metadata.QmmDataType;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.BehaviourCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.ClassCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.ColorDescriptorType;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.HumanBodyCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.HumanFaceCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.LicensePlateInfoCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.Parameter;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.PositioningUnits;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.ShapeCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.VehicleInfoCapabilities;
import java.util.ArrayList;
import java.util.List;

@JsonPropertyOrder(value={"type", "videoSource", "positioningUnits", "capabilities"})
public class MetadataCapabilities
extends QmmData {
    private VehicleInfoCapabilities vehicleInfoCapabilities;
    private LicensePlateInfoCapabilities licensePlateInfoCapabilities;
    private HumanFaceCapabilities humanFaceCapabilities;
    private HumanBodyCapabilities humanBodyCapabilities;
    private ShapeCapabilities shapeCapabilities;
    private ClassCapabilities classCapabilities;
    private Parameter colorCapabilities;
    private PositioningUnits positioningUnits;
    private BehaviourCapabilities behaviourCapabilities;
    private long videoSource;

    public MetadataCapabilities(boolean initialize) {
        if (initialize) {
            this.vehicleInfoCapabilities = new VehicleInfoCapabilities(initialize);
            this.licensePlateInfoCapabilities = new LicensePlateInfoCapabilities(initialize);
            this.humanFaceCapabilities = new HumanFaceCapabilities(initialize);
            this.humanBodyCapabilities = new HumanBodyCapabilities(initialize);
            this.behaviourCapabilities = new BehaviourCapabilities(initialize);
            this.shapeCapabilities = new ShapeCapabilities(initialize);
            this.classCapabilities = new ClassCapabilities(initialize);
            this.colorCapabilities = new Parameter();
            this.colorCapabilities.setColorType(ColorDescriptorType.RGB);
            this.colorCapabilities.setName("Color");
            this.colorCapabilities.setPath("Object.Appearance.Color");
        }
    }

    @JsonIgnore
    public VehicleInfoCapabilities getVehicleInfoCapabilities() {
        return this.vehicleInfoCapabilities;
    }

    public void setVehicleInfoCapabilities(VehicleInfoCapabilities vehicleInfoCapabilities) {
        this.vehicleInfoCapabilities = vehicleInfoCapabilities;
    }

    @JsonIgnore
    public LicensePlateInfoCapabilities getLicensePlateInfoCapabilities() {
        return this.licensePlateInfoCapabilities;
    }

    public void setLicensePlateInfoCapabilities(LicensePlateInfoCapabilities licensePlateInfoCapabilities) {
        this.licensePlateInfoCapabilities = licensePlateInfoCapabilities;
    }

    @JsonIgnore
    public HumanFaceCapabilities getHumanFaceCapabilities() {
        return this.humanFaceCapabilities;
    }

    public void setHumanFaceCapabilities(HumanFaceCapabilities humanFaceCapabilities) {
        this.humanFaceCapabilities = humanFaceCapabilities;
    }

    @JsonIgnore
    public HumanBodyCapabilities getHumanBodyCapabilities() {
        return this.humanBodyCapabilities;
    }

    public void setHumanBodyCapabilities(HumanBodyCapabilities humanBodyCapabilities) {
        this.humanBodyCapabilities = humanBodyCapabilities;
    }

    @JsonIgnore
    public ShapeCapabilities getShapeCapabilities() {
        return this.shapeCapabilities;
    }

    public void setShapeCapabilities(ShapeCapabilities shapeCapabilities) {
        this.shapeCapabilities = shapeCapabilities;
    }

    @JsonIgnore
    public ClassCapabilities getClassCapabilities() {
        return this.classCapabilities;
    }

    public void setClassCapabilities(ClassCapabilities classCapabilities) {
        this.classCapabilities = classCapabilities;
    }

    @JsonIgnore
    public Parameter getColorCapabilities() {
        return this.colorCapabilities;
    }

    public void setColorCapabilities(Parameter colorCapabilities) {
        this.colorCapabilities = colorCapabilities;
    }

    @JsonIgnore
    public BehaviourCapabilities getBehaviourCapabilities() {
        return this.behaviourCapabilities;
    }

    public void setBehaviourCapabilities(BehaviourCapabilities behaviourCapabilities) {
        this.behaviourCapabilities = behaviourCapabilities;
    }

    public List<Parameter> getCapabilities() {
        ArrayList<Parameter> capabilities = new ArrayList<Parameter>();
        if (this.vehicleInfoCapabilities != null) {
            capabilities.addAll(this.vehicleInfoCapabilities.listParameters());
        }
        if (this.licensePlateInfoCapabilities != null) {
            capabilities.addAll(this.licensePlateInfoCapabilities.listParameters());
        }
        if (this.humanFaceCapabilities != null) {
            capabilities.addAll(this.humanFaceCapabilities.listParameters());
        }
        if (this.humanBodyCapabilities != null) {
            capabilities.addAll(this.humanBodyCapabilities.listParameters());
        }
        if (this.shapeCapabilities != null) {
            capabilities.addAll(this.shapeCapabilities.listParameters());
        }
        if (this.classCapabilities != null) {
            capabilities.addAll(this.classCapabilities.listParameters());
        }
        if (this.colorCapabilities != null) {
            capabilities.add(this.colorCapabilities);
        }
        if (this.behaviourCapabilities != null) {
            capabilities.addAll(this.behaviourCapabilities.listParameters());
        }
        while (capabilities.remove(null)) {
        }
        return capabilities;
    }

    public long getVideoSource() {
        return this.videoSource;
    }

    public void setVideoSource(long videoSource) {
        this.videoSource = videoSource;
    }

    public PositioningUnits getPositioningUnits() {
        return this.positioningUnits;
    }

    public void setPositioningUnits(PositioningUnits positioningUnits) {
        this.positioningUnits = positioningUnits;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException ex) {
            return "Unable to process JSON data: " + ex.getMessage();
        }
    }

    @Override
    @JsonProperty(value="type")
    public QmmDataType getQmmDataType() {
        return QmmDataType.capabilities;
    }
}

