/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.metadata.capabilities;

import de.seetec.v5.re.cm.device.shared.metadata.capabilities.AccessoryCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.Capability;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.DataType;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.EyeCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.EyebrowCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.FacialHairCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.HairCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.NoseCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.Parameter;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.PoseAngleCapabilities;
import java.util.ArrayList;
import java.util.List;

public class HumanFaceCapabilities
extends Capability {
    private Parameter age;
    private Parameter gender;
    private Parameter temperature;
    private Parameter complexion;
    private Parameter facialShape;
    private HairCapabilities hairCapabilities;
    private EyebrowCapabilities eyebrowCapabilities;
    private EyeCapabilities eyeCapabilities;
    private Parameter ear;
    private NoseCapabilities noseCapabilities;
    private FacialHairCapabilities facialHairCapabilities;
    private Parameter lip;
    private Parameter chin;
    private Parameter expression;
    private PoseAngleCapabilities poseAngleCapabilities;
    private List<AccessoryCapabilities> accessoryCapabilities = new ArrayList<AccessoryCapabilities>();
    private Parameter additionalFeatures;

    public HumanFaceCapabilities(boolean initialize) {
        if (initialize) {
            String[] accessories;
            this.age = new Parameter();
            this.gender = new Parameter();
            this.temperature = new Parameter();
            this.complexion = new Parameter();
            this.facialShape = new Parameter();
            this.hairCapabilities = new HairCapabilities(initialize);
            this.eyebrowCapabilities = new EyebrowCapabilities(initialize);
            this.eyeCapabilities = new EyeCapabilities(initialize);
            this.ear = new Parameter();
            this.noseCapabilities = new NoseCapabilities(initialize);
            this.facialHairCapabilities = new FacialHairCapabilities(initialize);
            this.lip = new Parameter();
            this.chin = new Parameter();
            this.expression = new Parameter();
            this.poseAngleCapabilities = new PoseAngleCapabilities(initialize);
            this.additionalFeatures = new Parameter();
            this.age.setName("Age");
            this.age.setDataType(DataType.INTEGER_RANGE);
            this.age.setMinInt(0);
            this.age.setMaxInt(200);
            this.age.setPath("Object.Appearance.HumanFace.Age");
            this.gender.setName("Gender");
            this.gender.setDataType(DataType.STRING);
            String[] genderAvailableValues = new String[]{"Male", "Female"};
            this.gender.addAvailableStringValues(genderAvailableValues);
            this.gender.setPath("Object.Appearance.HumanFace.Gender");
            this.temperature.setName("Temperature");
            this.temperature.setDataType(DataType.FLOAT);
            this.temperature.setMinFloat(278.0f);
            this.temperature.setMaxFloat(378.0f);
            this.temperature.setPath("Object.Appearance.HumanFace.Temperature");
            this.complexion.setName("Complexion");
            this.complexion.setDataType(DataType.STRING);
            String[] complexionAvailableValues = new String[]{"White", "Black", "Asian", "Other"};
            this.complexion.addAvailableStringValues(complexionAvailableValues);
            this.complexion.setPath("Object.Appearance.HumanFace.Complexion");
            this.facialShape.setName("Facialshape");
            this.facialShape.setDataType(DataType.STRING);
            String[] facialShapeAvailableValues = new String[]{"Long", "Round", "Square", "Oval", "Other"};
            this.facialShape.addAvailableStringValues(facialShapeAvailableValues);
            this.facialShape.setPath("Object.Appearance.HumanFace.FacialShape");
            this.ear.setName("Ear");
            this.ear.setDataType(DataType.STRING);
            String[] earAvailableValues = new String[]{"Round", "Pointed", "Narrow", "BroadLobe", "Other"};
            this.ear.addAvailableStringValues(earAvailableValues);
            this.ear.setPath("Object.Appearance.HumanFace.Ear");
            this.lip.setName("Lip");
            this.lip.setDataType(DataType.STRING);
            String[] lipAvailableValues = new String[]{"Full", "Medium", "Thin"};
            this.lip.addAvailableStringValues(lipAvailableValues);
            this.lip.setPath("Object.Appearance.HumanFace.Lip");
            this.chin.setName("Chin");
            this.chin.setDataType(DataType.STRING);
            String[] chinAvailableValues = new String[]{"Double", "Pointed", "Round"};
            this.chin.addAvailableStringValues(chinAvailableValues);
            this.chin.setPath("Object.Appearance.HumanFace.Chin");
            this.expression.setName("Expression");
            this.expression.setDataType(DataType.STRING);
            String[] expressionAvailableValues = new String[]{"Natural", "Smile", "RaisedEyebrows", "Squint", "Frown", "Other"};
            this.expression.addAvailableStringValues(expressionAvailableValues);
            this.expression.setPath("Object.Appearance.HumanFace.Expression");
            for (String accessorieName : accessories = new String[]{"Opticals", "Hat", "Mask", "Hijab", "Helmet", "Kerchief", "RightEyePatch", "LeftEyePatch"}) {
                AccessoryCapabilities accessoryCapability = new AccessoryCapabilities(accessorieName);
                accessoryCapability.setPath("Object.Appearance.HumanFace.Accesories." + accessorieName);
                this.accessoryCapabilities.add(accessoryCapability);
            }
            this.additionalFeatures.setDataType(DataType.STRING);
            this.additionalFeatures.setName("Additional features");
            String[] additionalFeaturesAvailableValues = new String[]{"Scar", "Mole", "Tattoo", "Freckles"};
            this.additionalFeatures.addAvailableStringValues(additionalFeaturesAvailableValues);
            this.additionalFeatures.setPath("Object.Appearance.HumanFace.AdditionalFeatures");
        }
    }

    public Parameter getAge() {
        return this.age;
    }

    public void setAge(Parameter age) {
        this.age = age;
    }

    public Parameter getGender() {
        return this.gender;
    }

    public void setGender(Parameter gender) {
        this.gender = gender;
    }

    public Parameter getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Parameter temperature) {
        this.temperature = temperature;
    }

    public Parameter getComplexion() {
        return this.complexion;
    }

    public void setComplexion(Parameter complexion) {
        this.complexion = complexion;
    }

    public Parameter getFacialShape() {
        return this.facialShape;
    }

    public void setFacialShape(Parameter facialShape) {
        this.facialShape = facialShape;
    }

    public HairCapabilities getHairCapabilities() {
        return this.hairCapabilities;
    }

    public void setHairCapabilities(HairCapabilities hairCapabilities) {
        this.hairCapabilities = hairCapabilities;
    }

    public EyebrowCapabilities getEyebrowCapabilities() {
        return this.eyebrowCapabilities;
    }

    public void setEyebrowCapabilities(EyebrowCapabilities eyebrowCapabilities) {
        this.eyebrowCapabilities = eyebrowCapabilities;
    }

    public EyeCapabilities getEyeCapabilities() {
        return this.eyeCapabilities;
    }

    public void setEyeCapabilities(EyeCapabilities eyeCapabilities) {
        this.eyeCapabilities = eyeCapabilities;
    }

    public Parameter getEar() {
        return this.ear;
    }

    public void setEar(Parameter ear) {
        this.ear = ear;
    }

    public NoseCapabilities getNoseCapabilities() {
        return this.noseCapabilities;
    }

    public void setNoseCapabilities(NoseCapabilities noseCapabilities) {
        this.noseCapabilities = noseCapabilities;
    }

    public FacialHairCapabilities getFacialHairCapabilities() {
        return this.facialHairCapabilities;
    }

    public void setFacialHairCapabilities(FacialHairCapabilities facialHairCapabilities) {
        this.facialHairCapabilities = facialHairCapabilities;
    }

    public Parameter getLip() {
        return this.lip;
    }

    public void setLip(Parameter lip) {
        this.lip = lip;
    }

    public Parameter getChin() {
        return this.chin;
    }

    public void setChin(Parameter chin) {
        this.chin = chin;
    }

    public Parameter getExpression() {
        return this.expression;
    }

    public void setExpression(Parameter expression) {
        this.expression = expression;
    }

    public PoseAngleCapabilities getPoseAngleCapabilities() {
        return this.poseAngleCapabilities;
    }

    public void setPoseAngleCapabilities(PoseAngleCapabilities poseAngleCapabilities) {
        this.poseAngleCapabilities = poseAngleCapabilities;
    }

    public Parameter getAdditionalFeatures() {
        return this.additionalFeatures;
    }

    public void setAdditionalFeatures(Parameter additionalFeatures) {
        this.additionalFeatures = additionalFeatures;
    }

    public List<AccessoryCapabilities> getAccessoryCapabilities() {
        return this.accessoryCapabilities;
    }

    public void addAccessoryCapabilitie(AccessoryCapabilities accessoryCapability) {
        this.accessoryCapabilities.add(accessoryCapability);
    }

    public List<Parameter> listParameters() {
        ArrayList<Parameter> allParameters = new ArrayList<Parameter>();
        allParameters.add(this.additionalFeatures);
        allParameters.add(this.age);
        allParameters.add(this.chin);
        allParameters.add(this.complexion);
        allParameters.add(this.ear);
        allParameters.add(this.expression);
        allParameters.add(this.facialShape);
        allParameters.add(this.facialShape);
        allParameters.add(this.gender);
        allParameters.add(this.lip);
        allParameters.add(this.temperature);
        if (this.accessoryCapabilities != null) {
            for (AccessoryCapabilities accessoryCapability : this.accessoryCapabilities) {
                if (accessoryCapability == null) continue;
                allParameters.addAll(accessoryCapability.listParameters());
            }
        }
        if (this.eyeCapabilities != null) {
            allParameters.addAll(this.eyeCapabilities.listParameters());
        }
        if (this.eyebrowCapabilities != null) {
            allParameters.addAll(this.eyebrowCapabilities.listParameters());
        }
        if (this.facialHairCapabilities != null) {
            allParameters.addAll(this.facialHairCapabilities.listParameters());
        }
        if (this.hairCapabilities != null) {
            allParameters.addAll(this.hairCapabilities.listParameters());
        }
        if (this.noseCapabilities != null) {
            allParameters.addAll(this.noseCapabilities.listParameters());
        }
        if (this.poseAngleCapabilities != null) {
            allParameters.addAll(this.poseAngleCapabilities.listParameters());
        }
        allParameters.addAll(this.getExtensions());
        return allParameters;
    }
}

