/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.metadata;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.seetec.v5.re.cm.QognifyMetadataManagerRepository;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.metadata.Metadata;
import de.seetec.v5.re.cm.device.shared.metadata.QmmData;
import de.seetec.v5.re.cm.device.shared.metadata.QmmDataType;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.MetadataCapabilities;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.ConfigurationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zeromq.SocketType;
import org.zeromq.ZCert;
import org.zeromq.ZContext;
import org.zeromq.ZFrame;
import org.zeromq.ZMQ;
import org.zeromq.ZMsg;

public class MetadataReader
extends Basic
implements Runnable {
    private static final String CLASSNAME = "de.seetec.v5.re.dm.device.shared.MetadataReader";
    private static final int HIGHWATERMARK = 1000000;
    private static final int RECONNECT_INTERVALL = 10000;
    private static final int HEARTBEAT_INTERVALL = 1000000;
    private static final int RETRY_INTERVALL = 30000;
    private static final int WAITING_INTERVALL = 10;
    private static final long OBJECT_AGE_FOR_CLEANUP = 10000L;
    private static final long CLEANUP_INTERVALL = TimeUnit.MINUTES.toMillis(1L);
    private Logger logger = null;
    private Device device = null;
    private long lastCleanUp;
    private Map<Integer, Long> sentObjects = new HashMap<Integer, Long>();
    private final List<QmmData> qmmDataQueue = new ArrayList<QmmData>();
    private Thread myThread;
    private final QognifyMetadataManagerRepository qognifyMetadataManagerRepository;
    private String localIp;

    public MetadataReader(QognifyMetadataManagerRepository qognifyMetadataManagerRepository) {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        this.qognifyMetadataManagerRepository = qognifyMetadataManagerRepository;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public int init(Device device) {
        int errorCode = 0;
        this.device = device;
        if (this.device == null) {
            errorCode = -21601;
        }
        try {
            this.localIp = this.device.getDeviceCnf().getNetworkParameter().getLocalServerAddress();
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Exception while getting local configuration. Sender IP Address will not be shown to receiver for " + this);
        }
        this.myThread = new Thread(this);
        this.myThread.start();
        return errorCode;
    }

    public Device getDevice() {
        return this.device;
    }

    public int shutdown() {
        this.isShutdown(CLASSNAME);
        return 0;
    }

    public void deliverMetadata(QmmData qmmData) {
        this.qmmDataQueue.add(qmmData);
    }

    public void deliverMetadata(List<QmmData> qmmDataList) {
        this.qmmDataQueue.addAll(qmmDataList);
    }

    protected void sendMetadataCapabilities(String metadataCapabilities) throws Exception {
        try (ZContext context = new ZContext();){
            ZMQ.Socket socket = context.createSocket(SocketType.DEALER);
            socket.setHWM(1000000);
            socket.setReconnectIVL(10000);
            socket.setHeartbeatIvl(1000000);
            if (this.qognifyMetadataManagerRepository.getMetadataManager().getMetadataReceiverPublicKey() != null) {
                socket.setCurveServer(false);
                ZCert certificate = new ZCert();
                certificate.apply(socket);
                byte[] key = Basic.hexStringToByteArray((String)this.qognifyMetadataManagerRepository.getMetadataManager().getMetadataReceiverPublicKey());
                socket.setCurveServerKey(key);
            }
            socket.connect("tcp://" + this.qognifyMetadataManagerRepository.getMetadataManager().getMetadataReceiverIp() + ":" + this.qognifyMetadataManagerRepository.getMetadataManager().getMetadataReceiverPort());
            ZMsg message = new ZMsg();
            message.add(new ZFrame(this.localIp));
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            String metadataAsJson = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)metadataCapabilities);
            this.logger.info(metadataAsJson);
            message.add(new ZFrame(metadataAsJson));
            message.send(socket, false);
            socket.disconnect("tcp://" + this.qognifyMetadataManagerRepository.getMetadataManager().getMetadataReceiverIp() + ":" + this.qognifyMetadataManagerRepository.getMetadataManager().getMetadataReceiverPort());
        }
        catch (Exception ex) {
            this.logger.error("Error while sending metadata capabilities for " + this.device + " : " + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public void run() {
        if (this.qognifyMetadataManagerRepository.getMetadataManager().getMetadataReceiverPublicKey() == null) {
            this.logger.warn("Encryption is disabled for metadata sending for " + this);
        }
        while (!this.isShutdown(CLASSNAME)) {
            try {
                ZContext context = new ZContext();
                Throwable throwable = null;
                try {
                    ZMQ.Socket socket = context.createSocket(SocketType.DEALER);
                    socket.setHWM(1000000);
                    socket.setReconnectIVL(10000);
                    socket.setHeartbeatIvl(1000000);
                    socket.setSendTimeOut(5000);
                    if (this.qognifyMetadataManagerRepository.getMetadataManager().getMetadataReceiverPublicKey() != null) {
                        socket.setCurveServer(false);
                        ZCert certificate = new ZCert();
                        certificate.apply(socket);
                        byte[] key = Basic.hexStringToByteArray((String)this.qognifyMetadataManagerRepository.getMetadataManager().getMetadataReceiverPublicKey());
                        socket.setCurveServerKey(key);
                    }
                    socket.connect("tcp://" + this.qognifyMetadataManagerRepository.getMetadataManager().getMetadataReceiverIp() + ":" + this.qognifyMetadataManagerRepository.getMetadataManager().getMetadataReceiverPort());
                    while (!this.isShutdown(CLASSNAME)) {
                        if (!this.qmmDataQueue.isEmpty()) {
                            QmmData qmmObject = this.qmmDataQueue.remove(0);
                            if (qmmObject == null) continue;
                            String dataAsJson = "";
                            if (qmmObject.getQmmDataType() == QmmDataType.capabilities) {
                                MetadataCapabilities metadataCapabilities = (MetadataCapabilities)qmmObject;
                                dataAsJson = metadataCapabilities.toString();
                            } else if (qmmObject.getQmmDataType() == QmmDataType.metadata) {
                                Metadata metadata = (Metadata)qmmObject;
                                metadata.insertContentClass();
                                dataAsJson = metadata.toJson();
                                if (!metadata.containsObjectClassification() && !this.sentObjects.containsKey(metadata.getMetadataObject().getObjectId())) continue;
                                if (metadata.isTrackingInfo() && !this.sentObjects.containsKey(metadata.getMetadataObject().getObjectId())) {
                                    this.sentObjects.put(metadata.getMetadataObject().getObjectId(), System.currentTimeMillis());
                                } else {
                                    this.sentObjects.replace(metadata.getMetadataObject().getObjectId(), System.currentTimeMillis());
                                }
                            }
                            ZMsg message = new ZMsg();
                            message.add(new ZFrame(this.localIp));
                            message.add(new ZFrame(dataAsJson));
                            boolean result = message.send(socket, false);
                            if (this.isDebugLogging()) {
                                this.logger.info(dataAsJson);
                            }
                            if (!result) {
                                this.logger.info("Error while sending metadata for " + this + " Will restart connection");
                                break;
                            }
                            if (System.currentTimeMillis() - this.lastCleanUp <= CLEANUP_INTERVALL) continue;
                            this.cleanupListOfSentObjectData();
                            this.lastCleanUp = System.currentTimeMillis();
                            continue;
                        }
                        Thread.sleep(10L);
                    }
                    socket.disconnect("tcp://" + this.qognifyMetadataManagerRepository.getMetadataManager().getMetadataReceiverIp() + ":" + this.qognifyMetadataManagerRepository.getMetadataManager().getMetadataReceiverPort());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (context == null) continue;
                    if (throwable != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    context.close();
                }
            }
            catch (Exception ex) {
                try {
                    this.logger.error("Error while sending metadata for " + this.device + " : " + ex.getMessage(), (Throwable)ex);
                    Thread.sleep(30000L);
                }
                catch (Exception exception) {}
            }
        }
    }

    private void cleanupListOfSentObjectData() {
        this.sentObjects.entrySet().removeIf(entry -> (Long)entry.getValue() < System.currentTimeMillis() - 10000L);
    }

    protected boolean isDebugLogging() {
        try {
            return this.device.getCore().getDmCnfMgr().getObjectMetadataDebugLogging();
        }
        catch (Exception ex) {
            return false;
        }
    }
}

